/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.charts.ui.CSVExportPlan;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.StringEscapeUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.db.request.Read;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.modelBrowser2.label.SubscriptionItemLabelRule;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class CSVExportPage
extends WizardPage {
    CSVExportPlan exportModel;
    CCombo model;
    Table item;
    Button selectAllItems;
    SelectionAdapter selectAllItemsListener;
    CCombo exportLocation;
    CCombo decimalSeparator;
    CCombo columnSeparator;
    CCombo sampling;
    Text timeStep;
    Text startTime;
    Text timeStamps;
    CCombo samplingMode;
    Text singlePrecision;
    Text doublePrecision;
    Group resampling;
    Collection<Resource> initialSelection;
    List<Pair<NamedResource, List<NamedResource>>> models = new ArrayList<Pair<NamedResource, List<NamedResource>>>();
    private Button overwrite;
    ModifyListener m = e -> this.validatePage();
    SelectionListener s = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CSVExportPage.this.validatePage();
        }
    };

    protected CSVExportPage(CSVExportPlan model) {
        super("Export CSV Data", "Define Export Properties", null);
        this.exportModel = model;
    }

    public void createControl(Composite parent) {
        DecimalSeparator s;
        ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite container = new Composite((Composite)scroller, 0);
        scroller.setContent((Control)container);
        GridLayoutFactory.swtDefaults().spacing(20, 10).numColumns(3).applyTo(container);
        new Label(container, 0).setText("Select a model:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the Model To Export From");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        new Label(container, 0).setText("Exported items:");
        this.item = new Table(container, 67618);
        this.item.setToolTipText("Selects the Subscription Items");
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(-1, 105).applyTo((Control)this.item);
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem it;
                    Object[] selected = CSVExportPage.this.item.getSelection();
                    boolean checkedWasSelected = Arrays.contains((Object[])selected, (Object)(it = (TableItem)e.item));
                    if (checkedWasSelected) {
                        boolean check = it.getChecked();
                        Object[] objectArray = selected;
                        int n = selected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object i = objectArray[n2];
                            i.setChecked(check);
                            ++n2;
                        }
                    }
                    int checked = CSVExportPage.this.countCheckedItems(CSVExportPage.this.item);
                    int totalItems = CSVExportPage.this.item.getItemCount();
                    CSVExportPage.this.updateSelectAll(checked > 0, checked < totalItems, false);
                    CSVExportPage.this.validatePage();
                }
            }
        });
        new Label(container, 0);
        this.selectAllItems = new Button(container, 32);
        this.selectAllItems.setText("&Select All");
        this.selectAllItems.setToolTipText("Select/Deselect All Listed Subscription Items");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.selectAllItems);
        this.selectAllItemsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean select = CSVExportPage.this.selectAllItems.getSelection();
                CSVExportPage.this.updateSelectAll(select, false, false);
                CSVExportPage.this.item.setRedraw(false);
                TableItem[] tableItemArray = CSVExportPage.this.item.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem it = tableItemArray[n2];
                    it.setChecked(select);
                    ++n2;
                }
                CSVExportPage.this.item.setRedraw(true);
                CSVExportPage.this.validatePage();
            }
        };
        this.selectAllItems.addSelectionListener((SelectionListener)this.selectAllItemsListener);
        new Label(container, 0).setText("&Output file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        this.exportLocation.addModifyListener(this.m);
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(CSVExportPage.this.getShell(), 8192);
                dialog.setText("Choose Output File");
                dialog.setFilterPath(new File(CSVExportPage.this.exportLocation.getText()).getParent());
                dialog.setFilterExtensions(new String[]{"*.csv"});
                dialog.setFilterNames(new String[]{"Comma separated values (*.csv)"});
                dialog.setOverwrite(false);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                CSVExportPage.this.exportLocation.setText(file);
                CSVExportPage.this.validatePage();
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        new Label(container, 0).setText("&Decimal separator:");
        this.decimalSeparator = new CCombo(container, 2056);
        DecimalSeparator[] decimalSeparatorArray = DecimalSeparator.values();
        int n = decimalSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = decimalSeparatorArray[n2];
            this.decimalSeparator.add(s.label);
            ++n2;
        }
        this.decimalSeparator.select(0);
        this.decimalSeparator.addSelectionListener(this.s);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.decimalSeparator);
        new Label(container, 0).setText("&Column separator:");
        this.columnSeparator = new CCombo(container, 2056);
        decimalSeparatorArray = ColumnSeparator.values();
        n = decimalSeparatorArray.length;
        n2 = 0;
        while (n2 < n) {
            s = decimalSeparatorArray[n2];
            this.columnSeparator.add(s.label);
            ++n2;
        }
        this.columnSeparator.select(0);
        this.columnSeparator.addSelectionListener(this.s);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.columnSeparator);
        new Label(container, 0).setText("Sampling:");
        this.sampling = new CCombo(container, 2056);
        this.sampling.add("Recorded samples");
        this.sampling.add("Resampled");
        this.sampling.select(0);
        this.sampling.addSelectionListener(this.s);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.sampling);
        this.resampling = new Group(container, 0);
        this.resampling.setText("Resampling settings (not used with recorded samples)");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.resampling);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this.resampling);
        new Label((Composite)this.resampling, 0).setText("&Start time:");
        this.startTime = new Text((Composite)this.resampling, 2048);
        this.startTime.addModifyListener(this.m);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.startTime);
        new Label((Composite)this.resampling, 0).setText(" seconds");
        new Label((Composite)this.resampling, 0).setText("&Time step:");
        this.timeStep = new Text((Composite)this.resampling, 2048);
        this.timeStep.addModifyListener(this.m);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.timeStep);
        new Label((Composite)this.resampling, 0).setText(" seconds");
        new Label((Composite)this.resampling, 0).setText("Sampling mode:");
        this.samplingMode = new CCombo((Composite)this.resampling, 2056);
        this.samplingMode.add("Linear interpolation");
        this.samplingMode.add("Previous sample");
        this.samplingMode.select(0);
        this.samplingMode.addSelectionListener(this.s);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.samplingMode);
        Group digits = new Group(container, 0);
        digits.setText("Significant digits");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)digits);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)digits);
        new Label((Composite)digits, 0).setText("&Time stamps:");
        this.timeStamps = new Text((Composite)digits, 2048);
        this.timeStamps.addModifyListener(this.m);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.timeStamps);
        new Label((Composite)digits, 0).setText("&Single precision floating point:");
        this.singlePrecision = new Text((Composite)digits, 2048);
        this.singlePrecision.addModifyListener(this.m);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.singlePrecision);
        new Label((Composite)digits, 0).setText("&Double precision floating point:");
        this.doublePrecision = new Text((Composite)digits, 2048);
        this.doublePrecision.addModifyListener(this.m);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.doublePrecision);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(this.exportModel.overwrite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVExportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.model.addSelectionListener(this.s);
        scroller.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)scroller);
        this.validatePage();
    }

    void updateSelectAll(boolean checked, boolean gray, boolean notify) {
        if (checked) {
            this.selectAllItems.setText("Select None");
        } else {
            this.selectAllItems.setText("Select All");
        }
        if (!notify) {
            this.selectAllItems.removeSelectionListener((SelectionListener)this.selectAllItemsListener);
        }
        this.selectAllItems.setGrayed(checked && gray);
        this.selectAllItems.setSelection(checked);
        if (!notify) {
            this.selectAllItems.addSelectionListener((SelectionListener)this.selectAllItemsListener);
        }
    }

    protected int countCheckedItems(Table table) {
        int ret = 0;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ret += item.getChecked() ? 1 : 0;
            ++n2;
        }
        return ret;
    }

    private void initializeData() throws DatabaseException {
        ScopedPreferenceStore csvnode = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
        Double startTime = csvnode.getDouble("csv.start");
        Double timeStep = csvnode.getDouble("csv.step");
        String decimalSeparator = csvnode.getString("csv.decimal.separator");
        String columnSeparator = StringEscapeUtils.unescape((String)csvnode.getString("csv.value.separator"));
        Boolean resample = csvnode.getBoolean("csv.resample");
        String samplingModePreference = csvnode.getString("csv.sampling.mode");
        int timeDigits = csvnode.getInt("csv.format.time.digits");
        int floatDigits = csvnode.getInt("csv.format.float.digits");
        int doubleDigits = csvnode.getInt("csv.format.double.digits");
        this.initialSelection = ISelectionUtils.getPossibleKeys((Object)this.exportModel.selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        this.models = (List)this.exportModel.sessionContext.getSession().syncRequest((Read)new UniqueRead<List<Pair<NamedResource, List<NamedResource>>>>(){

            public List<Pair<NamedResource, List<NamedResource>>> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                ArrayList<Pair<NamedResource, List<NamedResource>>> result = new ArrayList<Pair<NamedResource, List<NamedResource>>>();
                for (Resource model : (Collection)graph.syncRequest((Read)new ProjectModels(Simantics.getProjectResource()))) {
                    String name = (String)graph.getPossibleRelatedValue(model, L0.HasName, (Binding)Bindings.STRING);
                    if (name == null) continue;
                    name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)model);
                    ArrayList<NamedResource> subs = new ArrayList<NamedResource>();
                    for (Resource item : ModelingUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)MOD.Subscription_Item)) {
                        SubscriptionItemLabelRule rule;
                        Map map;
                        String label;
                        String subscriptionLabel = null;
                        Resource subscription = graph.getPossibleObject(item, L0.PartOf);
                        if (subscription != null) {
                            subscriptionLabel = (String)graph.getPossibleRelatedValue(subscription, L0.HasLabel, (Binding)Bindings.STRING);
                        }
                        if ((label = (String)(map = (rule = new SubscriptionItemLabelRule()).getLabel(graph, (Object)item)).get("single")) == null) continue;
                        if (subscriptionLabel != null) {
                            label = String.valueOf(subscriptionLabel) + "/" + label;
                        }
                        subs.add(new NamedResource(label, item));
                    }
                    subs.sort((o1, o2) -> AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName()));
                    result.add((Pair<NamedResource, List<NamedResource>>)new Pair((Object)new NamedResource(name, model), subs));
                }
                return result;
            }
        });
        Set selected = (Set)this.exportModel.sessionContext.getSession().syncRequest((Read)new UniqueRead<Set<NamedResource>>(){

            public Set<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                if (CSVExportPage.this.initialSelection == null) {
                    return Collections.emptySet();
                }
                HashSet<NamedResource> result = new HashSet<NamedResource>();
                for (Pair<NamedResource, List<NamedResource>> p : CSVExportPage.this.models) {
                    for (NamedResource nr : (List)p.second) {
                        for (Resource i : CSVExportPage.this.initialSelection) {
                            if (!((Boolean)graph.syncRequest((Read)new IsParent(i, nr.getResource()))).booleanValue()) continue;
                            result.add(nr);
                        }
                    }
                }
                return result;
            }
        });
        int i = 0;
        while (i < this.models.size()) {
            Pair<NamedResource, List<NamedResource>> p = this.models.get(i);
            this.model.add(((NamedResource)p.first).getName());
            boolean hasInitial = false;
            for (NamedResource nr : (List)p.second) {
                if (!selected.contains(nr)) continue;
                hasInitial = true;
            }
            if (hasInitial) {
                this.model.select(i);
                this.item.removeAll();
                this.exportModel.items.clear();
                int index = 0;
                int firstIndex = 0;
                for (NamedResource nr : (List)p.second) {
                    TableItem ti = new TableItem(this.item, 0);
                    ti.setText(nr.getName());
                    ti.setData((Object)nr);
                    if (selected.contains(nr)) {
                        this.exportModel.items.add(nr.getResource());
                        ti.setChecked(true);
                        if (firstIndex == 0) {
                            firstIndex = index;
                        }
                    }
                    ++index;
                }
                this.item.setTopIndex(firstIndex);
                this.item.setData(p.first);
            }
            ++i;
        }
        this.decimalSeparator.select(DecimalSeparator.fromPreference((String)decimalSeparator).ordinal());
        this.columnSeparator.select(ColumnSeparator.fromPreference((String)columnSeparator).ordinal());
        if (resample.booleanValue()) {
            this.sampling.select(1);
        } else {
            this.sampling.select(0);
        }
        this.samplingMode.select(ExportInterpolation.fromPreference((String)samplingModePreference).index());
        this.startTime.setText("" + startTime);
        this.timeStep.setText("" + timeStep);
        this.timeStamps.setText("" + timeDigits);
        this.singlePrecision.setText("" + floatDigits);
        this.doublePrecision.setText("" + doubleDigits);
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        if (this.exportLocation.getItemCount() > 0) {
            this.exportLocation.select(0);
        }
    }

    Integer validInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Double validDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Pair<NamedResource, List<NamedResource>> getModel(String name) {
        for (Pair<NamedResource, List<NamedResource>> data : this.models) {
            if (!((NamedResource)data.first).getName().equals(name)) continue;
            return data;
        }
        return null;
    }

    void validatePage() {
        boolean resample = this.sampling.getText().equals("Resampled");
        if (resample) {
            this.resampling.setText("Resampling settings");
            this.timeStep.setEnabled(true);
            this.startTime.setEnabled(true);
            this.samplingMode.setEnabled(true);
        } else {
            this.resampling.setText("Resampling settings (not used with recorded samples)");
            this.timeStep.setEnabled(false);
            this.startTime.setEnabled(false);
            this.samplingMode.setEnabled(false);
        }
        String selectedModel = this.model.getText();
        Pair<NamedResource, List<NamedResource>> p = this.getModel(selectedModel);
        if (p != null) {
            HashSet<Resource> checked = new HashSet<Resource>();
            NamedResource existing = (NamedResource)this.item.getData();
            if (!((NamedResource)p.first).equals((Object)existing)) {
                this.item.removeAll();
                for (NamedResource nr : (List)p.second) {
                    TableItem ti = new TableItem(this.item, 0);
                    ti.setText(nr.getName());
                    ti.setData((Object)nr);
                }
                this.item.setData(p.first);
            }
            TableItem[] tableItemArray = this.item.getItems();
            int ti = tableItemArray.length;
            int n = 0;
            while (n < ti) {
                TableItem ti2 = tableItemArray[n];
                if (ti2.getChecked()) {
                    checked.add(((NamedResource)ti2.getData()).getResource());
                }
                ++n;
            }
            this.exportModel.items = checked;
        }
        Double validStartTime = this.validDouble(this.startTime.getText());
        Double validStepSize = this.validDouble(this.timeStep.getText());
        if (resample) {
            if (validStartTime == null) {
                this.setErrorMessage("Start time must be a number.");
                this.setPageComplete(false);
                return;
            }
            if (validStepSize == null) {
                this.setErrorMessage("Step size must be a number.");
                this.setPageComplete(false);
                return;
            }
            if (validStepSize <= 0.0) {
                this.setErrorMessage("Step size must be greater than 0.");
                this.setPageComplete(false);
                return;
            }
        } else if (this.exportModel.items.size() > 1) {
            this.setErrorMessage("Recorded samples can only be exported for a single subscription item.");
            this.setPageComplete(false);
            return;
        }
        if (this.item.getItemCount() == 0) {
            this.setErrorMessage("No subscription items in selected model.");
            this.setPageComplete(false);
            return;
        }
        if (this.exportModel.items.isEmpty()) {
            this.setErrorMessage("No items selected for export.");
            this.setPageComplete(false);
            return;
        }
        String exportLoc = this.exportLocation.getText();
        if (exportLoc.isEmpty()) {
            this.setErrorMessage("Select output file.");
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.isDirectory()) {
            this.setErrorMessage("The output file is a directory.");
            this.setPageComplete(false);
            return;
        }
        File parent = file.getParentFile();
        if (parent == null || !parent.isDirectory()) {
            this.setErrorMessage("The output directory does not exist.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.columnSeparator = ColumnSeparator.fromIndex((int)this.columnSeparator.getSelectionIndex());
        this.exportModel.decimalSeparator = DecimalSeparator.fromIndex((int)this.decimalSeparator.getSelectionIndex());
        if (this.exportModel.columnSeparator.preference.equals(this.exportModel.decimalSeparator.preference)) {
            this.setErrorMessage("Decimal and column separator cannot be the same character.");
            this.setPageComplete(false);
            return;
        }
        Integer validTimeDigits = this.validInteger(this.timeStamps.getText());
        if (validTimeDigits == null) {
            this.setErrorMessage("Time stamps needs to be an integer number.");
            this.setPageComplete(false);
            return;
        }
        Integer validSinglePrecision = this.validInteger(this.singlePrecision.getText());
        if (validSinglePrecision == null) {
            this.setErrorMessage("Single precision needs to be an integer number.");
            this.setPageComplete(false);
            return;
        }
        Integer validDoublePrecision = this.validInteger(this.doublePrecision.getText());
        if (validDoublePrecision == null) {
            this.setErrorMessage("Double precision needs to be an integer number.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.exportLocation = file;
        this.exportModel.overwrite = this.overwrite.getSelection();
        this.exportModel.startTime = validStartTime;
        this.exportModel.timeStep = validStepSize;
        this.exportModel.resample = this.sampling.getSelectionIndex() == 1;
        this.exportModel.samplingMode = ExportInterpolation.fromIndex((int)this.samplingMode.getSelectionIndex());
        this.exportModel.timeDigits = validTimeDigits;
        this.exportModel.floatDigits = validSinglePrecision;
        this.exportModel.doubleDigits = validDoublePrecision;
        this.setErrorMessage(null);
        this.setMessage("Press Finish to export subscription data.");
        this.setPageComplete(true);
    }
}

