/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSerializer;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ResourceUID;
import org.simantics.db.service.SerialisationSupport;

public class SerialisationSupportImpl
implements SerialisationSupport {
    private final SessionImplSocket session;
    private final SessionImplSocket.ResourceSerializerImpl serializer;

    SerialisationSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.serializer = session.resourceSerializer;
    }

    public ResourceSerializer getResourceSerializer() {
        return this.serializer;
    }

    public long getRandomAccessId(int id) {
        try {
            return this.serializer.createRandomAccessId(id);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
        return 0L;
    }

    public int getTransientId(Resource resource) throws DatabaseException {
        return this.serializer.getTransientId(resource);
    }

    public Resource getResource(long randomAccessId) throws DatabaseException {
        return this.serializer.getResource(randomAccessId);
    }

    public int getTransientId(long randomAccessId) throws DatabaseException {
        return this.serializer.getTransientId(randomAccessId);
    }

    public long getRandomAccessId(Resource resource) throws DatabaseException {
        return this.serializer.getRandomAccessId(resource);
    }

    public Resource getResource(int transientId) throws DatabaseException {
        return this.session.getResource(transientId);
    }

    public ResourceUID getUID(Resource resource) throws DatabaseException {
        ResourceImpl impl = (ResourceImpl)resource;
        int resourceKey = impl.id;
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(resourceKey));
        return cluster.clusterUID.toRID((int)ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey));
    }

    public Resource getResource(ResourceUID uid) throws DatabaseException {
        ClusterImpl cluster = this.session.clusterTable.getClusterByClusterUIDOrMakeProxy(uid.asCID());
        int key = ClusterTraits.createResourceKey((int)cluster.getClusterKey(), (int)uid.getIndex());
        return new ResourceImpl((ResourceSupport)this.session.resourceSupport, key);
    }
}

