/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncProcedure;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncContextProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ResourceTableSmall;
import org.simantics.db.procore.cluster.ValueTableSmall;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.utils.datastructures.Callback;

public class DirectQuerySupportImpl
implements DirectQuerySupport {
    private final SessionImplSocket session;
    private final char[] chars = new char[1024];

    DirectQuerySupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public final void forEachDirectPersistentStatement(AsyncReadGraph graph, Resource subject, AsyncProcedure<DirectStatements> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        impl.processor.forEachDirectStatement(impl, subject, procedure, true);
    }

    public final void forEachDirectStatement(AsyncReadGraph graph, Resource subject, AsyncProcedure<DirectStatements> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        impl.processor.forEachDirectStatement(impl, subject, procedure, false);
    }

    public void forEachDirectStatement(AsyncReadGraph graph, Resource subject, SyncProcedure<DirectStatements> procedure) {
        this.forEachDirectStatement(graph, subject, (AsyncProcedure<DirectStatements>)new SyncToAsyncProcedure(procedure));
    }

    public void forEachDirectStatement(AsyncReadGraph graph, Resource subject, Procedure<DirectStatements> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        impl.processor.forEachDirectStatement(impl, subject, procedure);
    }

    public void forRelationInfo(AsyncReadGraph graph, Resource subject, AsyncProcedure<RelationInfo> procedure) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        impl.processor.forRelationInfo(impl, subject, procedure);
    }

    public void forRelationInfo(AsyncReadGraph graph, Resource subject, SyncProcedure<RelationInfo> procedure) {
        this.forRelationInfo(graph, subject, (AsyncProcedure<RelationInfo>)new SyncToAsyncProcedure(procedure));
    }

    public void forRelationInfo(AsyncReadGraph graph, Resource subject, Procedure<RelationInfo> procedure) {
        this.forRelationInfo(graph, subject, (AsyncProcedure<RelationInfo>)new NoneToAsyncProcedure(procedure));
    }

    public AsyncMultiProcedure<Resource> compileForEachObject(ReadGraph graph, final Resource relation, AsyncMultiProcedure<Resource> user) {
        try {
            RelationInfo info = (RelationInfo)graph.syncRequest((AsyncRead)new AsyncRead<RelationInfo>(){

                public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
                    DirectQuerySupportImpl.this.forRelationInfo(graph, relation, procedure);
                }

                public int threadHash() {
                    return this.hashCode();
                }

                public int getFlags() {
                    return 0;
                }
            });
            int predicateKey = ((ResourceImpl)relation).id;
            return new ForEachObjectProcedure(predicateKey, info, this.session.queryProvider2, user);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public <C> AsyncContextMultiProcedure<C, Resource> compileForEachObject(ReadGraph graph, final Resource relation, AsyncContextMultiProcedure<C, Resource> user) {
        try {
            RelationInfo info = (RelationInfo)graph.syncRequest((AsyncRead)new AsyncRead<RelationInfo>(){

                public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
                    DirectQuerySupportImpl.this.forRelationInfo(graph, relation, procedure);
                }

                public int threadHash() {
                    return this.hashCode();
                }

                public int getFlags() {
                    return 0;
                }
            });
            int predicateKey = ((ResourceImpl)relation).id;
            return new ForEachObjectContextProcedure(predicateKey, info, this.session.queryProvider2, user);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public <T> AsyncProcedure<T> compilePossibleRelatedValue(ReadGraph graph, final Resource relation, AsyncProcedure<T> user) {
        try {
            RelationInfo info = (RelationInfo)graph.syncRequest((AsyncRead)new AsyncRead<RelationInfo>(){

                public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
                    DirectQuerySupportImpl.this.forRelationInfo(graph, relation, procedure);
                }

                public int threadHash() {
                    return this.hashCode();
                }

                public int getFlags() {
                    return 0;
                }
            });
            int predicateKey = ((ResourceImpl)relation).id;
            return new ForPossibleRelatedValueProcedure(predicateKey, info, user);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public <C, T> AsyncContextProcedure<C, T> compilePossibleRelatedValue(ReadGraph graph, final Resource relation, AsyncContextProcedure<C, T> user) {
        try {
            RelationInfo info = (RelationInfo)graph.syncRequest((AsyncRead)new AsyncRead<RelationInfo>(){

                public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
                    DirectQuerySupportImpl.this.forRelationInfo(graph, relation, procedure);
                }

                public int threadHash() {
                    return this.hashCode();
                }

                public int getFlags() {
                    return 0;
                }
            });
            int predicateKey = ((ResourceImpl)relation).id;
            return new ForPossibleRelatedValueContextProcedure(predicateKey, info, user);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        ForEachObjectProcedure proc = (ForEachObjectProcedure)procedure;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        this.session.querySupport.getObjects4(impl, subjectId, proc);
    }

    public <C> void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, C context, AsyncContextMultiProcedure<C, Resource> procedure) {
        assert (subject != null);
        ForEachObjectContextProcedure proc = (ForEachObjectContextProcedure)procedure;
        RelationInfo info = proc.info;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        if (info.isFunctional) {
            this.session.querySupport.getObjects4(impl, subjectId, context, proc);
        } else {
            this.session.querySupport.getObjects4(impl, subjectId, context, proc);
        }
    }

    public <T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, AsyncProcedure<T> procedure) {
        assert (subject != null);
        ForPossibleRelatedValueProcedure proc = (ForPossibleRelatedValueProcedure)procedure;
        RelationInfo info = proc.info;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        if (info.isFunctional) {
            this.getRelatedValue4(impl, subjectId, proc);
        } else {
            this.getRelatedValue4(impl, subjectId, proc);
        }
    }

    public <C, T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, C context, AsyncContextProcedure<C, T> procedure) {
        assert (subject != null);
        ForPossibleRelatedValueContextProcedure proc = (ForPossibleRelatedValueContextProcedure)procedure;
        RelationInfo info = proc.info;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        if (info.isFunctional) {
            this.getRelatedValue4(impl, subjectId, context, proc);
        } else {
            this.getRelatedValue4(impl, subjectId, context, proc);
        }
    }

    public <T> void forPossibleType(AsyncReadGraph graph, Resource subject, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        try {
            Object cluster = this.session.clusterTable.getClusterByResourceKey(subjectId);
            if (!cluster.isLoaded()) {
                this.session.queryProvider2.requestCluster(impl, cluster.getClusterId(), new Runnable((ClusterI)cluster, subjectId, (AsyncProcedure)procedure, graph){
                    private final /* synthetic */ ClusterI val$cluster;
                    private final /* synthetic */ int val$subjectId;
                    private final /* synthetic */ AsyncProcedure val$procedure;
                    private final /* synthetic */ AsyncReadGraph val$graph;
                    {
                        this.val$cluster = clusterI;
                        this.val$subjectId = n;
                        this.val$procedure = asyncProcedure;
                        this.val$graph = asyncReadGraph;
                    }

                    @Override
                    public void run() {
                        try {
                            int result = this.val$cluster.getCompleteObjectKey(this.val$subjectId, (ClusterSupport)((DirectQuerySupportImpl)DirectQuerySupportImpl.this).session.clusterTranslator);
                            this.val$procedure.execute(this.val$graph, (Object)new ResourceImpl((ResourceSupport)((DirectQuerySupportImpl)DirectQuerySupportImpl.this).session.resourceSupport, result));
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                int result = cluster.getCompleteObjectKey(subjectId, (ClusterSupport)this.session.clusterTranslator);
                procedure.execute(graph, (Object)new ResourceImpl((ResourceSupport)this.session.resourceSupport, result));
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public <C> void forPossibleDirectType(AsyncReadGraph graph, Resource subject, C context, AsyncContextProcedure<C, Resource> procedure) {
        assert (subject != null);
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        try {
            Object cluster = this.session.clusterTable.getClusterByResourceKey(subjectId);
            if (!cluster.isLoaded()) {
                this.session.queryProvider2.requestCluster(impl, cluster.getClusterId(), new Runnable((ClusterI)cluster, subjectId, (AsyncContextProcedure)procedure, graph, context){
                    private final /* synthetic */ ClusterI val$cluster;
                    private final /* synthetic */ int val$subjectId;
                    private final /* synthetic */ AsyncContextProcedure val$procedure;
                    private final /* synthetic */ AsyncReadGraph val$graph;
                    private final /* synthetic */ Object val$context;
                    {
                        this.val$cluster = clusterI;
                        this.val$subjectId = n;
                        this.val$procedure = asyncContextProcedure;
                        this.val$graph = asyncReadGraph;
                        this.val$context = object;
                    }

                    @Override
                    public void run() {
                        try {
                            ClusterI.CompleteTypeEnum type = this.val$cluster.getCompleteType(this.val$subjectId, (ClusterSupport)((DirectQuerySupportImpl)DirectQuerySupportImpl.this).session.clusterTranslator);
                            if (ClusterI.CompleteTypeEnum.InstanceOf == type) {
                                int result = this.val$cluster.getCompleteObjectKey(this.val$subjectId, (ClusterSupport)((DirectQuerySupportImpl)DirectQuerySupportImpl.this).session.clusterTranslator);
                                this.val$procedure.execute(this.val$graph, this.val$context, (Object)new ResourceImpl((ResourceSupport)((DirectQuerySupportImpl)DirectQuerySupportImpl.this).session.resourceSupport, result));
                            } else {
                                this.val$procedure.execute(this.val$graph, this.val$context, null);
                            }
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subjectId, (ClusterSupport)this.session.clusterTranslator);
                if (ClusterI.CompleteTypeEnum.InstanceOf == type) {
                    int result = cluster.getCompleteObjectKey(subjectId, (ClusterSupport)this.session.clusterTranslator);
                    procedure.execute(graph, context, (Object)new ResourceImpl((ResourceSupport)this.session.resourceSupport, result));
                } else {
                    procedure.execute(graph, context, null);
                }
            }
        }
        catch (DatabaseException databaseException) {
            procedure.execute(graph, context, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            procedure.execute(graph, context, null);
        }
    }

    private <C, T> void getRelatedValue4(final ReadGraphImpl graph, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
        int result = 0;
        int predicate = procedure.predicateKey;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, context, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (result != 0) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
                        return;
                    }
                    result = id;
                    ++n2;
                }
            }
            if (result == 0) {
                procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("No objects for " + subject));
                return;
            }
            this.getValue4(graph, null, result, context, procedure);
            return;
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, context, procedure);
                }
            });
            return;
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, context, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    if (result != 0) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
                        return;
                    }
                    result = id;
                    ++n3;
                }
            }
            this.getRelatedDirectValue4(graph, cluster, subject, result, context, procedure);
        } else {
            this.getRelatedDirectValue4(graph, cluster, subject, 0, context, procedure);
        }
    }

    private <T> void getValue4(final ReadGraphImpl graph, final ClusterImpl containerCluster, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {
        byte[] result = null;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple values"));
                    return;
                }
                result = value;
            }
            procedure.execute((AsyncReadGraph)graph, (Object)"name");
            return;
        }
        ClusterImpl cluster = containerCluster;
        if (!containerCluster.contains(subject) && !(cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject))).isLoaded()) {
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, procedure);
                }
            });
            return;
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple values"));
                    return;
                }
                result = value;
            }
            if (result != null) {
                procedure.execute((AsyncReadGraph)graph, (Object)result);
            } else if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
                this.getDirectValue4(graph, (ClusterSmall)cluster, subject, procedure);
            } else {
                this.getDirectValue4(graph, (ClusterBig)cluster, subject, procedure);
            }
        } else if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
            this.getDirectValue4(graph, (ClusterSmall)cluster, subject, procedure);
        } else {
            this.getDirectValue4(graph, (ClusterBig)cluster, subject, procedure);
        }
    }

    private <C, T> void getValue4(final ReadGraphImpl graph, final ClusterImpl containerCluster, final int subject, final C context, final ForPossibleRelatedValueContextProcedure<C, T> procedure) {
        byte[] result = null;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, context, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple values"));
                    return;
                }
                result = value;
            }
            procedure.execute((AsyncReadGraph)graph, context, (Object)"name");
            return;
        }
        ClusterImpl cluster = containerCluster;
        if (!containerCluster.contains(subject) && !(cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject))).isLoaded()) {
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, context, procedure);
                }
            });
            return;
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getValue4(graph, containerCluster, subject, context, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple values"));
                    return;
                }
                result = value;
            }
            if (result != null) {
                procedure.execute((AsyncReadGraph)graph, context, (Object)result);
            } else if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
                this.getDirectValue4(graph, (ClusterSmall)cluster, subject, context, procedure);
            } else {
                this.getDirectValue4(graph, (ClusterBig)cluster, subject, context, procedure);
            }
        } else if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
            this.getDirectValue4(graph, (ClusterSmall)cluster, subject, context, procedure);
        } else {
            this.getDirectValue4(graph, (ClusterBig)cluster, subject, context, procedure);
        }
    }

    private <T> void getRelatedDirectValue4(ReadGraphImpl graph, ClusterImpl cluster, int subject, int result, ForPossibleRelatedValueProcedure<T> procedure) {
        try {
            int so = cluster.getSingleObject(subject, procedure, (ClusterSupport)this.session.clusterTranslator);
            if (so == 0) {
                if (result == 0) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("No objects " + subject + " " + procedure.predicateKey));
                } else {
                    this.getValue4(graph, cluster, result, procedure);
                }
            } else if (result == 0) {
                this.getValue4(graph, cluster, so, procedure);
            } else {
                procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private <C, T> void getRelatedDirectValue4(ReadGraphImpl graph, ClusterImpl cluster, int subject, int result, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) {
        try {
            int so = cluster.getSingleObject(subject, procedure, (ClusterSupport)this.session.clusterTranslator);
            if (so == 0) {
                if (result == 0) {
                    procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("No objects " + subject + " " + procedure.predicateKey));
                } else {
                    this.getValue4(graph, cluster, result, context, procedure);
                }
            } else if (result == 0) {
                this.getValue4(graph, cluster, so, context, procedure);
            } else {
                procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public <T> void getRelatedValue4(final ReadGraphImpl graph, final int subject, final ForPossibleRelatedValueProcedure<T> procedure) {
        int result = 0;
        int predicate = procedure.predicateKey;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (result != 0) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
                        return;
                    }
                    result = id;
                    ++n2;
                }
            }
            if (result == 0) {
                procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("No objects for " + subject));
                return;
            }
            this.getValue4(graph, null, result, procedure);
            return;
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, procedure);
                }
            });
            return;
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, new Callback<ReadGraphImpl>(){

                    public void run(ReadGraphImpl graph) {
                        DirectQuerySupportImpl.this.getRelatedValue4(graph, subject, procedure);
                    }
                });
                return;
            }
            for (TransientGraph g : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    if (result != 0) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new DatabaseException("Multiple objects"));
                        return;
                    }
                    result = id;
                    ++n3;
                }
            }
            this.getRelatedDirectValue4(graph, cluster, subject, result, procedure);
        } else {
            this.getRelatedDirectValue4(graph, cluster, subject, 0, procedure);
        }
    }

    private <C, T> void getDirectValue4(ReadGraphImpl graph, ClusterSmall cluster, int subject, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) {
        try {
            byte[] bytes = cluster.getValue(subject, (ClusterSupport)this.session.clusterTranslator);
            String value = this.utf(bytes);
            procedure.execute((AsyncReadGraph)graph, context, (Object)value);
        }
        catch (DatabaseException databaseException) {
            procedure.execute((AsyncReadGraph)graph, context, null);
        }
    }

    private <T> void getDirectValue4(ReadGraphImpl graph, ClusterBig cluster, int subject, ForPossibleRelatedValueProcedure<T> procedure) {
        try {
            byte[] bytes = cluster.getValue(subject, (ClusterSupport)this.session.clusterTranslator);
            String value = this.utf(bytes);
            procedure.execute((AsyncReadGraph)graph, (Object)value);
        }
        catch (DatabaseException databaseException) {
            procedure.execute((AsyncReadGraph)graph, null);
        }
    }

    private <C, T> void getDirectValue4(ReadGraphImpl graph, ClusterBig cluster, int subject, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) {
        try {
            byte[] bytes = cluster.getValue(subject, (ClusterSupport)this.session.clusterTranslator);
            if (bytes == null) {
                procedure.execute((AsyncReadGraph)graph, context, null);
            } else {
                String value = this.utf(bytes);
                procedure.execute((AsyncReadGraph)graph, context, (Object)value);
            }
        }
        catch (DatabaseException databaseException) {
            procedure.execute((AsyncReadGraph)graph, context, null);
        }
    }

    private <T> void getDirectValue4(ReadGraphImpl graph, ClusterSmall cluster, int subject, ForPossibleRelatedValueProcedure<T> procedure) {
        ResourceTableSmall rt = cluster.resourceTable;
        ValueTableSmall vt = cluster.valueTable;
        byte[] bs = (byte[])vt.table;
        long[] ls = (long[])rt.table;
        int index = ((subject & 0xFFFF) << 1) - 1 + rt.offset;
        int valueIndex = (int)(ls[index] >>> 24) & 0x3FFFFF + vt.offset;
        int size = bs[valueIndex++] - 1;
        ++valueIndex;
        int i = 0;
        while (i < size) {
            this.chars[i] = (char)bs[valueIndex++];
            ++i;
        }
        String value = new String(this.chars, 0, size);
        procedure.execute((AsyncReadGraph)graph, (Object)value);
    }

    private final String utf(byte[] bytes) {
        int length;
        if (bytes == null) {
            return null;
        }
        int index = 0;
        if ((length = bytes[index++] & 0xFF) >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += (bytes[index++] & 0xFF) << 3;
                        length += (bytes[index++] & 0xFF) << 11;
                        length += (bytes[index++] & 0xFF) << 19;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += (bytes[index++] & 0xFF) << 4;
                        length += (bytes[index++] & 0xFF) << 12;
                        length += (bytes[index++] & 0xFF) << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += (bytes[index++] & 0xFF) << 5;
                    length += (bytes[index++] & 0xFF) << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += (bytes[index++] & 0xFF) << 6;
                length += 128;
            }
        }
        int i = 0;
        int target = length + index;
        while (index < target) {
            int c2;
            int c;
            if ((c = bytes[index++] & 0xFF) <= 127) {
                this.chars[i++] = (char)(c & 0x7F);
                continue;
            }
            if (c > 2047) {
                c2 = bytes[index++] & 0xFF;
                int c3 = bytes[index++] & 0xFF;
                this.chars[i++] = (char)(((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F));
                continue;
            }
            c2 = bytes[index++] & 0xFF;
            this.chars[i++] = (char)(((c & 0x1F) << 6) + (c2 & 0x3F));
        }
        return new String(this.chars, 0, i);
    }
}

