/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.history;

import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.binary.OutputStreamWriteable;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.request.Read;
import org.simantics.fastlz.FastLZ;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.util.Stream;
import org.simantics.history.util.ValueBand;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.Activator;
import org.simantics.simulation.history.HistoryImportResult;
import org.simantics.simulation.ontology.HistoryResource;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.FileUtils;

public class HistoryUtil {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = true;
    private static final Compression USED_COMPRESSION = Compression.FLZ;
    private static final String APPLICATION_X_LZ4 = "application/x-lz4";
    private static final String APPLICATION_X_FLZ = "application/x-flz";
    private static final int ARCHIVE_VERSION_1 = 1;

    public static WriteRequest export(final HistoryManager history, final Resource historyResource, final boolean removeOldUnused, final Double timeShift, final double from, final double end) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                HistoryResource HIS = HistoryResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                long totalSampleSize = 0L;
                long s = System.nanoTime();
                try {
                    Bean[] items = history.getItems();
                    HistoryUtil.profile(null, "exporting " + items.length + " history items to database");
                    ItemManager im = new ItemManager(items);
                    HashMap<String, Resource> oldResourceMap = new HashMap<String, Resource>();
                    for (Resource oldItem : graph.getObjects(historyResource, L0.ConsistsOf)) {
                        Bean bean;
                        if (!graph.isInstanceOf(oldItem, HIS.History_Item) || (bean = (Bean)graph.getPossibleRelatedValue(oldItem, HIS.History_Item_Info, Bindings.BEAN)) == null) continue;
                        String id = (String)bean.getField("id");
                        if (!im.exists(id)) {
                            if (!removeOldUnused) continue;
                            graph.deny(oldItem);
                            continue;
                        }
                        oldResourceMap.put(id, oldItem);
                    }
                    for (Bean newItem : im.values()) {
                        String id = (String)newItem.getField("id");
                        Resource historyItemResource = (Resource)oldResourceMap.get(id);
                        Resource data = null;
                        if (historyItemResource == null) {
                            historyItemResource = graph.newResource();
                            graph.claim(historyResource, L0.ConsistsOf, historyItemResource);
                            graph.claim(historyItemResource, L0.InstanceOf, HIS.History_Item);
                            graph.claimLiteral(historyItemResource, L0.HasName, (Object)id);
                        } else {
                            data = graph.getPossibleObject(historyItemResource, HIS.History_Item_Series);
                        }
                        Variant v = new Variant((Binding)newItem.getBinding(), (Object)newItem);
                        graph.claimLiteral(historyItemResource, HIS.History_Item_Info, (Object)v, (Binding)Bindings.VARIANT);
                        if (data == null) {
                            data = graph.newResource();
                            graph.claim(data, L0.InstanceOf, L0.Variant);
                            graph.claim(historyItemResource, HIS.History_Item_Series, data);
                        } else {
                            graph.denyValue(data);
                        }
                        StreamAccessor sa = history.openStream(id, "r");
                        try {
                            try {
                                RecordBinding sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)sa.type().componentType);
                                Serializer serializer = Bindings.getSerializerUnchecked((Binding)sampleBinding);
                                Integer constantSampleSize = serializer.getConstantSize();
                                ValueBand vb = new ValueBand((Binding)sampleBinding);
                                Stream stream = new Stream((ArrayAccessor)sa, sampleBinding);
                                ObjectArrayBinding arrayBinding = new ObjectArrayBinding(sa.type(), (Binding)sampleBinding);
                                Object array = null;
                                int count = 0;
                                int startIndex = stream.binarySearch((Binding)Bindings.DOUBLE, (Object)from);
                                if (startIndex >= -stream.count()) {
                                    int endIndex;
                                    if (startIndex < 0) {
                                        startIndex = -2 - startIndex;
                                    }
                                    if (startIndex == -1) {
                                        startIndex = 0;
                                    }
                                    if ((endIndex = stream.binarySearch((Binding)Bindings.DOUBLE, (Object)end)) != -1) {
                                        if (endIndex < 0) {
                                            endIndex = -1 - endIndex;
                                        }
                                        if (endIndex == sa.size()) {
                                            endIndex = sa.size() - 1;
                                        }
                                        if (endIndex >= startIndex) {
                                            count = endIndex - startIndex + 1;
                                            array = arrayBinding.create(count);
                                            boolean hasTimeShift = timeShift != null && timeShift != 0.0;
                                            int i = 0;
                                            while (i < count) {
                                                Object sample = sa.get(i + startIndex, (Binding)sampleBinding);
                                                if (hasTimeShift) {
                                                    double newTime;
                                                    vb.setSample(sample);
                                                    if (vb.hasTime()) {
                                                        newTime = vb.getTimeDouble() + timeShift;
                                                        vb.setTime((Binding)Bindings.DOUBLE, (Object)newTime);
                                                    }
                                                    if (vb.hasEndTime()) {
                                                        newTime = vb.getEndTimeDouble() + timeShift;
                                                        vb.setEndTime((Binding)Bindings.DOUBLE, (Object)newTime);
                                                    }
                                                }
                                                arrayBinding.set(array, i, sample);
                                                ++i;
                                            }
                                        }
                                    }
                                }
                                if (array == null) {
                                    array = arrayBinding.create();
                                }
                                Variant v2 = new Variant((Binding)arrayBinding, array);
                                graph.claimValue(data, (Object)v2, (Binding)Bindings.VARIANT);
                                if (constantSampleSize != null) {
                                    long itemSampleSize = (long)count * (long)constantSampleSize.intValue();
                                    totalSampleSize += itemSampleSize;
                                    graph.claimLiteral(historyItemResource, HIS.History_Item_size, L0.Long, (Object)itemSampleSize, (Binding)Bindings.LONG);
                                }
                            }
                            catch (AccessorException e) {
                                throw new DatabaseException((Throwable)e);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                sa.close();
                            }
                            catch (AccessorException accessorException) {}
                            throw throwable;
                        }
                        try {
                            sa.close();
                        }
                        catch (AccessorException accessorException) {}
                    }
                    graph.claimLiteral(historyResource, HIS.History_size, L0.Long, (Object)totalSampleSize, (Binding)Bindings.LONG);
                    HistoryUtil.profile(s, "exported " + items.length + " history items to database");
                }
                catch (HistoryException e) {
                    throw new DatabaseException((Throwable)e);
                }
                catch (BindingException e) {
                    throw new DatabaseException((Throwable)e);
                }
                catch (ServiceNotFoundException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        };
    }

    public static WriteRequest exportArchive(final HistoryManager history, final Bean collectorState, final Resource historyResource, final Double timeShift, final double from, final double end) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                HistoryResource HIS = HistoryResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                long s = System.nanoTime();
                HistoryUtil.profile(null, "archiving history items to database");
                for (Resource entity : graph.getObjects(historyResource, L0.ConsistsOf)) {
                    if (!graph.isInstanceOf(entity, HIS.History_Item)) continue;
                    graph.deny(historyResource, L0.ConsistsOf, L0.PartOf, entity);
                }
                graph.denyValue(historyResource, HIS.History_archive);
                Resource archiveLiteral = graph.newResource();
                graph.claim(archiveLiteral, L0.InstanceOf, null, L0.ByteArray);
                graph.claim(historyResource, HIS.History_archive, archiveLiteral);
                Closeable closeable = null;
                try {
                    try {
                        RandomAccessBinary rab = graph.getRandomAccessBinary(archiveLiteral);
                        rab.position(0L);
                        rab.skipBytes(4);
                        ArchivedHistory archive = HistoryUtil.exportCompressedArchive(history, collectorState, historyResource, timeShift, from, end, rab);
                        rab.position(0L);
                        rab.writeInt((int)(rab.length() - 4L));
                        graph.claimLiteral(historyResource, HIS.History_size, L0.Long, (Object)archive.totalSampleSize, (Binding)Bindings.LONG);
                        HistoryUtil.profile(s, "archived history items of size " + archive.totalSampleSize + " to database");
                    }
                    catch (HistoryException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
                finally {
                    FileUtils.uncheckedClose(closeable);
                }
            }
        };
    }

    private static ArchivedHistory exportCompressedArchive(HistoryManager history, Bean collectorState, Resource historyResource, Double timeShift, double from, double end, RandomAccessBinary rab) throws IOException, HistoryException {
        switch (USED_COMPRESSION) {
            case FLZ: {
                return HistoryUtil.exportArchiveFLZ(history, collectorState, historyResource, timeShift, from, end, rab);
            }
            case LZ4: {
                return HistoryUtil.exportArchiveLZ4(history, collectorState, historyResource, timeShift, from, end, rab);
            }
        }
        throw new UnsupportedOperationException("Unsupported compression: " + (Object)((Object)USED_COMPRESSION));
    }

    private static ArchivedHistory exportArchiveLZ4(HistoryManager history, Bean collectorState, Resource historyResource, Double timeShift, double from, double end, RandomAccessBinary rab) throws IOException, HistoryException {
        ArchivedHistory archivedHistory;
        RABOutputStream closeable = null;
        try {
            DataContainers.writeHeader((DataOutput)rab, (DataContainer)new DataContainer(APPLICATION_X_LZ4, 1, null));
            closeable = new RABOutputStream(rab);
            closeable = new LZ4BlockOutputStream((OutputStream)closeable);
            ArchivedHistory archive = HistoryUtil.exportArchive(closeable, history, collectorState, timeShift, from, end);
            closeable.flush();
            closeable.close();
            closeable = null;
            archivedHistory = archive;
        }
        catch (Throwable throwable) {
            FileUtils.uncheckedClose(closeable);
            throw throwable;
        }
        FileUtils.uncheckedClose((Closeable)closeable);
        return archivedHistory;
    }

    private static ArchivedHistory exportArchiveFLZ(HistoryManager history, Bean collectorState, Resource historyResource, Double timeShift, double from, double end, RandomAccessBinary rab) throws IOException, HistoryException {
        ArchivedHistory archivedHistory;
        OutputStream closeable = null;
        try {
            DataContainers.writeHeader((DataOutput)rab, (DataContainer)new DataContainer(APPLICATION_X_FLZ, 1, null));
            closeable = new RABOutputStream(rab);
            closeable = FastLZ.write((OutputStream)closeable);
            ArchivedHistory archive = HistoryUtil.exportArchive(closeable, history, collectorState, timeShift, from, end);
            closeable.flush();
            closeable.close();
            closeable = null;
            archivedHistory = archive;
        }
        catch (Throwable throwable) {
            FileUtils.uncheckedClose(closeable);
            throw throwable;
        }
        FileUtils.uncheckedClose((Closeable)closeable);
        return archivedHistory;
    }

    private static ArchivedHistory exportArchive(OutputStream outputStream, HistoryManager history, Bean collectorState, Double timeShift, double from, double end) throws IOException, HistoryException {
        ArchivedHistory result = new ArchivedHistory();
        Serializer beanSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.BEAN);
        boolean hasTimeShift = timeShift != null && timeShift != 0.0;
        TarArchiveOutputStream out = new TarArchiveOutputStream(outputStream);
        OutputStreamWriteable dataOutput = new OutputStreamWriteable((OutputStream)out);
        try {
            if (collectorState != null) {
                byte[] serializedCollectorState = beanSerializer.serialize((Object)collectorState);
                HistoryUtil.putNextEntry(out, "state", serializedCollectorState.length);
                out.write(serializedCollectorState);
                out.closeArchiveEntry();
            }
            ItemManager im = new ItemManager(history.getItems());
            for (Bean item : im.values()) {
                Integer constantSampleSize;
                Serializer sampleSerializer;
                RecordBinding sampleBinding;
                StreamAccessor sa;
                String id;
                block29: {
                    id = (String)item.getField("id");
                    byte[] metadata = beanSerializer.serialize((Object)item);
                    HistoryUtil.putNextEntry(out, String.valueOf(id) + ".txt", metadata.length);
                    out.write(metadata);
                    out.closeArchiveEntry();
                    sa = history.openStream(id, "r");
                    sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)sa.type().componentType);
                    sampleSerializer = Bindings.getSerializerUnchecked((Binding)sampleBinding);
                    constantSampleSize = sampleSerializer.getConstantSize();
                    if (constantSampleSize != null) break block29;
                    System.err.println("Skipping item " + item + " in history archival due to variable length samples not being supported at the moment.");
                    try {
                        sa.close();
                    }
                    catch (AccessorException accessorException) {}
                    continue;
                }
                try {
                    try {
                        ValueBand vb = new ValueBand((Binding)sampleBinding);
                        Stream stream = new Stream((ArrayAccessor)sa, sampleBinding);
                        int startIndex = stream.binarySearch((Binding)Bindings.DOUBLE, (Object)from);
                        if (startIndex >= -stream.count()) {
                            int endIndex;
                            if (startIndex < 0) {
                                startIndex = -2 - startIndex;
                            }
                            if (startIndex == -1) {
                                startIndex = 0;
                            }
                            if ((endIndex = stream.binarySearch((Binding)Bindings.DOUBLE, (Object)end)) != -1) {
                                if (endIndex < 0) {
                                    endIndex = -1 - endIndex;
                                }
                                if (endIndex == sa.size()) {
                                    endIndex = sa.size() - 1;
                                }
                                if (endIndex >= startIndex) {
                                    int count = endIndex - startIndex + 1;
                                    long savedSamplesSize = (long)count * (long)constantSampleSize.intValue();
                                    HistoryUtil.putNextEntry(out, String.valueOf(id) + ".data", savedSamplesSize);
                                    int i = 0;
                                    while (i < count) {
                                        Object sample = sa.get(i + startIndex, (Binding)sampleBinding);
                                        if (hasTimeShift) {
                                            double newTime;
                                            vb.setSample(sample);
                                            if (vb.hasTime()) {
                                                newTime = vb.getTimeDouble() + timeShift;
                                                vb.setTime((Binding)Bindings.DOUBLE, (Object)newTime);
                                            }
                                            if (vb.hasEndTime()) {
                                                newTime = vb.getEndTimeDouble() + timeShift;
                                                vb.setEndTime((Binding)Bindings.DOUBLE, (Object)newTime);
                                            }
                                        }
                                        sampleSerializer.serialize((DataOutput)dataOutput, sample);
                                        ++i;
                                    }
                                    out.closeArchiveEntry();
                                    result.itemSizes.put((Object)item, savedSamplesSize);
                                    result.totalSampleSize += savedSamplesSize;
                                }
                            }
                        }
                    }
                    catch (AccessorException e) {
                        throw new IOException(e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        sa.close();
                    }
                    catch (AccessorException accessorException) {}
                    throw throwable;
                }
                try {
                    sa.close();
                }
                catch (AccessorException accessorException) {}
            }
            ArchivedHistory archivedHistory = result;
            return archivedHistory;
        }
        catch (BindingException e) {
            throw new HistoryException((Throwable)e);
        }
        finally {
            out.finish();
        }
    }

    public static Read<HistoryImportResult> importHistory(final Resource r, final HistoryManager history) {
        return new UniqueRead<HistoryImportResult>(){

            public HistoryImportResult perform(ReadGraph graph) throws DatabaseException {
                HistoryImportResult result = new HistoryImportResult();
                HistoryResource HIS = HistoryResource.getInstance((ReadGraph)graph);
                SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                Resource historyResource = r;
                if (!graph.isInstanceOf(historyResource, HIS.History)) {
                    historyResource = graph.getPossibleObject(r, SIM.State_History);
                }
                if (historyResource == null) {
                    return result;
                }
                if (!graph.isInstanceOf(historyResource, HIS.History)) {
                    return result;
                }
                long s = System.nanoTime();
                Resource archive = graph.getPossibleObject(historyResource, HIS.History_archive);
                if (archive == null) {
                    HistoryUtil.profile(null, "importing history items from old database format to disk workarea");
                    HistoryUtil.importHistoryItems(graph, historyResource, history);
                } else {
                    try {
                        HistoryUtil.profile(null, "importing history items from archived format to disk workarea");
                        HistoryUtil.importHistoryArchive(graph, historyResource, archive, history, result);
                    }
                    catch (IOException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                    catch (HistoryException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
                HistoryUtil.profile(s, "imported history items from database to disk workarea");
                return result;
            }
        };
    }

    private static boolean importHistoryItems(ReadGraph graph, Resource historyResource, HistoryManager history) throws DatabaseException {
        HistoryResource HIS = HistoryResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        try {
            for (Resource oldItem : graph.getObjects(historyResource, L0.ConsistsOf)) {
                if (!graph.isInstanceOf(oldItem, HIS.History_Item)) continue;
                Bean bean = (Bean)graph.getRelatedValue(oldItem, HIS.History_Item_Info, Bindings.BEAN);
                String id = (String)bean.getFieldUnchecked("id");
                Object array = graph.getRelatedValue(oldItem, HIS.History_Item_Series, Bindings.BEAN);
                Binding arrayBinding = Bindings.getBinding(array.getClass());
                history.modify(new Bean[]{bean});
                StreamAccessor sa = history.openStream(id, "rw");
                try {
                    sa.setValue(arrayBinding, array);
                }
                catch (Throwable throwable) {
                    try {
                        sa.close();
                    }
                    catch (AccessorException accessorException) {}
                    throw throwable;
                }
                try {
                    sa.close();
                }
                catch (AccessorException accessorException) {}
            }
            return true;
        }
        catch (AccessorException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (HistoryException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private static boolean importHistoryArchive(ReadGraph graph, Resource historyResource, Resource archive, HistoryManager history, HistoryImportResult result) throws DatabaseException, IOException, HistoryException {
        RandomAccessBinary rab = graph.getRandomAccessBinary(archive);
        rab.position(4L);
        DataContainer dc = DataContainers.readHeader((DataInput)rab);
        if (APPLICATION_X_LZ4.equals(dc.format)) {
            if (dc.version == 1) {
                RABInputStream in = new RABInputStream(rab);
                in = new LZ4BlockInputStream((InputStream)in);
                return HistoryUtil.extractHistoryArchiveTar(graph, history, in, result);
            }
        } else if (APPLICATION_X_FLZ.equals(dc.format) && dc.version == 1) {
            boolean bl;
            InputStream in = null;
            try {
                in = new RABInputStream(rab);
                in = FastLZ.read((InputStream)in);
                bl = HistoryUtil.extractHistoryArchiveTar(graph, history, in, result);
            }
            catch (Throwable throwable) {
                FileUtils.uncheckedClose(in);
                throw throwable;
            }
            FileUtils.uncheckedClose((Closeable)in);
            return bl;
        }
        throw new UnsupportedOperationException("Unsupported format " + dc.format + " and version " + dc.version);
    }

    private static boolean extractHistoryArchiveTar(ReadGraph graph, HistoryManager history, InputStream in, HistoryImportResult result) throws DatabaseException, IOException, HistoryException {
        TarArchiveEntry entry;
        TarArchiveInputStream tar = new TarArchiveInputStream(in);
        Serializer beanSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.BEAN);
        Bean lastItem = null;
        String lastItemId = null;
        while ((entry = tar.getNextTarEntry()) != null) {
            String name = entry.getName();
            boolean state = name.equals("state");
            boolean metadata = name.endsWith(".txt");
            boolean data = name.endsWith(".data");
            if (state) {
                if (result != null) {
                    byte[] st = new byte[(int)entry.getSize()];
                    tar.read(st);
                    result.collectorState = (Bean)beanSerializer.deserialize(st);
                    continue;
                }
                tar.skip(entry.getSize());
                continue;
            }
            if (metadata) {
                byte[] md = new byte[(int)entry.getSize()];
                tar.read(md);
                try {
                    Bean bean = (Bean)beanSerializer.deserialize(md);
                    history.modify(new Bean[]{bean});
                    lastItem = bean;
                    lastItemId = (String)bean.getFieldUnchecked("id");
                }
                catch (ClassFormatError e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.simulation", "History item " + name + " metadata deserialization failed.", (Throwable)e));
                }
                continue;
            }
            if (!data || lastItem == null) continue;
            StreamAccessor sa = history.openStream(lastItemId, "rw");
            try {
                if (sa instanceof BinaryObject) {
                    BinaryObject bo = (BinaryObject)sa;
                    RandomAccessBinary output = bo.getBinary();
                    output.position(0L);
                    output.setLength(0L);
                    long copiedBytes = FileUtils.copy((InputStream)tar, (OutputStream)new RABOutputStream(output), (long)entry.getSize());
                    if (copiedBytes != entry.getSize()) {
                        System.err.println("WARNING: item " + lastItemId + ", extracted " + copiedBytes + " bytes while TAR entry said the size to be " + entry.getSize() + " bytes");
                    }
                } else {
                    System.err.println("Skipping item " + lastItemId + " in history import due to StreamAccessor not being an instanceof BinaryObject. StreamAccessor=" + sa);
                }
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    lastItem = null;
                    lastItemId = null;
                }
                catch (AccessorException accessorException) {}
                throw throwable;
            }
            try {
                sa.close();
                lastItem = null;
                lastItemId = null;
            }
            catch (AccessorException accessorException) {}
        }
        return true;
    }

    public static WriteRequest clear(final Resource history) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                HistoryResource HIS = HistoryResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource oldItem : graph.getObjects(history, L0.ConsistsOf)) {
                    Resource data;
                    if (!graph.isInstanceOf(oldItem, HIS.History_Item)) continue;
                    Resource info = graph.getPossibleObject(oldItem, HIS.History_Item);
                    if (info != null) {
                        graph.deny(oldItem, HIS.History_Item_Info);
                        graph.deny(info);
                    }
                    if ((data = graph.getPossibleObject(oldItem, HIS.History_Item_Series)) != null) {
                        graph.deny(oldItem, HIS.History_Item_Series);
                        graph.deny(data);
                    }
                    graph.deny(history, L0.ConsistsOf, oldItem);
                    graph.deny(oldItem);
                }
                graph.denyValue(history, HIS.History_archive);
            }
        };
    }

    private static void putNextEntry(TarArchiveOutputStream out, String entryName, long size) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(entryName);
        entry.setSize(size);
        out.putArchiveEntry((ArchiveEntry)entry);
    }

    private static long profile(Long t1, String string) {
        long t2 = System.nanoTime();
        long delta = t1 == null ? 0L : t2 - t1;
        System.out.println("[" + HistoryUtil.class.getSimpleName() + "] PROFILE: " + string + (t1 == null ? "" : " in " + (double)delta * 1.0E-6 + " ms"));
        return t2;
    }

    private static class ArchivedHistory {
        public long totalSampleSize = 0L;
        public TObjectLongMap<Bean> itemSizes = new TObjectLongHashMap();

        private ArchivedHistory() {
        }
    }

    private static enum Compression {
        FLZ,
        LZ4;

    }

    private static class RABInputStream
    extends InputStream {
        private final RandomAccessBinary input;

        public RABInputStream(RandomAccessBinary input) {
            this.input = input;
        }

        @Override
        public int available() throws IOException {
            long avail = this.input.length() - this.input.position();
            if ((avail & 0xFFFFFFFF00000000L) != 0L) {
                throw new IOException("Number of available bytes truncated in long->int conversion: " + avail);
            }
            return (int)avail;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.input.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long available = this.input.length() - this.input.position();
            if (available == 0L) {
                return -1;
            }
            int l = (int)Math.min(available, (long)len);
            this.input.readFully(b, off, l);
            return l;
        }

        @Override
        public long skip(long n) throws IOException {
            long count = 0L;
            while (count < n) {
                int l = (int)Math.min(n, Integer.MAX_VALUE);
                count += (long)this.input.skipBytes(l);
            }
            return count;
        }
    }

    private static class RABOutputStream
    extends OutputStream {
        private final RandomAccessBinary output;

        public RABOutputStream(RandomAccessBinary output) {
            this.output = output;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.output.write(b);
        }
    }
}

