/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.profile.view.ProfileTuple;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileEntrySelectionListener
implements Listener {
    public void processRecursively(WriteGraph graph, Resource runtimeProfile, Resource entry, boolean checked) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(entry, DIA.Profile)) {
            for (Resource child : ProfileUtils.getProfileChildren((ReadGraph)graph, (Resource)entry)) {
                this.processRecursively(graph, runtimeProfile, child, checked);
            }
        } else if (graph.isInstanceOf(entry, DIA.ProfileEntry)) {
            if (checked) {
                graph.claim(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, null, entry);
            } else {
                graph.denyStatement(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, entry);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.detail == 32) {
            TreeItem item = (TreeItem)event.item;
            Tree tree = item.getParent();
            GraphExplorer explorer = (GraphExplorer)tree.getData("GraphExplorer");
            final Resource runtimeDiagram = (Resource)explorer.getRoot().getConstant(BuiltinKeys.INPUT);
            final boolean checked = item.getChecked();
            NodeContext context = (NodeContext)item.getData();
            final ProfileTuple entry = (ProfileTuple)((Object)context.getConstant(BuiltinKeys.INPUT));
            try {
                VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
                Simantics.getSession().syncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        Resource runtimeProfile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                        ProfileEntrySelectionListener.this.processRecursively(graph, runtimeProfile, entry.getEntry(), checked);
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }
}

