/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base2;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.structural.synchronization.protocol.ChildInfo;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.simantics.structural.synchronization.protocol.SynchronizationException;

public abstract class AbstractSynchronizationEventHandler<Component, ConnectionResolvedCallback>
implements SynchronizationEventHandler {
    private Component currentComponent;
    private THashSet<Component> mayBeUpdated = new THashSet();
    private THashMap<Component, ArrayList<PendingResolve<Component, ConnectionResolvedCallback>>> pendingResolves = new THashMap();
    private THashSet<Component> pendingRemoval = new THashSet();

    protected abstract Component getConfigurationRoot();

    protected abstract Component getParent(Component var1);

    protected abstract Map<String, Component> getChildMap(Component var1);

    protected abstract void setChildMap(Component var1, THashMap<String, Component> var2);

    protected abstract void detachFromParent(Component var1);

    protected abstract Component getComponentByUid(String var1);

    protected abstract Component createComponent(String var1);

    protected abstract void removeComponent(Component var1);

    protected abstract void resolveConnectionPointLocally(Component var1, String var2, ConnectionResolvedCallback var3);

    protected abstract void updateComponent(Component var1, String var2, String var3, Collection<SerializedVariable> var4, Collection<Connection> var5);

    @Override
    public void beginSynchronization() {
        this.currentComponent = null;
    }

    @Override
    public void endSynchronization() {
        if (this.currentComponent != null) {
            throw new SynchronizationException("beginComponent is called more often than endComponent at the end of synchronization.");
        }
        for (Object component : this.pendingRemoval) {
            this.removeComponent(component);
        }
        this.pendingRemoval.clear();
    }

    @Override
    public void beginComponent(String name, String typeId, Collection<SerializedVariable> properties, Collection<Connection> connections, Collection<ChildInfo> children) throws SynchronizationException {
        if (this.currentComponent == null) {
            this.currentComponent = this.getConfigurationRoot();
            if (this.currentComponent == null) {
                throw new SynchronizationException("getConfiguration root returned null.");
            }
        } else {
            this.currentComponent = this.getChildMap(this.currentComponent).get(name);
            if (this.currentComponent == null) {
                throw new SynchronizationException("Didn't find '" + name + "'. " + "It should have been mentioned as a child in the parent beginComponent method.");
            }
        }
        if (!this.getChildMap(this.currentComponent).isEmpty() || !children.isEmpty()) {
            THashMap newChildMap = new THashMap();
            for (ChildInfo info : children) {
                Component component = this.getComponentByUid(info.uid);
                if (component == null) {
                    component = this.createComponent(info.uid);
                } else {
                    this.pendingRemoval.remove(component);
                    this.detachFromParent(component);
                }
                newChildMap.put((Object)info.name, component);
                this.componentMayBeUpdated(component);
            }
            Map<String, Component> oldChildMap = this.getChildMap(this.currentComponent);
            for (Component component : oldChildMap.values()) {
                this.detachFromParent(component);
                this.pendingRemoval.add(component);
            }
            this.setChildMap(this.currentComponent, newChildMap);
        }
        this.mayBeUpdated.remove(this.currentComponent);
        this.updateComponent(this.currentComponent, name, typeId, properties, connections);
    }

    @Override
    public void endComponent() {
        if (this.currentComponent == null) {
            throw new SynchronizationException("endComponent is called more often than beginComponent.");
        }
        for (Component child : this.getChildMap(this.currentComponent).values()) {
            if (!this.mayBeUpdated.remove(child)) continue;
            this.componentUpdated(child);
        }
        this.currentComponent = this.getParent(this.currentComponent);
    }

    private void componentMayBeUpdated(Component component) {
        this.mayBeUpdated.add(component);
        this.pendingResolves.put(component, new ArrayList(2));
    }

    public void componentUpdated(Component component) {
        ArrayList resolves = (ArrayList)this.pendingResolves.remove(component);
        if (resolves != null) {
            for (PendingResolve resolve : resolves) {
                this.resolveConnectionPoint(resolve.component, resolve.connectionPoint, resolve.connectionResolvedCallback);
            }
        }
    }

    public void resolveConnectionPoint(Component component, String connectionPoint, ConnectionResolvedCallback connectionResolvedCallback) {
        int pos = 0;
        block5: while (true) {
            char c = connectionPoint.charAt(pos++);
            switch (c) {
                case '.': {
                    component = this.getParent(component);
                    continue block5;
                }
                case '/': {
                    int endPos = pos;
                    while ((c = connectionPoint.charAt(endPos)) != '/' && c != '#') {
                        ++endPos;
                    }
                    String segment = URIStringUtils.unescape((String)connectionPoint.substring(pos, endPos));
                    pos = endPos;
                    if ((component = this.getChildMap(component).get(segment)) == null) {
                        String message = "Couldn't resolve " + connectionPoint + ", because child " + segment + " does not exist.";
                        this.reportProblem(message);
                        return;
                    }
                    ArrayList pendingList = (ArrayList)this.pendingResolves.get(component);
                    if (pendingList == null) continue block5;
                    pendingList.add(new PendingResolve<Component, ConnectionResolvedCallback>(component, connectionPoint.substring(pos), connectionResolvedCallback));
                    return;
                }
                case '#': {
                    String segment = connectionPoint.substring(pos);
                    this.resolveConnectionPointLocally(component, segment, connectionResolvedCallback);
                    return;
                }
            }
        }
    }

    private static class PendingResolve<Component, ConnectionResolvedCallback> {
        public final Component component;
        public final String connectionPoint;
        public final ConnectionResolvedCallback connectionResolvedCallback;

        public PendingResolve(Component component, String connectionPoint, ConnectionResolvedCallback connectionResolvedCallback) {
            this.component = component;
            this.connectionPoint = connectionPoint;
            this.connectionResolvedCallback = connectionResolvedCallback;
        }

        public String toString() {
            return String.valueOf(this.connectionPoint) + "->" + this.connectionResolvedCallback;
        }
    }
}

