/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.management;

import org.eclipse.core.runtime.ListenerList;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;

public class SessionContextProvider
implements ISessionContextProvider {
    private ListenerList listeners = new ListenerList();
    private Object handle;
    private ISessionContext context;

    public SessionContextProvider(Object handle) {
        this.handle = handle;
    }

    public Object getHandle() {
        return this.handle;
    }

    public void setHandle(Object handle) {
        this.handle = handle;
    }

    @Override
    public void addContextChangedListener(ISessionContextChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public ISessionContext getSessionContext() {
        return this.context;
    }

    @Override
    public void removeContextChangedListener(ISessionContextChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    public ISessionContext setSessionContext(ISessionContext context) {
        ISessionContext oldContext = this.context;
        this.context = context;
        if (!this.safeEquals(oldContext, context)) {
            this.fireChanged(oldContext, context);
        }
        return oldContext;
    }

    protected void fireChanged(ISessionContext oldValue, ISessionContext newValue) {
        SessionContextChangedEvent event = new SessionContextChangedEvent(this, this.handle, oldValue, newValue);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((ISessionContextChangedListener)o).sessionContextChanged(event);
            ++n2;
        }
    }

    public String toString() {
        return "SessionContextProvider [handle=" + this.handle + ", context=" + this.context + "]";
    }
}

