/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.sorters;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class AbstractSorter<T>
implements Sorter {
    Comparator<OrderNodeContext<T>> comparator = new Comparator<OrderNodeContext<T>>(){

        @Override
        public int compare(OrderNodeContext<T> o1, OrderNodeContext<T> o2) {
            return AbstractSorter.this.compare(o1.criterion, o2.criterion);
        }
    };

    public abstract T getSortingCriterion(ReadGraph var1, BrowseContext var2, NodeContext var3) throws DatabaseException;

    public abstract int compare(T var1, T var2);

    @Override
    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        OrderNodeContext[] orderNodes = new OrderNodeContext[nodes.size()];
        int i = 0;
        while (i < orderNodes.length) {
            NodeContext node = nodes.get(i);
            orderNodes[i] = new OrderNodeContext<T>(node, this.getSortingCriterion(graph, context, node));
            ++i;
        }
        Arrays.sort(orderNodes, this.comparator);
        i = 0;
        while (i < orderNodes.length) {
            nodes.set(i, orderNodes[i].node);
            ++i;
        }
    }

    static class OrderNodeContext<T> {
        public final NodeContext node;
        public final T criterion;

        public OrderNodeContext(NodeContext node, T criterion) {
            this.node = node;
            this.criterion = criterion;
        }
    }
}

