/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.utils.GeometryUtils;

public class SelectionNode
extends G2DNode
implements Decoration {
    private static final long serialVersionUID = -2879575230419873230L;
    public static final transient BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    protected Rectangle2D bounds = null;
    protected Color color = null;
    protected transient Rectangle2D rect;
    protected transient BasicStroke scaledStroke;
    protected transient double previousScaleRecip = Double.NaN;
    private boolean ignore = false;

    public void setIgnore(boolean value) {
        this.ignore = value;
    }

    @INode.SyncField(value={"transform", "bounds", "color"})
    public void init(AffineTransform transform, Rectangle2D bounds, Color color) {
        this.transform = transform;
        this.bounds = bounds;
        this.color = color;
    }

    @Override
    public void render(Graphics2D g) {
        double padding;
        if (this.bounds == null) {
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.transform.getDeterminant() == 0.0) {
            return;
        }
        AffineTransform ot = g.getTransform();
        g.setColor(this.color);
        g.transform(this.transform);
        AffineTransform tx = g.getTransform();
        double scale = GeometryUtils.getScale(tx);
        double scaleRecip = 1.0 / scale;
        if (this.scaledStroke == null || scaleRecip != this.previousScaleRecip) {
            this.scaledStroke = GeometryUtils.scaleStroke(SELECTION_STROKE, (float)scaleRecip);
            this.previousScaleRecip = scaleRecip;
        }
        g.setStroke(this.scaledStroke);
        double paddingX = padding = 5.0 * scaleRecip;
        double paddingY = padding;
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        this.rect.setFrame(this.bounds.getMinX() - paddingX, this.bounds.getMinY() - paddingY, this.bounds.getWidth() + 2.0 * paddingX, this.bounds.getHeight() + 2.0 * paddingY);
        g.draw(this.rect);
        g.setTransform(ot);
    }

    public Rectangle2D getRect() {
        return this.transform.createTransformedShape(this.rect).getBounds2D();
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }
}

