/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.adapter.AWTMouseEventAdapter;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeEventHandler
implements IEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeEventHandler.class);
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_HANDLER_SORT = false;
    private static final IEventHandler[] NONE = new IEventHandler[0];
    TreePreOrderComparator COMPARATOR = new TreePreOrderComparator(TreePreOrderComparator.Order.DESCENDING);
    protected List<IEventHandler> focusListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedFocusListeners = null;
    protected List<IEventHandler> timeListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedTimeListeners = null;
    protected List<IEventHandler> commandListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedCommandListeners = null;
    protected List<IEventHandler> keyListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedKeyListeners = null;
    protected List<IEventHandler> mouseListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedMouseListeners = null;
    protected List<IEventHandler> mouseDragBeginListeners = new ArrayList<IEventHandler>();
    protected IEventHandler[] sortedMouseDragBeginListeners = null;
    protected G2DSceneGraph sg;

    public NodeEventHandler(G2DSceneGraph sg) {
        this.sg = sg;
    }

    private IEventHandler[] sort(IEventHandler[] sort) {
        return this.sortInplace(Arrays.copyOf(sort, sort.length));
    }

    private IEventHandler[] sortInplace(IEventHandler[] sort) {
        Arrays.sort(sort, this.COMPARATOR);
        return sort;
    }

    public void setRootPane(Component rootPane) {
        if (GraphicsEnvironment.isHeadless()) {
            LOGGER.info("Disabling DragSource in headless environments");
            return;
        }
        final DragSource ds = new DragSource();
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                InputEvent ie = dge.getTriggerEvent();
                if (ie instanceof java.awt.event.MouseEvent) {
                    java.awt.event.MouseEvent e = (java.awt.event.MouseEvent)ie;
                    Point2D controlPos = AWTMouseEventAdapter.getControlPosition(e);
                    MouseEvent.MouseDragBegin event = new MouseEvent.MouseDragBegin(NodeEventHandler.this, e.getWhen(), 0, AWTMouseEventAdapter.getButtonStatus(e), AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getMouseButton(e), new Point2D.Double(), controlPos, controlPos, AWTMouseEventAdapter.getScreenPosition(e));
                    NodeEventHandler.this.handleMouseDragBeginEvent(event, 10);
                    if (event.transferable != null) {
                        ds.startDrag(dge, null, event.transferable, dsl);
                    }
                }
            }
        };
        ds.createDefaultDragGestureRecognizer(rootPane, 0x40000003, dgl);
        ds.addDragSourceListener(dsl);
    }

    public boolean mousePressed(MouseEvent.MouseButtonPressedEvent event) {
        G2DFocusManager.INSTANCE.clearFocus();
        if (this.sg.getRootPane() != null && G2DFocusManager.INSTANCE.getFocusOwner() == null) {
            this.sg.getRootPane().requestFocusInWindow();
        }
        return false;
    }

    private boolean handleEvent(Event e, IG2DNode focusNode, IEventHandler[] handlers) {
        IG2DNode h;
        int typeMask = EventTypes.toTypeMask(e);
        if (focusNode instanceof IEventHandler && NodeEventHandler.eats((h = focusNode).getEventMask(), typeMask) && h.handleEvent(e)) {
            return true;
        }
        IEventHandler[] iEventHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IEventHandler l = iEventHandlerArray[n2];
            if (NodeEventHandler.eats(l.getEventMask(), typeMask) && l.handleEvent(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean handleMouseEvent(MouseEvent e, int eventType) {
        IEventHandler[] sorted = this.sortedMouseListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.mouseListeners.toArray(NONE));
            this.sortedMouseListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    private boolean handleMouseDragBeginEvent(MouseEvent e, int eventType) {
        IEventHandler[] sorted = this.sortedMouseDragBeginListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.mouseDragBeginListeners.toArray(NONE));
            this.sortedMouseDragBeginListeners = sorted;
        }
        return this.handleEvent(e, null, sorted);
    }

    private boolean handleFocusEvent(FocusEvent e) {
        IEventHandler[] sorted = this.sortedFocusListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.focusListeners.toArray(NONE));
            this.sortedFocusListeners = sorted;
        }
        return this.handleEvent(e, null, sorted);
    }

    private boolean handleTimeEvent(TimeEvent e) {
        IEventHandler[] sorted = this.sortedTimeListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.timeListeners.toArray(NONE));
            this.sortedTimeListeners = sorted;
        }
        return this.handleEvent(e, null, sorted);
    }

    private boolean handleCommandEvent(CommandEvent e) {
        IEventHandler[] sorted = this.sortedCommandListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.commandListeners.toArray(NONE));
            this.sortedCommandListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    private boolean handleKeyEvent(KeyEvent e) {
        IEventHandler[] sorted = this.sortedKeyListeners;
        if (sorted == null) {
            sorted = this.sortInplace(this.keyListeners.toArray(NONE));
            this.sortedKeyListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    @Override
    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    @Override
    public boolean handleEvent(Event e) {
        int eventType = EventTypes.toType(e);
        switch (eventType) {
            case 1: {
                return this.handleCommandEvent((CommandEvent)e);
            }
            case 2: 
            case 3: {
                return this.handleFocusEvent((FocusEvent)e);
            }
            case 4: 
            case 5: {
                return this.handleKeyEvent((KeyEvent)e);
            }
            case 10: {
                return this.handleMouseDragBeginEvent((MouseEvent)e, eventType);
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.handleMouseEvent((MouseEvent)e, eventType);
            }
            case 15: {
                return this.handleTimeEvent((TimeEvent)e);
            }
        }
        return false;
    }

    public void add(IEventHandler item) {
        if (!(item instanceof IG2DNode)) {
            throw new IllegalArgumentException("event handler must be an IG2DNode");
        }
        int mask = item.getEventMask();
        if (NodeEventHandler.eats(mask, EventTypes.CommandMask)) {
            this.commandListeners.add(item);
            this.sortedCommandListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.FocusMask)) {
            this.focusListeners.add(item);
            this.sortedFocusListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.KeyMask)) {
            this.keyListeners.add(item);
            this.sortedKeyListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseDragBeginMask)) {
            this.mouseDragBeginListeners.add(item);
            this.sortedMouseDragBeginListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseMask & ~EventTypes.MouseDragBeginMask)) {
            this.mouseListeners.add(item);
            this.sortedMouseListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.TimeMask)) {
            this.timeListeners.add(item);
            this.sortedTimeListeners = null;
        }
    }

    public boolean remove(IEventHandler item) {
        if (!(item instanceof IG2DNode)) {
            throw new IllegalArgumentException("event handler must be an IG2DNode");
        }
        int mask = item.getEventMask();
        boolean removed = false;
        if (NodeEventHandler.eats(mask, EventTypes.CommandMask)) {
            removed |= this.commandListeners.remove(item);
            this.sortedCommandListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.FocusMask)) {
            removed |= this.focusListeners.remove(item);
            this.sortedFocusListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.KeyMask)) {
            removed |= this.keyListeners.remove(item);
            this.sortedKeyListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseDragBeginMask)) {
            removed |= this.mouseDragBeginListeners.remove(item);
            this.sortedMouseDragBeginListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseMask & ~EventTypes.MouseDragBeginMask)) {
            removed |= this.mouseListeners.remove(item);
            this.sortedMouseListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.TimeMask)) {
            removed |= this.timeListeners.remove(item);
            this.sortedTimeListeners = null;
        }
        return removed;
    }

    private static boolean eats(int handlerMask, int eventTypeMask) {
        return (handlerMask & eventTypeMask) != 0;
    }

    private void debug(String msg) {
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": " + msg);
    }

    public void dispose() {
        this.commandListeners.clear();
        this.commandListeners = null;
        this.focusListeners.clear();
        this.focusListeners = null;
        this.keyListeners.clear();
        this.keyListeners = null;
        this.mouseListeners.clear();
        this.mouseListeners = null;
        this.sg = null;
        this.sortedCommandListeners = null;
        this.sortedKeyListeners = null;
        this.sortedMouseListeners = null;
        this.timeListeners.clear();
        this.timeListeners = null;
    }

    public static class TreePreOrderComparator
    implements Comparator<IEventHandler> {
        private transient ThreadLocal<Temp> temp = new ThreadLocal<Temp>(){

            @Override
            protected Temp initialValue() {
                return new Temp();
            }
        };
        Order order;

        public TreePreOrderComparator(Order order) {
            this.order = order;
        }

        void getTreePath(INode node, ArrayList<INode> result) {
            result.clear();
            while (node != null) {
                result.add(node);
                node = node.getParent();
            }
        }

        void notSameGraph(INode o1, INode o2) {
            throw new IllegalStateException("nodes " + o1 + " and " + o2 + " not part of same scene graph.\n\t root 1: " + o1.getRootNode() + "\n\troot 2: " + o2.getRootNode());
        }

        @Override
        public int compare(IEventHandler e1, IEventHandler e2) {
            if (e1 == e2) {
                return 0;
            }
            Temp tmp = this.temp.get();
            ArrayList<INode> path1 = tmp.path1;
            ArrayList<INode> path2 = tmp.path2;
            try {
                this.getTreePath((INode)((Object)e1), path1);
                this.getTreePath((INode)((Object)e2), path2);
                if (path1.get(path1.size() - 1) != path2.get(path2.size() - 1)) {
                    this.notSameGraph((INode)((Object)e1), (INode)((Object)e2));
                }
                int i1 = path1.size() - 1;
                int i2 = path2.size() - 1;
                while (i1 >= 0 && i2 >= 0) {
                    INode p2;
                    INode p1 = path1.get(i1);
                    if (p1 != (p2 = path2.get(i2))) break;
                    --i1;
                    --i2;
                }
                if (i1 < 0) {
                    int n = Order.ASCENDING == this.order ? -1 : 1;
                    return n;
                }
                if (i2 < 0) {
                    int n = Order.ASCENDING == this.order ? 1 : -1;
                    return n;
                }
                int n = this.compare(path1.get(i1), path2.get(i2));
                return n;
            }
            finally {
                path1.clear();
                path2.clear();
            }
        }

        @Override
        private int compare(INode n1, INode n2) {
            if (n1 instanceof IG2DNode) {
                if (n2 instanceof IG2DNode) {
                    int z1 = ((IG2DNode)n1).getZIndex();
                    int z2 = ((IG2DNode)n2).getZIndex();
                    int c = Integer.compare(z1, z2);
                    return this.order == Order.ASCENDING ? c : -c;
                }
                return -1;
            }
            if (n2 instanceof IG2DNode) {
                return 1;
            }
            return 0;
        }

        static enum Order {
            ASCENDING,
            DESCENDING;

        }

        static class Temp {
            ArrayList<INode> path1 = new ArrayList();
            ArrayList<INode> path2 = new ArrayList();

            Temp() {
            }
        }
    }
}

