/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.ui;

import java.awt.geom.Point2D;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.diagram.ui.WorkbenchSelectionProvider;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.ShowPopup;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class SWTPopupMenuParticipant
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    WorkbenchSelectionProvider wbsp;
    @DependencyReflection.Dependency
    TransformUtil trUtil;
    IWorkbenchPartSite site;
    Control control;
    Display display;
    MenuManager menuManager;
    String menuId;
    IHintListener popupListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == DiagramHints.SHOW_POPUP_MENU && newValue != null) {
                Control c = SWTPopupMenuParticipant.this.control;
                if (SWTPopupMenuParticipant.this.display.isDisposed() || c == null || c.isDisposed()) {
                    return;
                }
                SWTPopupMenuParticipant.this.showPopup((Point2D)newValue);
            }
        }
    };
    IMenuListener2 menuManagerListener = new IMenuListener2(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IContributionItem)new GroupMarker("wbStart"));
        }

        public void menuAboutToHide(IMenuManager manager) {
        }
    };
    MenuListener menuListener = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            SWTPopupMenuParticipant.this.menuShown(e);
        }

        public void menuHidden(MenuEvent e) {
            SWTPopupMenuParticipant.this.menuHidden(e);
        }
    };

    protected void menuShown(MenuEvent e) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                SWTPopupMenuParticipant.this.setHint(DiagramHints.POPUP_MENU_SHOWN, time);
                SWTPopupMenuParticipant.this.removeHint(DiagramHints.POPUP_MENU_HIDDEN);
            }
        });
    }

    protected void menuHidden(MenuEvent e) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                SWTPopupMenuParticipant.this.removeHint(DiagramHints.POPUP_MENU_SHOWN);
                SWTPopupMenuParticipant.this.setHint(DiagramHints.POPUP_MENU_HIDDEN, time);
            }
        });
    }

    public SWTPopupMenuParticipant(IWorkbenchPartSite site, Control control, String menuId) {
        this(site, control, control.getDisplay(), menuId);
    }

    public SWTPopupMenuParticipant(IWorkbenchPartSite site, Control control, Display display, String menuId) {
        this.site = site;
        this.control = control;
        this.display = display;
        this.menuId = menuId;
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTPopupMenuParticipant.this.runDispose();
            }
        });
    }

    protected void runDispose() {
        this.control = null;
        if (this.menuManager != null) {
            this.menuManager.removeAll();
            this.menuManager.dispose();
            this.menuManager = null;
        }
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SWTPopupMenuParticipant.this.createControl();
            }
        });
        this.getHintStack().addKeyHintListener(DiagramHints.SHOW_POPUP_MENU, this.popupListener);
    }

    protected void createControl() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.menuManager = this.createPopupMenu();
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.control);
            menu.addMenuListener(this.menuListener);
            this.control.setMenu(menu);
            if (this.site != null) {
                this.site.registerContextMenu(this.menuManager.getId(), this.menuManager, (ISelectionProvider)this.wbsp);
            }
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(DiagramHints.SHOW_POPUP_MENU, this.popupListener);
        super.removedFromContext(ctx);
    }

    protected MenuManager createPopupMenu() {
        MenuManager mm = new MenuManager("Canvas Popup", this.menuId);
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener((IMenuListener)this.menuManagerListener);
        return mm;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommands(CommandEvent e) {
        if (e.command instanceof ShowPopup) {
            this.showPopup(((ShowPopup)e.command).getControlPosition());
            return true;
        }
        return false;
    }

    protected void showPopup(Point2D newValue) {
        final Point2D cp = newValue;
        this.setHint(DiagramHints.POPUP_MENU_CONTROL_POSITION, cp);
        this.setHint(DiagramHints.POPUP_MENU_CANVAS_POSITION, this.trUtil.controlToCanvas(cp, null));
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SWTPopupMenuParticipant.this.control == null || SWTPopupMenuParticipant.this.control.isDisposed()) {
                    return;
                }
                Point p = SWTPopupMenuParticipant.this.control.toDisplay((int)cp.getX(), (int)cp.getY());
                SWTPopupMenuParticipant.this.menuManager.getMenu().setLocation(p);
                SWTPopupMenuParticipant.this.menuManager.getMenu().setVisible(true);
            }
        });
    }
}

