/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.Text;
import com.kitfox.svg.Tspan;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.simantics.db.common.utils.Logger;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.EditDataNode;
import org.simantics.diagram.elements.EditorState;
import org.simantics.diagram.elements.EditorStateStatic;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.elements.TextEditActivation;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;

class EditorStateManager {
    static String TERM_STRING = "-----";
    static String EDITOR_CLASS = "edit";
    static String EDITOR_ID = "edit";
    private SVGNode node;
    private LinkedList<EditorState> editorState = null;
    private int editorStateIndex = 0;
    private TextEditActivation editActivation;

    EditorStateManager(SVGNode node) {
        this.node = node;
    }

    public boolean isEditMode() {
        return this.editorState != null;
    }

    public EditorState currentState() {
        return this.editorState.get(this.editorStateIndex);
    }

    public int currentHash() {
        if (!this.isEditMode()) {
            return 0;
        }
        return this.currentState().hashCode();
    }

    public void activateEditMode(SVGDiagram diagram, Text text) {
        if (this.isEditMode()) {
            return;
        }
        if (text.getId().length() == 0) {
            return;
        }
        EditorState es = new EditorState();
        es.base = new EditorStateStatic();
        es.base.textElementId = text.getId();
        Tspan span = (Tspan)text.getContent().get(0);
        String currentText = span.getText();
        SingleElementNode sne = this.node.getSingleElementNode();
        if (sne == null) {
            return;
        }
        Function1 fullTextFunction = (Function1)sne.getParameter("textEditorFullText");
        if (fullTextFunction != null) {
            es.currentText = (String)fullTextFunction.apply((Object)es.base.textElementId);
        }
        if (es.currentText == null) {
            es.currentText = currentText;
        }
        es.caretPosition = es.currentText.length();
        es.selectionOtherPosition = 0;
        try {
            span.setText("Ig");
            text.rebuild();
            diagram.updateTime(0.0);
            es.base.verticalDimensions = text.getBoundingBox();
            span.setText(TERM_STRING);
            text.rebuild();
            diagram.updateTime(0.0);
            es.base.termStringWidth = text.getBoundingBox().getWidth();
            span.setText(currentText);
            text.rebuild();
            diagram.updateTime(0.0);
        }
        catch (SVGException e) {
            e.printStackTrace();
        }
        ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this.node);
        IElement ie = DiagramNodeUtil.getElement(ctx, (IG2DNode)sne);
        EditDataNode data = EditDataNode.getNode((INode)this.node);
        this.deactivateEdit(data, null);
        TextEditActivation result = new TextEditActivation(0, ie, ctx);
        data.setTextEditActivation(result);
        this.editorState = new LinkedList();
        this.editorState.push(es);
        this.editorStateIndex = 0;
        this.paint();
    }

    void applyEdit() {
        SingleElementNode sne = this.node.getSingleElementNode();
        if (sne != null) {
            EditorState es = this.currentState();
            Function2 editor = (Function2)sne.getParameter("textEditor");
            if (editor != null) {
                editor.apply((Object)es.base.textElementId, (Object)es.currentText);
            }
        }
    }

    protected boolean deactivateEdit() {
        boolean result = this.deactivateEdit(this.editActivation);
        boolean bl = this.editActivation != null;
        this.editActivation = null;
        this.editorState = null;
        this.paint();
        return result |= bl;
    }

    protected boolean deactivateEdit(TextEditActivation activation) {
        return this.deactivateEdit(EditDataNode.getNode((INode)this.node), activation);
    }

    protected boolean deactivateEdit(EditDataNode data, TextEditActivation activation) {
        TextEditActivation previous = data.getTextEditActivation();
        if (previous != null && (previous == activation || activation == null)) {
            previous.release();
            data.setTextEditActivation(null);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        block2: {
            block3: {
                if (!this.isEditMode() || !(nes = (es = this.currentState()).copy()).keyPressed(this, e)) break block2;
                if (!this.isEditMode()) {
                    return true;
                }
                if (!nes.shouldReplace(es)) ** GOTO lbl9
                es.replace(nes);
                break block3;
lbl-1000:
                // 1 sources

                {
                    this.editorState.removeLast();
lbl9:
                    // 2 sources

                    ** while (this.editorState.size() > this.editorStateIndex + 1)
                }
lbl10:
                // 1 sources

                this.editorState.add(nes);
                this.editorStateIndex = this.editorState.size() - 1;
            }
            return true;
        }
        return false;
    }

    public boolean tryToStartEditMode(SVGDiagram diagram) {
        SVGElement element = diagram.getElement(EDITOR_ID);
        if (element != null && element instanceof Text) {
            this.activateEditMode(diagram, (Text)element);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryToStartEditMode(SVGDiagram diagram, MouseEvent.MouseClickEvent e) {
        if (diagram == null) return false;
        Point2D local = this.node.controlToLocal(e.controlPosition);
        local = this.node.parentToLocal(local);
        double tolerance = 2.0;
        Rectangle2D.Double pickRect = new Rectangle2D.Double(local.getX() - tolerance, local.getY() - tolerance, 2.0 * tolerance, 2.0 * tolerance);
        try {
            List retVec = diagram.pick((Rectangle2D)pickRect, null);
            int i = 0;
            block2: while (true) {
                if (i >= retVec.size()) {
                    return false;
                }
                List l = (List)retVec.get(i);
                int j = 0;
                while (true) {
                    String clazz;
                    Text text;
                    if (j >= l.size()) {
                        ++i;
                        continue block2;
                    }
                    SVGElement element = (SVGElement)l.get(j);
                    if (element instanceof Tspan) {
                        return true;
                    }
                    if (element instanceof Text && (text = (Text)element).hasAttribute("class", 1) && (clazz = text.getPresAbsolute("class").getStringValue()).contains(EDITOR_CLASS)) {
                        this.activateEditMode(diagram, text);
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (SVGException e1) {
            Logger.defaultLogError((Throwable)e1);
        }
        return false;
    }

    boolean applyEditMode(SVGDiagram diagram) throws SVGException {
        if (this.isEditMode()) {
            EditorState es = this.currentState();
            es.applyEditMode(diagram);
            return true;
        }
        return false;
    }

    void paint() {
        this.node.cleanDiagramCache();
        this.node.repaint();
    }

    void undo() {
        while (this.editorStateIndex > 0 && this.currentState().modificationClass.equals((Object)EditorState.ModificationClass.NO_EDIT)) {
            --this.editorStateIndex;
        }
        if (this.editorStateIndex > 0) {
            --this.editorStateIndex;
        }
        this.paint();
    }

    void redo() {
        while (this.editorStateIndex < this.editorState.size() - 1 && this.currentState().modificationClass.equals((Object)EditorState.ModificationClass.NO_EDIT)) {
            ++this.editorStateIndex;
        }
        if (this.editorStateIndex < this.editorState.size() - 1) {
            ++this.editorStateIndex;
        }
        this.paint();
    }
}

