/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;

public final class EventTypes {
    public static final int Command = 1;
    public static final int CommandMask = EventTypes.toMask(1);
    public static final int FocusGained = 2;
    public static final int FocusGainedMask = EventTypes.toMask(2);
    public static final int FocusLost = 3;
    public static final int FocusLostMask = EventTypes.toMask(3);
    public static final int FocusMask = FocusGainedMask | FocusLostMask;
    public static final int KeyPressed = 4;
    public static final int KeyPressedMask = EventTypes.toMask(4);
    public static final int KeyReleased = 5;
    public static final int KeyReleasedMask = EventTypes.toMask(5);
    public static final int KeyMask = KeyPressedMask | KeyReleasedMask;
    public static final int MouseButtonPressed = 6;
    public static final int MouseButtonPressedMask = EventTypes.toMask(6);
    public static final int MouseButtonReleased = 7;
    public static final int MouseButtonReleasedMask = EventTypes.toMask(7);
    public static final int MouseClick = 8;
    public static final int MouseClickMask = EventTypes.toMask(8);
    public static final int MouseDoubleClick = 9;
    public static final int MouseDoubleClickMask = EventTypes.toMask(9);
    public static final int MouseDragBegin = 10;
    public static final int MouseDragBeginMask = EventTypes.toMask(10);
    public static final int MouseButtonMask = MouseButtonPressedMask | MouseButtonReleasedMask | MouseClickMask | MouseDoubleClickMask | MouseDragBeginMask;
    public static final int MouseEnter = 11;
    public static final int MouseEnterMask = EventTypes.toMask(11);
    public static final int MouseExit = 12;
    public static final int MouseExitMask = EventTypes.toMask(12);
    public static final int MouseMoved = 13;
    public static final int MouseMovedMask = EventTypes.toMask(13);
    public static final int MouseMoveMask = MouseEnterMask | MouseExitMask | MouseMovedMask;
    public static final int MouseWheel = 14;
    public static final int MouseWheelMask = EventTypes.toMask(14);
    public static final int MouseMask = MouseButtonMask | MouseMoveMask | MouseWheelMask;
    public static final int Time = 15;
    public static final int TimeMask = EventTypes.toMask(15);
    public static final int AnyMask = CommandMask | FocusMask | KeyMask | MouseMask | TimeMask;
    private static ConcurrentMap<Class<?>, Integer> maskCache = new ConcurrentHashMap();
    private static ConcurrentMap<Class<?>, Integer> typeCache = new ConcurrentHashMap();

    public static boolean passes(IEventHandler handler, Event event) {
        int mask = handler.getEventMask();
        return EventTypes.passes(mask, event);
    }

    public static boolean passes(int mask, Event event) {
        int et = EventTypes.toTypeMask(event);
        return (et & mask) != 0;
    }

    public static boolean passes(IEventHandler handler, int eventTypeMask) {
        return (eventTypeMask & handler.getEventMask()) != 0;
    }

    public static boolean passes(int mask, int eventTypeMask) {
        return (eventTypeMask & mask) != 0;
    }

    public static int toTypeMask(Event event) {
        return event != null ? EventTypes.toTypeMask(event.getClass()) : 0;
    }

    public static int toType(Event event) {
        return event != null ? EventTypes.toType(event.getClass()) : 0;
    }

    public static int toTypeMask(Class<? extends Event> clazz) {
        if (clazz == null) {
            return 0;
        }
        Integer type = (Integer)maskCache.get(clazz);
        if (type != null) {
            return type;
        }
        type = EventTypes.calculateTypeMask(clazz);
        maskCache.putIfAbsent(clazz, type);
        return type;
    }

    public static int toType(Class<? extends Event> clazz) {
        if (clazz == null) {
            return 0;
        }
        Integer type = (Integer)typeCache.get(clazz);
        if (type != null) {
            return type;
        }
        type = EventTypes.calculateType(clazz);
        typeCache.putIfAbsent(clazz, type);
        return type;
    }

    private static int calculateTypeMask(Class<? extends Event> clazz) {
        if (Event.class.isAssignableFrom(clazz)) {
            if (MouseEvent.class.isAssignableFrom(clazz)) {
                if (MouseEvent.MouseMovedEvent.class.isAssignableFrom(clazz)) {
                    return MouseMovedMask;
                }
                if (MouseEvent.MouseButtonPressedEvent.class.isAssignableFrom(clazz)) {
                    return MouseButtonPressedMask;
                }
                if (MouseEvent.MouseButtonReleasedEvent.class.isAssignableFrom(clazz)) {
                    return MouseButtonReleasedMask;
                }
                if (MouseEvent.MouseClickEvent.class.isAssignableFrom(clazz)) {
                    return MouseClickMask;
                }
                if (MouseEvent.MouseWheelMovedEvent.class.isAssignableFrom(clazz)) {
                    return MouseWheelMask;
                }
                if (MouseEvent.MouseDoubleClickedEvent.class.isAssignableFrom(clazz)) {
                    return MouseDoubleClickMask;
                }
                if (MouseEvent.MouseDragBegin.class.isAssignableFrom(clazz)) {
                    return MouseDragBeginMask;
                }
                if (MouseEvent.MouseEnterEvent.class.isAssignableFrom(clazz)) {
                    return MouseEnterMask;
                }
                if (MouseEvent.MouseExitEvent.class.isAssignableFrom(clazz)) {
                    return MouseExitMask;
                }
                return MouseMask;
            }
            if (KeyEvent.class.isAssignableFrom(clazz)) {
                if (KeyEvent.KeyPressedEvent.class.isAssignableFrom(clazz)) {
                    return KeyPressedMask;
                }
                if (KeyEvent.KeyReleasedEvent.class.isAssignableFrom(clazz)) {
                    return KeyReleasedMask;
                }
                return KeyMask;
            }
            if (FocusEvent.class.isAssignableFrom(clazz)) {
                if (FocusEvent.FocusGainedEvent.class.isAssignableFrom(clazz)) {
                    return FocusGainedMask;
                }
                if (FocusEvent.FocusLostEvent.class.isAssignableFrom(clazz)) {
                    return FocusLostMask;
                }
                return FocusMask;
            }
            if (CommandEvent.class.isAssignableFrom(clazz)) {
                return CommandMask;
            }
            if (TimeEvent.class.isAssignableFrom(clazz)) {
                return TimeMask;
            }
            return AnyMask;
        }
        throw new IllegalArgumentException("unrecognized event class: " + clazz);
    }

    private static int calculateType(Class<? extends Event> clazz) {
        if (Event.class.isAssignableFrom(clazz)) {
            if (MouseEvent.class.isAssignableFrom(clazz)) {
                if (MouseEvent.MouseMovedEvent.class.isAssignableFrom(clazz)) {
                    return 13;
                }
                if (MouseEvent.MouseButtonPressedEvent.class.isAssignableFrom(clazz)) {
                    return 6;
                }
                if (MouseEvent.MouseButtonReleasedEvent.class.isAssignableFrom(clazz)) {
                    return 7;
                }
                if (MouseEvent.MouseClickEvent.class.isAssignableFrom(clazz)) {
                    return 8;
                }
                if (MouseEvent.MouseWheelMovedEvent.class.isAssignableFrom(clazz)) {
                    return 14;
                }
                if (MouseEvent.MouseDoubleClickedEvent.class.isAssignableFrom(clazz)) {
                    return 9;
                }
                if (MouseEvent.MouseDragBegin.class.isAssignableFrom(clazz)) {
                    return 10;
                }
                if (MouseEvent.MouseEnterEvent.class.isAssignableFrom(clazz)) {
                    return 11;
                }
                if (MouseEvent.MouseExitEvent.class.isAssignableFrom(clazz)) {
                    return 12;
                }
            }
            if (KeyEvent.class.isAssignableFrom(clazz)) {
                if (KeyEvent.KeyPressedEvent.class.isAssignableFrom(clazz)) {
                    return 4;
                }
                if (KeyEvent.KeyReleasedEvent.class.isAssignableFrom(clazz)) {
                    return 5;
                }
            }
            if (FocusEvent.class.isAssignableFrom(clazz)) {
                if (FocusEvent.FocusGainedEvent.class.isAssignableFrom(clazz)) {
                    return 2;
                }
                if (FocusEvent.FocusLostEvent.class.isAssignableFrom(clazz)) {
                    return 3;
                }
            }
            if (CommandEvent.class.isAssignableFrom(clazz)) {
                return 1;
            }
            if (TimeEvent.class.isAssignableFrom(clazz)) {
                return 15;
            }
        }
        throw new IllegalArgumentException("unrecognized event class: " + clazz);
    }

    private static int toMask(int eventType) {
        return 1 << eventType;
    }
}

