/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.simantics.DatabaseJob;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.request.Read;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;

public class SimanticsUI {
    public static final String PLUGIN_ID = "org.simantics.ui";
    public static final long UI_THREAD_REQUEST_START_TIMEOUT = SimanticsUI.parseLongProperty("simantics.ui.request.start.timeout", 500L);
    public static final long UI_THREAD_REQUEST_EXECUTION_TIMEOUT = SimanticsUI.parseLongProperty("simantics.ui.request.exec.timeout", 50L);
    public static final long UI_THREAD_REQUEST_EXECUTION_TIMEOUT_LONG = SimanticsUI.parseLongProperty("simantics.ui.request.exec.timeout.long", 100L);
    private static ISessionContextProviderSource providerSource = null;

    public static void setSessionContextProviderSource(ISessionContextProviderSource source) {
        if (source == null) {
            throw new IllegalArgumentException("null provider source");
        }
        providerSource = source;
    }

    public static ISessionContextProviderSource getProviderSource() {
        if (providerSource == null) {
            throw new IllegalStateException("providerSource must be initialized by the application before using SimanticsUI");
        }
        return providerSource;
    }

    public static synchronized void closeSessions() {
        ISessionContextProviderSource source = providerSource;
        if (source == null) {
            return;
        }
        ISessionContextProvider[] iSessionContextProviderArray = source.getAll();
        int n = iSessionContextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionContextProvider p = iSessionContextProviderArray[n2];
            ISessionContext ctx = p.setSessionContext(null);
            if (ctx != null) {
                ctx.dispose();
            }
            ++n2;
        }
    }

    public static synchronized boolean isInUse(ISessionContext ctx) {
        ISessionContextProvider[] iSessionContextProviderArray = SimanticsUI.getProviderSource().getAll();
        int n = iSessionContextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionContextProvider p = iSessionContextProviderArray[n2];
            if (p.getSessionContext() == ctx) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static synchronized boolean isInUse(IProject project, ISessionContext ... excluding) {
        ISessionContextProvider[] iSessionContextProviderArray = SimanticsUI.getProviderSource().getAll();
        int n = iSessionContextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionContextProvider p = iSessionContextProviderArray[n2];
            ISessionContext ctx = p.getSessionContext();
            if (ctx != null && Arrays.indexOf((Object[])excluding, (Object)ctx) == -1 && ctx.getHint(ProjectKeys.KEY_PROJECT) == project) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ISessionContextProvider getSessionContextProvider() {
        return SimanticsUI.getProviderSource().getActive();
    }

    public static ISessionContextProvider getSessionContextProvider(Object handle) {
        return SimanticsUI.getProviderSource().get(handle);
    }

    public static ISessionContext getSessionContext() {
        ISessionContextProvider provider = SimanticsUI.getSessionContextProvider();
        return provider != null ? provider.getSessionContext() : null;
    }

    public static ISessionContext getSessionContext(Object handle) {
        return SimanticsUI.getSessionContextProvider(handle).getSessionContext();
    }

    public static synchronized ISessionContext setSessionContext(ISessionContext ctx) {
        return SimanticsUI.getSessionContextProvider().setSessionContext(ctx);
    }

    public static synchronized ISessionContext setSessionContext(Object handle, ISessionContext ctx) {
        ISessionContextProvider provider = SimanticsUI.getProviderSource().get(handle);
        if (provider != null) {
            return provider.setSessionContext(ctx);
        }
        return null;
    }

    public static Session getSession() {
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("Session unavailable, no database session open");
        }
        return ctx.getSession();
    }

    public static Session peekSession() {
        ISessionContext ctx = SimanticsUI.getSessionContext();
        return ctx == null ? null : ctx.peekSession();
    }

    public static IProject peekProject() {
        ISessionContext ctx = SimanticsUI.getSessionContext();
        return ctx == null ? null : (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
    }

    public static IProject peekProject(ISessionContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
    }

    public static IProject getProject() {
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("No current database session");
        }
        return (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
    }

    public static ImageDescriptor getImageDescriptor(String imageFilePath) {
        return BundleUtils.getImageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
    }

    public static <T> T filterSingleSelection(ISelection sel, Class<T> assignableFrom) {
        Object result = ISelectionUtils.filterSingleSelection((Object)sel, assignableFrom);
        if (result != null) {
            return (T)result;
        }
        Resource resource = (Resource)ISelectionUtils.filterSingleSelection((Object)sel, Resource.class);
        if (resource == null) {
            return null;
        }
        try {
            return (T)SimanticsUI.getSession().syncRequest((Read)new Adapter(resource, assignableFrom));
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static <T> T filterSingleWorkbenchSelection(Class<T> assignableFrom) {
        return SimanticsUI.filterSingleSelection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection(), assignableFrom);
    }

    public static void asyncExecSWT(Widget widget, Runnable runnable) {
        SWTUtils.asyncExec((Widget)widget, (Runnable)SimanticsUI.delayedExecSWT(null, widget, runnable));
    }

    public static void asyncExecSWT(Display display, Runnable runnable) {
        SWTUtils.asyncExec((Display)display, (Runnable)SimanticsUI.delayedExecSWT(display, null, runnable));
    }

    private static Runnable delayedExecSWT(final Display display, final Widget widget, final Runnable runnable) {
        if (display == null && widget == null) {
            throw new IllegalArgumentException("both display and widget are null");
        }
        return new Runnable(){

            @Override
            public void run() {
                if (display != null && display.isDisposed()) {
                    return;
                }
                if (widget != null && widget.isDisposed()) {
                    return;
                }
                if (DatabaseJob.inProgress()) {
                    Display d = display != null ? display : widget.getDisplay();
                    d.timerExec(50, (Runnable)this);
                    return;
                }
                runnable.run();
            }
        };
    }

    private static long parseLongProperty(String propertyName, long defaultValue) {
        String value = System.getProperty(propertyName, null);
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static boolean isLinuxGTK() {
        String ws = System.getProperty("osgi.ws");
        return ws != null && "gtk".equals(ws);
    }
}

