/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.Persistable;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.UndoClusterUpdateProcessor;
import org.simantics.acorn.lru.ClusterChangeSet;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.acorn.lru.LRU;
import org.simantics.acorn.lru.LRUObject;
import org.simantics.compressions.CompressionCodec;
import org.simantics.compressions.Compressions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.Bytes;
import org.simantics.utils.datastructures.Pair;

public class ClusterStreamChunk
extends LRUObject<String, ClusterStreamChunk>
implements Persistable {
    private static int MAX_CHUNK_SIZE = 512000;
    int size = 0;
    private final ClusterManager manager;
    private boolean committed = false;
    public int nextToProcess = 0;
    public ArrayList<ClusterUpdateOperation> operations = new ArrayList();
    private static StreamDecompressor decompressor = new StreamDecompressor();

    public ClusterStreamChunk(ClusterManager manager, LRU<String, ClusterStreamChunk> LRU2, Path readDir, String id, int offset, int length) throws AcornAccessVerificationException {
        super(LRU2, id, readDir, "clusterStream", offset, length, false, false);
        this.manager = manager;
        LRU2.map(this);
    }

    public ClusterStreamChunk(ClusterManager manager, LRU<String, ClusterStreamChunk> LRU2, String id) throws AcornAccessVerificationException {
        super(LRU2, id, LRU2.getDirectory(), "clusterStream", true, true);
        this.manager = manager;
        LRU2.insert(this, this.accessTime);
    }

    public UndoClusterUpdateProcessor getUndoProcessor(ClusterManager clusters, int chunkOffset, String ccsId) throws DatabaseException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident(true);
        ClusterUpdateOperation op = this.operations.get(chunkOffset);
        if (op == null) {
            throw new IllegalAcornStateException("Cluster Update Operation " + ccsId + " was not found.");
        }
        if (op.ccs == null) {
            throw new IllegalAcornStateException("Cluster ChangeSet " + ccsId + " was not found.");
        }
        UndoClusterUpdateProcessor proc = new UndoClusterUpdateProcessor(clusters, this, op.ccs);
        if (proc.version != 1) {
            return null;
        }
        clusters.clusterLRU.ensureUpdates(proc.getClusterUID());
        proc.process();
        this.cancelForceResident();
        return proc;
    }

    public void addOperation(ClusterUpdateOperation op) throws IllegalAcornStateException {
        if (this.committed) {
            throw new IllegalAcornStateException("Cannot add operation " + op + " to " + this + " if commited == true");
        }
        this.operations.add(op);
        this.size += op.data.length;
    }

    public byte[] getOperation(int index) {
        return this.operations.get((int)index).data;
    }

    public void commit() {
        this.committed = true;
    }

    public boolean isCommitted() {
        if (this.size > MAX_CHUNK_SIZE) {
            this.committed = true;
        }
        return this.committed;
    }

    @Override
    public boolean canBePersisted() throws AcornAccessVerificationException {
        if (!super.canBePersisted()) {
            return false;
        }
        if (!this.isCommitted()) {
            return false;
        }
        for (ClusterUpdateOperation op : this.operations) {
            if (op.finished) continue;
            return false;
        }
        return true;
    }

    private static void writeLE(TByteArrayList bytes, int value) {
        bytes.add((byte)(value & 0xFF));
        bytes.add((byte)(value >>> 8 & 0xFF));
        bytes.add((byte)(value >>> 16 & 0xFF));
        bytes.add((byte)(value >>> 24 & 0xFF));
    }

    public static final void writeLE8(TByteArrayList bytes, long value) {
        bytes.add((byte)(value & 0xFFL));
        bytes.add((byte)(value >>> 8 & 0xFFL));
        bytes.add((byte)(value >>> 16 & 0xFFL));
        bytes.add((byte)(value >>> 24 & 0xFFL));
        bytes.add((byte)(value >>> 32 & 0xFFL));
        bytes.add((byte)(value >>> 40 & 0xFFL));
        bytes.add((byte)(value >>> 48 & 0xFFL));
        bytes.add((byte)(value >>> 56 & 0xFFL));
    }

    @Override
    protected Pair<byte[], Integer> toBytes() {
        assert (this.isCommitted());
        TByteArrayList raw = new TByteArrayList();
        ClusterStreamChunk.writeLE(raw, this.operations.size());
        for (ClusterUpdateOperation op : this.operations) {
            ClusterStreamChunk.writeLE(raw, op.data.length);
            raw.add(op.data);
            op.data = null;
            ClusterStreamChunk.writeLE(raw, op.ccs.statementMask.size());
            raw.add(op.ccs.statementMask.toArray());
            ClusterStreamChunk.writeLE(raw, op.ccs.oldValueEx.size());
            raw.add(op.ccs.oldValueEx.toArray());
            ClusterStreamChunk.writeLE(raw, op.ccs.oldValues.size());
            for (byte[] oldValue : op.ccs.oldValues) {
                int len = oldValue != null ? oldValue.length : -1;
                ClusterStreamChunk.writeLE(raw, len);
                if (oldValue == null) continue;
                raw.add(oldValue);
            }
        }
        byte[] raw_ = raw.toArray();
        CompressionCodec codec = Compressions.get((String)"LZ4");
        ByteBuffer input = ByteBuffer.wrap(raw_);
        ByteBuffer output = ByteBuffer.allocate(raw_.length + raw_.length / 8);
        int compressedSize = codec.compressBuffer(input, 0, raw_.length, output, 0);
        byte[] rawOutput = new byte[compressedSize + 4];
        output.get(rawOutput, 0, compressedSize);
        Bytes.writeLE((byte[])rawOutput, (int)compressedSize, (int)raw_.length);
        this.release();
        return Pair.make((Object)rawOutput, (Object)rawOutput.length);
    }

    @Override
    void release() {
        for (ClusterUpdateOperation op : this.operations) {
            op.data = null;
            op.ccs = null;
        }
    }

    @Override
    public void fromFile(byte[] data_) throws IllegalAcornStateException, AcornAccessVerificationException {
        try {
            byte[] data = decompressor.decompressBuffer(data_);
            this.operations = new ArrayList();
            int offset = 0;
            int opLen = Bytes.readLE4((byte[])data, (int)offset);
            offset += 4;
            int i = 0;
            while (i < opLen) {
                int len = Bytes.readLE4((byte[])data, (int)offset);
                byte[] bytes = new byte[len];
                System.arraycopy(data, offset += 4, bytes, 0, len);
                ClusterUpdateOperation op = new ClusterUpdateOperation(this.manager, bytes);
                String ccsKey = String.valueOf((String)this.getKey()) + "." + i;
                op.ccs = new ClusterChangeSet(ccsKey, op.uid);
                op.chunk = this;
                int statementMaskLen = Bytes.readLE4((byte[])data, (int)(offset += len));
                offset += 4;
                op.ccs.statementMask = new TByteArrayList(statementMaskLen);
                int j = 0;
                while (j < statementMaskLen) {
                    op.ccs.statementMask.add(data[offset++]);
                    ++j;
                }
                int oldValueExLen = Bytes.readLE4((byte[])data, (int)offset);
                offset += 4;
                op.ccs.oldValueEx = new TByteArrayList(oldValueExLen);
                int j2 = 0;
                while (j2 < oldValueExLen) {
                    op.ccs.oldValueEx.add(data[offset++]);
                    ++j2;
                }
                int oldValuesSize = Bytes.readLE4((byte[])data, (int)offset);
                offset += 4;
                op.ccs.oldValues = new ArrayList(oldValuesSize);
                int j3 = 0;
                while (j3 < oldValuesSize) {
                    int oldValueSize = Bytes.readLE4((byte[])data, (int)offset);
                    offset += 4;
                    if (oldValueSize == -1) {
                        op.ccs.oldValues.add(null);
                    } else {
                        byte[] oldValue = new byte[oldValueSize];
                        System.arraycopy(data, offset, oldValue, 0, oldValueSize);
                        offset += oldValueSize;
                        op.ccs.oldValues.add(oldValue);
                    }
                    ++j3;
                }
                this.operations.add(op);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IllegalAcornStateException(e);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
    }

    @Override
    String getExtension() {
        return "stream";
    }

    public String toString() {
        return "ClusterUpdateOperationChunk " + (String)this.getKey();
    }

    @Override
    protected boolean overwrite() {
        return false;
    }

    static class StreamDecompressor {
        StreamDecompressor() {
        }

        public synchronized byte[] decompressBuffer(byte[] compressed) throws IOException {
            int deflatedSize = Bytes.readLE4((byte[])compressed, (int)(compressed.length - 4));
            byte[] result = new byte[deflatedSize];
            CompressionCodec codec = Compressions.get((String)"LZ4");
            ByteBuffer input = ByteBuffer.wrap(compressed);
            ByteBuffer output = ByteBuffer.wrap(result);
            int decompressedSize = codec.decompressBuffer(input, 0, compressed.length - 4, output, 0, result.length);
            assert (decompressedSize == deflatedSize);
            return result;
        }
    }
}

