/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.synchronization;

import java.io.StringReader;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.graph.ExcelArrayFormula;
import org.simantics.spreadsheet.graph.ExcelFormula;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetCell;
import org.simantics.spreadsheet.graph.SpreadsheetFormula;
import org.simantics.spreadsheet.graph.SpreadsheetLine;
import org.simantics.spreadsheet.graph.SpreadsheetLines;
import org.simantics.spreadsheet.graph.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.graph.function.LineContentBean;
import org.simantics.spreadsheet.graph.function.LineContentBeanCell;
import org.simantics.spreadsheet.graph.parser.SheetFormulaParser;
import org.simantics.spreadsheet.graph.parser.ast.AstArrayFormulaReference;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.Solver;

public class LineCommandBuilder
implements CommandBuilder {
    private String name;
    LineContentBean bean;

    public LineCommandBuilder(String name, boolean update) {
        this.name = name;
    }

    public void apply(Solver solver) {
        SpreadsheetBook book = (SpreadsheetBook)solver.getConcreteSolver();
        String path = this.name.substring(0, this.name.lastIndexOf("/"));
        String lineName = this.name.substring(this.name.lastIndexOf("/") + 1);
        int row = Integer.parseInt(lineName.substring(3));
        SpreadsheetLines node = (SpreadsheetLines)book.ensureSubprocess(path);
        SpreadsheetLine line = (SpreadsheetLine)node.lines.get(-row);
        if (line == null) {
            line = new SpreadsheetLine(node, row);
            node.lines.put(-row, (Object)line);
        }
        int i = 0;
        while (i < this.bean.cells.length) {
            SpreadsheetCell currentCell;
            if (line.cells.size() > i) {
                currentCell = (SpreadsheetCell)line.cells.get(i);
            } else {
                currentCell = new SpreadsheetCell(line, i);
                line.cells.add((Object)currentCell);
            }
            LineContentBeanCell cell = this.bean.cells[i];
            try {
                Variant content = cell.getContent();
                if (content instanceof Variant) {
                    SpreadsheetFormula sformula;
                    AstValue v;
                    SheetFormulaParser p;
                    Object formula;
                    Variant cellVariant = content;
                    if (cellVariant == LineContentBeanCell.EMPTY) {
                        currentCell.setStyle(cell.getStyleId());
                        currentCell.setContent("");
                    } else if (ExcelFormula.BINDING.type().equals((Object)cellVariant.getBinding().type())) {
                        formula = (ExcelFormula)cellVariant.getValue(ExcelFormula.BINDING);
                        p = new SheetFormulaParser(new StringReader(((ExcelFormula)formula).expression));
                        v = p.relation();
                        currentCell.setStyle(cell.getStyleId());
                        sformula = new SpreadsheetFormula(v, ((ExcelFormula)formula).expression);
                        currentCell.setContent(sformula);
                    } else if (ExcelArrayFormula.BINDING.type().equals((Object)cellVariant.getBinding().type())) {
                        formula = (ExcelArrayFormula)cellVariant.getValue(ExcelArrayFormula.BINDING);
                        p = new SheetFormulaParser(new StringReader(((ExcelArrayFormula)formula).expression));
                        v = new AstArrayFormulaReference(((ExcelArrayFormula)formula).range, p.relation());
                        currentCell.setStyle(cell.getStyleId());
                        sformula = new SpreadsheetFormula(v, ((ExcelArrayFormula)formula).expression);
                        currentCell.setContent(sformula);
                    } else {
                        currentCell.setStyle(cell.getStyleId());
                        currentCell.setContent(cellVariant.getValue());
                    }
                } else if (content instanceof SpreadsheetSCLConstant) {
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent(content);
                }
            }
            catch (Throwable e) {
                Variant content = cell.getContent();
                if (content instanceof Variant) {
                    Variant cellVariant = content;
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent(content);
                    try {
                        new Exception("failed: " + ((ExcelFormula)cellVariant.getValue((Binding)ExcelFormula.BINDING)).expression, e).printStackTrace();
                    }
                    catch (AdaptException e1) {
                        e1.printStackTrace();
                    }
                }
                currentCell.setStyle(cell.getStyleId());
                currentCell.setContent("LCB error happened");
            }
            ++i;
        }
    }

    public <T> T getConcrete() {
        return (T)this;
    }
}

