/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class Delete
extends AbstractHandler {
    protected final String virtualGraphId;

    public Delete() {
        this.virtualGraphId = "experiments";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = Simantics.peekSession();
        if (session == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final List resources = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        final VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
                HashSet<Resource> eventLogs = new HashSet<Resource>();
                for (Resource event : resources) {
                    Resource eventlog;
                    Resource slice;
                    if (graph.isInstanceOf(event, EVENT.Event) && (slice = graph.getPossibleObject(event, L0.PartOf)) != null && (eventlog = graph.getPossibleObject(slice, L0.PartOf)) != null) {
                        eventLogs.add(eventlog);
                    }
                    graph.deny(event);
                }
                for (Resource eventlog : eventLogs) {
                    if (!graph.isInstanceOf(eventlog, EVENT.EventLog)) continue;
                    graph.syncRequest((Write)new CorrectMilestoneLabelsAction(eventlog, vg));
                }
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                if (e != null) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
        });
        return null;
    }
}

