/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.contribution;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.Constants;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.format.TimeFormat;

public enum EventLabelRule implements LabelRule
{
    INSTANCE;

    private static final NumberFormat secondFormatter;
    private static final TimeFormat timeFormat;

    static {
        timeFormat = new TimeFormat(Double.MAX_VALUE, 3);
        secondFormatter = NumberFormat.getNumberInstance(Locale.US);
        secondFormatter.setMinimumFractionDigits(2);
        secondFormatter.setMaximumFractionDigits(3);
        secondFormatter.setRoundingMode(RoundingMode.HALF_EVEN);
    }

    public static EventLabelRule get() {
        return INSTANCE;
    }

    public static String formatSeconds(double time) {
        return secondFormatter.format(time);
    }

    public static String formatHMSS(double time) {
        return timeFormat.format((Object)time);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content, boolean allInformation) throws DatabaseException {
        IEclipsePreferences chartPreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        boolean timeFormat = chartPreferenceNode.get("chart.timeformat", "Time").equals("Time");
        Resource event = (Resource)content;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        String tag = (String)graph.getPossibleRelatedValue(event, EVENT.Event_tag, (Binding)Bindings.STRING);
        String message = (String)graph.getPossibleRelatedValue(event, EVENT.Event_message, (Binding)Bindings.STRING);
        if (message == null) {
            message = (String)graph.getPossibleRelatedValue(event, L0.HasLabel, (Binding)Bindings.STRING);
            if (message == null) {
                message = (String)graph.getPossibleRelatedValue(event, L0.HasName, (Binding)Bindings.STRING);
            }
            if (message == null) {
                message = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)event);
            }
        }
        StringBuilder eventType = new StringBuilder();
        Integer eventTypeNumber = (Integer)graph.getPossibleRelatedValue(event, EVENT.Event_typeNumber);
        Resource et = graph.getPossibleObject(event, EVENT.Event_type);
        if (et != null) {
            if (eventTypeNumber != null) {
                eventType.append(eventTypeNumber).append(": ");
            }
            eventType.append(NameUtils.getSafeLabel((ReadGraph)graph, (Resource)et));
        } else if (eventTypeNumber != null) {
            eventType.append(eventTypeNumber);
        }
        double timeNumeric = EventLabelRule.getTimestamp(graph, event, 0.0);
        String time = EventLabelRule.getTimestampString(graph, timeNumeric, timeFormat);
        Integer index = (Integer)graph.getPossibleRelatedValue(event, EVENT.Event_index, (Binding)Bindings.INTEGER);
        String indexS = "";
        if (index != null) {
            indexS = String.valueOf(index);
        }
        double returnTimeNumeric = 0.0;
        String returnTime = null;
        Resource returnedBy = graph.getPossibleObject(event, EVENT.ReturnedBy);
        if (returnedBy != null) {
            returnTimeNumeric = EventLabelRule.getTimestamp(graph, returnedBy, 0.0);
            returnTime = EventLabelRule.getTimestampString(graph, returnTimeNumeric, timeFormat);
        }
        String sourceName = (String)graph.getPossibleRelatedValue(event, EVENT.Event_sourceName);
        String milestone = null;
        String returned = null;
        if (allInformation) {
            String string = returned = returnedBy != null ? "Yes" : "";
            if (returnTime == null) {
                returnTime = "";
            }
            milestone = "";
            if (graph.hasStatement(event, EVENT.Milestone) && (milestone = (String)graph.getPossibleRelatedValue(event, EVENT.Event_milestoneLabel)) == null) {
                milestone = "?";
            }
        }
        return ArrayMap.make((Object[])Constants.COLUMN_KEYS, (Object[])new String[]{indexS, time, String.valueOf(timeNumeric), milestone, eventType.toString(), returned, tag, message, returnTime, String.valueOf(returnTimeNumeric), sourceName});
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        return this.getLabel(graph, content, false);
    }

    public static double getTimestamp(ReadGraph graph, Resource event, double defaultValue) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Double d = (Double)graph.getPossibleRelatedValue(event, EVENT.HasTimestamp, (Binding)Bindings.DOUBLE);
        return d != null ? d : defaultValue;
    }

    public static String getTimestampString(ReadGraph graph, double t, boolean timeFormat) {
        return timeFormat ? EventLabelRule.formatHMSS(t) : EventLabelRule.formatSeconds(t);
    }
}

