/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.event.view.contribution.EventLabelRule;
import org.simantics.event.view.contribution.ProjectEventsRule;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.EString;

public class EventExporter {
    public void exportCsv(final IProgressMonitor monitor, File file, final String columnSeparator) throws DatabaseException, IOException {
        final PrintStream out = new PrintStream(file);
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    EventExporter.this.exportCsv(graph, monitor, out, columnSeparator);
                }
            });
        }
        finally {
            FileUtils.uncheckedClose((Closeable)out);
        }
    }

    public void exportCsv(ReadGraph graph, IProgressMonitor monitor, PrintStream out, String columnSeparator) throws DatabaseException {
        Collection<?> events = ProjectEventsRule.INSTANCE.getChildren(graph, Simantics.getProjectResource());
        if (events.isEmpty()) {
            out.println("No visible events recorded.");
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export events", (int)events.size());
        boolean first = true;
        for (Object obj : events) {
            if (mon.isCanceled()) {
                return;
            }
            Resource event = (Resource)obj;
            Map<String, String> labels = EventLabelRule.INSTANCE.getLabel(graph, event, true);
            if (first) {
                out.println(EString.implode(labels.keySet(), (String)columnSeparator));
                first = false;
            }
            out.println(EString.implode(labels.values(), (String)columnSeparator));
            mon.worked(1);
        }
    }
}

