/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.model.modifiers.L0StringModifier;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.StringModifierFactory;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Write;

public class SingleObjectStringPropertyModifierRule
implements ModifierRule {
    private Resource relation;
    private Resource propertyRelation;

    public SingleObjectStringPropertyModifierRule(ReadGraph graph, String relationURI, String propertyRelationURI) throws DatabaseException {
        this.relation = graph.getResource(relationURI);
        this.propertyRelation = graph.getResource(propertyRelationURI);
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Labeler.Modifier getModifier(ReadGraph graph, Object content, String columnKey) throws DatabaseException {
        StringModifier sm;
        if (!"single".equals(columnKey)) {
            return null;
        }
        if (!(content instanceof Resource)) {
            return null;
        }
        Resource resource_ = (Resource)content;
        Resource resource = graph.getSingleObject(resource_, this.relation);
        Statement nameStm = graph.getPossibleStatement(resource, this.propertyRelation);
        if (nameStm == null) {
            return null;
        }
        StringModifierFactory smf = (StringModifierFactory)graph.getPossibleAdapter(resource, StringModifierFactory.class);
        if (smf != null && (sm = smf.createModifier(graph, this.propertyRelation, nameStm.getObject())) != null) {
            return this.modifierFor(graph.getSession(), sm, nameStm.getObject());
        }
        return new L0StringModifier((RequestProcessor)graph.getSession(), resource, this.propertyRelation, nameStm.getObject());
    }

    private Labeler.Modifier modifierFor(final Session session, final StringModifier sm, final Resource valueResource) {
        return new Labeler.Modifier(){

            public String getValue() {
                try {
                    return (String)session.syncRequest((AsyncRead)new PossibleAdapter(valueResource, String.class));
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                    return null;
                }
            }

            public String isValid(String label) {
                return sm.isValid((Object)label);
            }

            public void modify(final String label) {
                try {
                    session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            sm.modify(graph, (Object)label);
                        }
                    });
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        };
    }
}

