/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.javacore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.acorn.exception.InvalidHeadStateException;

@Deprecated
public class HeadState
implements Serializable {
    private static final long serialVersionUID = -4135031566499790077L;
    public int headChangeSetId = 0;
    public long transactionId = 1L;
    public long reservedIds = 3L;
    public ArrayList<String> clusters = new ArrayList();
    public ArrayList<String> files = new ArrayList();
    public ArrayList<String> stream = new ArrayList();
    public ArrayList<String> cs = new ArrayList();

    public static HeadState load(Path directory) throws InvalidHeadStateException {
        Path f = directory.resolve("head.state");
        try {
            byte[] bytes = Files.readAllBytes(f);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                throw new InvalidHeadStateException("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + f.toAbsolutePath());
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes, digestLength, bytes.length - digestLength));){
                HeadState state = (HeadState)ois.readObject();
                return state;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return new HeadState();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new HeadState();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 Algorithm not found", e);
        }
    }

    public static void validateHeadStateIntegrity(Path headState) throws InvalidHeadStateException, IOException {
        try {
            byte[] bytes = Files.readAllBytes(headState);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                throw new InvalidHeadStateException("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + headState.toAbsolutePath());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 digest not found, should not happen", e);
        }
    }
}

