/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import gnu.trove.list.array.TByteArrayList;
import java.nio.file.Path;
import org.simantics.acorn.FileCache;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.LRU;
import org.simantics.acorn.lru.LRUObject;
import org.simantics.db.Database;
import org.simantics.utils.datastructures.Pair;

public class FileInfo
extends LRUObject<String, FileInfo> {
    private TByteArrayList bytes;

    public FileInfo(LRU<String, FileInfo> LRU2, FileCache fileCache, Path readDir, String id, int offset, int length) throws AcornAccessVerificationException {
        super(LRU2, fileCache, id, readDir, String.valueOf(id.toString()) + ".extFile", offset, length, false, false);
        LRU2.map(this);
    }

    public FileInfo(LRU<String, FileInfo> LRU2, FileCache fileCache, String id, int size) throws AcornAccessVerificationException {
        super(LRU2, fileCache, id, LRU2.getDirectory(), String.valueOf(id.toString()) + ".extFile", true, true);
        this.bytes = new TByteArrayList(size);
        LRU2.insert(this, this.accessTime);
    }

    public byte[] getResourceFile() throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        return this.bytes.toArray();
    }

    public Database.Session.ResourceSegment getResourceSegment(final byte[] clusterUID, final int resourceIndex, final long segmentOffset, short segmentSize) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        try {
            int segSize = segmentSize;
            if (segSize < 0) {
                segSize += 65536;
            }
            if (segmentSize == -1) {
                segSize = Math.min(65535, this.bytes.size());
            }
            final long valueSize = this.bytes.size();
            final byte[] segment = this.bytes.toArray((int)segmentOffset, segSize);
            return new Database.Session.ResourceSegment(){

                public long getValueSize() {
                    return valueSize;
                }

                public byte[] getSegment() {
                    return segment;
                }

                public int getResourceIndex() {
                    return resourceIndex;
                }

                public long getOffset() {
                    return segmentOffset;
                }

                public byte[] getClusterId() {
                    return clusterUID;
                }
            };
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
    }

    public void updateData(byte[] newBytes, long offset, long pos, long size) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        if (size == 0L) {
            this.bytes.remove((int)offset, (int)((long)this.bytes.size() - offset));
        } else {
            this.bytes.fill((int)(offset + size), (int)(offset + size), (byte)0);
            this.bytes.set((int)offset, newBytes, (int)pos, (int)size);
        }
        this.setDirty();
    }

    @Override
    public Pair<byte[], Integer> toBytes() {
        byte[] result = this.bytes.toArray();
        this.release();
        return Pair.make((Object)result, (Object)result.length);
    }

    @Override
    protected void release() {
        this.bytes = null;
    }

    @Override
    public void fromFile(byte[] data) {
        this.bytes = new TByteArrayList(data);
    }

    @Override
    protected String getExtension() {
        return "extFile";
    }

    @Override
    protected boolean overwrite() {
        return true;
    }
}

