/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterUpdateProcessor;
import org.simantics.acorn.internal.ClusterUpdateProcessor2;
import org.simantics.acorn.lru.ClusterChangeSet;
import org.simantics.acorn.lru.ClusterInfo;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;

public final class ClusterUpdateOperation {
    public final ClusterUID uid;
    protected final ClusterManager manager;
    protected final ClusterInfo info;
    public byte[] data;
    public ClusterStreamChunk chunk;
    public ClusterChangeSet ccs;
    boolean finished = false;

    public ClusterUpdateOperation(ClusterManager manager, byte[] data) throws IllegalAcornStateException, AcornAccessVerificationException {
        long cuid1 = Bytes.readLE8((byte[])data, (int)8);
        long cuid2 = Bytes.readLE8((byte[])data, (int)16);
        this.manager = manager;
        this.uid = ClusterUID.make((long)cuid1, (long)cuid2);
        this.data = data;
        this.info = manager.clusterLRU.getOrCreate(this.uid, true);
    }

    public void finish() {
        this.finished = true;
    }

    public void scheduled(String ccsInfoId) throws AcornAccessVerificationException, IllegalAcornStateException {
        this.ccs = new ClusterChangeSet(ccsInfoId, this.uid);
        this.chunk = this.ccs.getChunk(this.manager);
        this.manager.addIntoCurrentChangeSet(ccsInfoId);
    }

    public void run() throws AcornAccessVerificationException, IllegalAcornStateException {
        ClusterUpdateOperation op = null;
        byte[] data = null;
        this.chunk.acquireMutex();
        try {
            this.chunk.makeResident();
            op = this.chunk.operations.get(this.ccs.chunkOffset);
            data = op.data;
        }
        finally {
            this.chunk.releaseMutex();
        }
        op.runWithData(data);
    }

    public void runWithData(byte[] data) throws IllegalAcornStateException, AcornAccessVerificationException {
        block5: {
            try {
                int version = Bytes.readLE4((byte[])data, (int)4);
                if (version == 1) {
                    ClusterUpdateProcessor processor = new ClusterUpdateProcessor(this.manager, this.manager.support, data, this);
                    ClusterImpl cluster = this.info.getForUpdate();
                    cluster = processor.process(cluster);
                    this.manager.update(this.uid, cluster);
                    break block5;
                }
                if (version == 2) {
                    ClusterUpdateProcessor2 processor = new ClusterUpdateProcessor2(this.manager.support, data, this);
                    ClusterImpl cluster = this.info.getForUpdate();
                    processor.process(cluster);
                    this.manager.update(this.uid, cluster);
                    break block5;
                }
                throw new IllegalAcornStateException("unsupported clusterChange version " + version);
            }
            catch (AcornAccessVerificationException | IllegalAcornStateException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterUpdateOperation [uid=").append(this.uid).append("] [info=").append(this.info).append("] [ccs=").append(this.ccs).append("] [chunk=").append("]");
        return sb.toString();
    }
}

