/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.LifeCycleContext;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class LifeCycleProcesses
extends AbstractProjectFeature {
    Set<LifeCycleContext> contexts = new HashSet<LifeCycleContext>();

    public void configure() throws ProjectException {
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    for (Resource indexRoot : Layer0Utils.listIndexRoots((ReadGraph)graph)) {
                        for (Resource lcp : ModelingUtils.searchByTypeShallow(graph, indexRoot, MOD.LifeCycleProcess)) {
                            Variable unloadProperty;
                            Function1 load = null;
                            Function1 unload = null;
                            Variable loadProperty = Variables.tryGetProperty((ReadGraph)graph, (Resource)lcp, (Resource)MOD.LifeCycleProcess_load);
                            if (loadProperty != null) {
                                load = (Function1)loadProperty.getPossibleValue(graph);
                            }
                            if ((unloadProperty = Variables.tryGetProperty((ReadGraph)graph, (Resource)lcp, (Resource)MOD.LifeCycleProcess_unload)) != null) {
                                unload = (Function1)unloadProperty.getPossibleValue(graph);
                            }
                            LifeCycleContext lcc = new LifeCycleContext(lcp, (Function1<LifeCycleContext, Tuple0>)load, (Function1<LifeCycleContext, Tuple0>)unload);
                            LifeCycleProcesses.this.contexts.add(lcc);
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
        for (LifeCycleContext context : this.contexts) {
            context.load();
        }
    }

    public void deconfigure() throws ProjectException {
        for (LifeCycleContext context : this.contexts) {
            context.unload();
        }
    }
}

