/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.function;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.function.FlagTableColumnInfo;
import org.simantics.modeling.template2d.ui.function.FlagTableInfo;
import org.simantics.modeling.template2d.ui.function.MonitorInfo;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class DrawingTemplateInfo
extends ResourceRead<TreeMap<String, FlagTableInfo>> {
    public static final Integer ALIGN_LEFT = 0;
    public static final Integer ALIGN_RIGHT = 1;
    public static final float BASELINE_VERTICAL_OFFSET = 0.8f;

    public DrawingTemplateInfo(Resource template) {
        super(template);
    }

    public TreeMap<String, FlagTableInfo> perform(ReadGraph g) throws DatabaseException {
        TreeMap<String, FlagTableInfo> entries = new TreeMap<String, FlagTableInfo>();
        try {
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
            ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)g);
            Collection slotTables = g.getObjects(this.resource, L0.ConsistsOf);
            for (Resource slotTable : slotTables) {
                if (!g.isInstanceOf(slotTable, TEMPLATE2D.FlagTable)) continue;
                String name = (String)g.getPossibleRelatedValue(slotTable, L0.HasName, (Binding)Bindings.STRING);
                double[] transform = (double[])g.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
                Resource align = g.getPossibleObject(slotTable, TEMPLATE2D.FlagTable_HasAlignment);
                Float width = (Float)g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, (Binding)Bindings.FLOAT);
                Float rowHeight = (Float)g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, (Binding)Bindings.FLOAT);
                Integer rowCount = (Integer)g.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowCount, (Binding)Bindings.INTEGER);
                if (name == null || width == null || rowCount == null) continue;
                FlagTableInfo table = new FlagTableInfo();
                table.setWidth(width);
                table.setRowCount(rowCount);
                table.setRowHeight(rowHeight);
                table.setTransform(transform);
                AffineTransform affineTransform = table.affineTransform = transform != null ? new AffineTransform(transform) : new AffineTransform();
                if (align != null) {
                    if (align.equals(TEMPLATE2D.FlagTable_Alignment_Left)) {
                        table.setAlignment(ALIGN_LEFT);
                    }
                    if (align.equals(TEMPLATE2D.FlagTable_Alignment_Right)) {
                        table.setAlignment(ALIGN_RIGHT);
                    }
                }
                entries.put(name, table);
                Resource res = g.getPossibleObject(slotTable, SG.Node_children);
                if (res == null || !g.isInstanceOf(res, L0.List)) continue;
                List columns = ListUtils.toList((ReadGraph)g, (Resource)res);
                Float weightTotal = Float.valueOf(0.0f);
                for (Resource column : columns) {
                    Float weight;
                    if (!g.isInstanceOf(column, TEMPLATE2D.FlagTable_Column) && !g.isInstanceOf(column, TEMPLATE2D.FlagTable_RowNumberColumn) || (weight = (Float)g.getPossibleRelatedValue(column, TEMPLATE2D.FlagTable_Column_HasWeight, (Binding)Bindings.FLOAT)) == null) continue;
                    FlagTableColumnInfo col = new FlagTableColumnInfo(weight);
                    table.addColumn(col);
                    if (g.isInstanceOf(column, TEMPLATE2D.FlagTable_RowNumberColumn)) {
                        col.setType(FlagTableColumnInfo.TYPE_ROW_NUMBERING);
                        Integer start = (Integer)g.getPossibleRelatedValue(column, TEMPLATE2D.FlagTable_RowNumberColumn_start, (Binding)Bindings.INTEGER);
                        col.setStartOffset(start);
                    }
                    weightTotal = Float.valueOf(weightTotal.floatValue() + weight.floatValue());
                    Resource res2 = g.getPossibleObject(column, SG.Node_children);
                    if (res2 == null || !g.isInstanceOf(res2, L0.List)) continue;
                    List columnDatas = ListUtils.toList((ReadGraph)g, (Resource)res2);
                    for (Resource columnData : columnDatas) {
                        double[] dataTransform;
                        String path;
                        RGB.Integer color;
                        Font font;
                        MonitorInfo monitorInfo;
                        if (g.isInstanceOf(columnData, TEMPLATE2D.FlagTable_Column_Data)) {
                            monitorInfo = new MonitorInfo();
                            font = (Font)g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_font, Bindings.getBindingUnchecked(Font.class));
                            if (font != null) {
                                monitorInfo.setFont(font);
                            }
                            if ((color = (RGB.Integer)g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_color, RGB.Integer.BINDING)) != null) {
                                monitorInfo.setColor(color);
                            }
                            if ((path = (String)g.getRelatedValue(columnData, DIA.Scenegraph_Monitor_reference, (Binding)Bindings.STRING)) != null && path.length() > 0) {
                                monitorInfo.setText(path);
                            }
                            if ((dataTransform = (double[])g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_transform, Bindings.getBindingUnchecked(double[].class))) != null) {
                                monitorInfo.setTransform(dataTransform);
                            }
                            monitorInfo.setResource(columnData);
                            col.addColumnData(monitorInfo);
                        }
                        if (!g.isInstanceOf(columnData, TEMPLATE2D.FlagTable_Column_Header)) continue;
                        monitorInfo = new MonitorInfo();
                        font = (Font)g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_font, Bindings.getBindingUnchecked(Font.class));
                        if (font != null) {
                            monitorInfo.setFont(font);
                        }
                        if ((color = (RGB.Integer)g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_color, RGB.Integer.BINDING)) != null) {
                            monitorInfo.setColor(color);
                        }
                        if ((path = (String)g.getRelatedValue(columnData, DIA.Scenegraph_Monitor_reference, (Binding)Bindings.STRING)) != null && path.length() > 0) {
                            monitorInfo.setText(path);
                        }
                        if ((dataTransform = (double[])g.getPossibleRelatedValue2(columnData, DIA.Scenegraph_AbstractText_transform, Bindings.getBindingUnchecked(double[].class))) != null) {
                            monitorInfo.setTransform(dataTransform);
                        }
                        monitorInfo.setResource(columnData);
                        col.addColumnHeader(monitorInfo);
                    }
                }
                table.setWeightTotal(weightTotal);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return entries;
    }
}

