/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.osgi.framework.Bundle;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.graph.compiler.GraphCompiler;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.ValidationMode;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.ltk.FileSource;
import org.simantics.ltk.Problem;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.scl.reflection.OntologyVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformUtil.class);

    public static Bundle[] getBundles() {
        return PlatformActivator.getContext().getBundles();
    }

    public static Manifest getManifest(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("META-INF/MANIFEST.MF");
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
    }

    public static Manifest getSimanticsManifest(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("META-INF/SIMANTICS.MF");
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
    }

    public static void getUserInstallableUnits(Collection<String> list) throws IOException {
        Bundle[] bundleArray = PlatformUtil.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Manifest manifest = PlatformUtil.getSimanticsManifest(bundle);
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
                    Object key = entry2.getKey();
                    if (!key.toString().contains("Installable-Unit")) continue;
                    String bid = entry2.getValue().toString();
                    list.add(bid);
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void getPlatformTGInfos(Collection<TGInfo> result) {
        var4_1 = PlatformUtil.getBundles();
        var3_2 = var4_1.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            block2: {
                bundle = var4_1[var2_3];
                e = bundle.findEntries("graphs/", "*.tg", false);
                if (e != null) ** GOTO lbl18
                break block2;
lbl-1000:
                // 1 sources

                {
                    osgiVersion = bundle.getVersion();
                    p2Version = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)osgiVersion.getQualifier());
                    id = bundle.getSymbolicName();
                    info = new TGInfo();
                    info.location = (URL)e.nextElement();
                    info.bundle = bundle;
                    info.vid = new VersionedId(id, p2Version);
                    result.add(info);
lbl18:
                    // 2 sources

                    ** while (e.hasMoreElements())
                }
            }
            ++var2_3;
        }
    }

    private static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static File copyResource(URL url, File targetFile) throws IOException, FileNotFoundException {
        File file;
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int read;
            if (targetFile.exists()) {
                targetFile.delete();
            }
            is = url.openStream();
            byte[] buffer = new byte[16384];
            os = new FileOutputStream(targetFile);
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.close();
            is.close();
            file = targetFile;
        }
        catch (Throwable throwable) {
            PlatformUtil.uncheckedClose(os);
            PlatformUtil.uncheckedClose(is);
            throw throwable;
        }
        PlatformUtil.uncheckedClose(os);
        PlatformUtil.uncheckedClose(is);
        return file;
    }

    private static File extractLib(URL libURL, String libName) throws FileNotFoundException, IOException {
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            throw new NullPointerException("java.io.tmpdir property is null");
        }
        File tmpDir = new File(tmpDirStr);
        File libFile = new File(tmpDir, libName);
        return PlatformUtil.copyResource(libURL, libFile);
    }

    private static File url2file(URL url, String fileName) {
        if ("file".equals(url.getProtocol())) {
            try {
                File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                return path;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Failed to decode " + url, (Throwable)e);
            }
        } else if ("jar".equals(url.getProtocol())) {
            try {
                File libFile = PlatformUtil.extractLib(url, fileName);
                return libFile;
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Extraction to " + fileName + " failed, url not found: " + url, (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Extraction to " + fileName + " failed from url " + url, (Throwable)e);
            }
        } else {
            System.err.println("Unsupported URL protocol '" + url + "' for FastLZ native library file '" + fileName);
        }
        return null;
    }

    public static void compile(Bundle b) throws Exception {
        Object graphFile;
        ArrayList<FileSource> sources = new ArrayList<FileSource>();
        ArrayList<TransferableGraph1> dependencies = new ArrayList<TransferableGraph1>();
        Bundle[] bundleArray = PlatformUtil.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url;
            Bundle b2 = bundleArray[n2];
            if (!b.equals(b2) && (url = b2.getEntry("graph.tg")) != null) {
                graphFile = PlatformUtil.url2file(FileLocator.resolve((URL)b2.getEntry("/graph.tg")), b2.toString());
                dependencies.add(GraphCompiler.read((File)graphFile));
            }
            ++n2;
        }
        File bundleFile = FileLocator.getBundleFile((Bundle)b);
        if (bundleFile.isDirectory()) {
            File folder = new File(bundleFile, "dynamicGraph");
            graphFile = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".pgraph");
                }
            });
            int url = ((File[])graphFile).length;
            int n3 = 0;
            while (n3 < url) {
                File f = graphFile[n3];
                sources.add(new FileSource(f));
                ++n3;
            }
        }
        StringBuilder errorStringBuilder = new StringBuilder();
        GraphCompilerPreferences prefs = new GraphCompilerPreferences();
        prefs.validate = true;
        prefs.validateRelationRestrictions = ValidationMode.ERROR;
        prefs.validateResourceHasType = ValidationMode.ERROR;
        String currentLayer0Version = OntologyVersions.getInstance().currentOntologyVersion("http://www.simantics.org/Layer0-0.0");
        CompilationResult result = GraphCompiler.compile((String)currentLayer0Version, sources, dependencies, null, (GraphCompilerPreferences)prefs);
        for (Problem problem : result.getErrors()) {
            errorStringBuilder.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
        }
        for (Problem problem : result.getWarnings()) {
            errorStringBuilder.append(problem.getLocation() + ": " + problem.getDescription() + "\n");
        }
        if (errorStringBuilder.length() > 0) {
            LOGGER.error(errorStringBuilder.toString());
        } else {
            DataContainers.writeFile((File)new File(bundleFile, "graph.tg"), (DataContainer)new DataContainer("graph", 1, new Variant(TransferableGraph1.BINDING, (Object)result.getGraph())));
        }
    }

    public static void compileAllDynamicOntologies() {
        Bundle[] bundleArray = PlatformUtil.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Bundle bundle = bundleArray[n2];
                if (bundle.getEntry("dynamicGraph") != null) {
                    try {
                        File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                        if (!bundleFile.isDirectory()) break block6;
                        File tg = new File(bundleFile, "graph.tg");
                        long tgLastModified = tg.lastModified();
                        File folder = new File(bundleFile, "dynamicGraph");
                        File[] fileArray = folder.listFiles();
                        int n3 = fileArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File f = fileArray[n4];
                            if (f.isFile() && f.getName().endsWith(".pgraph") && f.lastModified() > tgLastModified) {
                                PlatformUtil.compile(bundle);
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to compile dynamic ontologies in bundle " + bundle.getSymbolicName(), e);
                    }
                }
            }
            ++n2;
        }
    }

    public static void getAllGraphs(Collection<GraphBundle> collection) throws IOException {
        Bundle[] bundleArray = PlatformUtil.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            GraphBundleEx entry = PlatformUtil.getGraph(bundle);
            if (entry != null) {
                collection.add(entry);
            }
            ++n2;
        }
    }

    public static GraphBundle getGraph(String symbolicName) throws IOException {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle == null) {
            return null;
        }
        return PlatformUtil.getGraph(bundle);
    }

    public static GraphBundleEx getGraph(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("graph.tg");
        if (url == null) {
            return null;
        }
        InputStream is = url.openStream();
        is = new BufferedInputStream(is, 131072);
        try {
            GraphBundleEx entry;
            String immutable;
            DataInputStream dis = new DataInputStream(is);
            DataContainer container = DataContainers.readFile((DataInput)dis);
            Binding binding = TransferableGraph1.BINDING;
            TransferableGraph1 graph = (TransferableGraph1)container.content.getValue(binding);
            org.osgi.framework.Version osgiVersion = bundle.getVersion();
            Version p2Version = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)osgiVersion.getQualifier());
            String id = bundle.getSymbolicName();
            VersionedId vid = new VersionedId(id, p2Version);
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            if (name == null) {
                name = id;
            }
            boolean isImmutable = (immutable = (String)bundle.getHeaders().get("Immutable")) != null ? "true".equals(immutable) : true;
            GraphBundleEx graphBundleEx = entry = new GraphBundleEx(name, graph, (IVersionedId)vid, isImmutable);
            return graphBundleEx;
        }
        catch (Exception e) {
            throw new IOException("Problem loading graph.tg from bundle " + bundle.getSymbolicName(), e);
        }
        catch (Error e) {
            LOGGER.error("Serious problem loading graph.tg from bundle " + bundle.getSymbolicName(), (Throwable)e);
            throw e;
        }
        finally {
            is.close();
        }
    }

    public static class TGInfo {
        public Bundle bundle;
        public URL location;
        public IVersionedId vid;
    }
}

