/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.server.environment;

import org.simantics.db.procore.server.environment.ARCHType;
import org.simantics.db.procore.server.environment.OSType;

public final class ExecutionEnvironment {
    public final OSType os;
    public final ARCHType arch;

    private ExecutionEnvironment(OSType os, ARCHType arch) {
        this.os = os;
        this.arch = arch;
    }

    public static ExecutionEnvironment calculate() {
        return new ExecutionEnvironment(ExecutionEnvironment.calculateOS(), ExecutionEnvironment.calculateArch());
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch", "");
        if ((osArch = osArch.toLowerCase()).equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        return ARCHType.UNKNOWN;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name", "");
        if ((osName = osName.toLowerCase()).startsWith("mac os x")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }
}

