/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.Disposable;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.Objects;
import org.simantics.db.common.procedure.adapter.DisposableSyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.procedure.single.SingleSetSyncListener;
import org.simantics.db.common.request.ResourceRead3;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.Severity;
import org.simantics.issues.common.ActiveProjectIssueSources;
import org.simantics.issues.common.DependencyIssueSynchronizer2;
import org.simantics.issues.common.DependencyIssueValidator2;
import org.simantics.issues.common.IssueSource;
import org.simantics.issues.common.SimpleIssue;
import org.simantics.issues.common.StandardIssueDescription;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueUtils.class);

    public static Resource toSeverityResource(IssueResource ISSUE, Severity severity) {
        switch (severity) {
            case ERROR: {
                return ISSUE.Severity_Error;
            }
            case FATAL: {
                return ISSUE.Severity_Fatal;
            }
            case INFO: {
                return ISSUE.Severity_Info;
            }
            case WARNING: {
                return ISSUE.Severity_Warning;
            }
            case NOTE: {
                return ISSUE.Severity_Note;
            }
        }
        return null;
    }

    public static Severity toSeverity(IssueResource ISSUE, Resource severity) {
        if (severity == null) {
            return null;
        }
        if (severity.equals(ISSUE.Severity_Fatal)) {
            return Severity.FATAL;
        }
        if (severity.equals(ISSUE.Severity_Error)) {
            return Severity.ERROR;
        }
        if (severity.equals(ISSUE.Severity_Info)) {
            return Severity.INFO;
        }
        if (severity.equals(ISSUE.Severity_Warning)) {
            return Severity.WARNING;
        }
        if (severity.equals(ISSUE.Severity_Note)) {
            return Severity.NOTE;
        }
        return null;
    }

    public static Disposable listenActiveProjectIssueSources(RequestProcessor processor, Resource project) throws DatabaseException {
        final AtomicBoolean disposed = new AtomicBoolean(false);
        processor.syncRequest((Read)new ActiveProjectIssueSources(project, IssueResource.getInstance((RequestProcessor)processor).ContinuousIssueSource), (AsyncProcedure)new ActiveIssueSourceListener(disposed));
        return new Disposable(){

            public void dispose() {
                disposed.set(true);
            }
        };
    }

    public static List<Resource> getContextsForProperty(ReadGraph graph, Variable property) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Variable issueVariable = property.getParent(graph);
        Resource issueResource = issueVariable.getRepresents(graph);
        Resource list = graph.getPossibleObject(issueResource, ISSUE.Issue_HasContexts);
        if (list != null) {
            return ListUtils.toList((ReadGraph)graph, (Resource)list);
        }
        return Collections.emptyList();
    }

    public static void writeAdditionalContext(WriteGraph graph, Resource issue, List<Resource> contexts) throws DatabaseException {
        if (contexts.isEmpty()) {
            return;
        }
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        graph.claim(issue, IR.Issue_HasContext, contexts.get(0));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(contexts.get(0), L0.PartOf);
        if (parent != null) {
            graph.claim(issue, IR.Issue_HasContext, parent);
        }
    }

    public static void newUserIssue(WriteGraph graph, String label, Resource severity, List<Resource> contexts) throws DatabaseException {
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(contexts.get(0)));
        if (model == null) {
            throw new DatabaseException("No model for main context");
        }
        IssueUtils.newUserIssueForModel(graph, model, label, severity, contexts);
    }

    public static Resource newUserIssueForModel(WriteGraph graph) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        Collection activeModels = (Collection)graph.syncRequest((Read)new ActiveModels(project));
        if (activeModels.size() != 1) {
            return null;
        }
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource issue = null;
        for (Resource model : activeModels) {
            issue = IssueUtils.newUserIssueForModel(graph, model, "New User Issue", ISSUE.Severity_Note, Collections.emptyList());
        }
        return issue;
    }

    public static Resource newUserIssueForModel(WriteGraph graph, Resource model, String label, Resource severity, List<Resource> contexts) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        return IssueUtils.newUserIssueForModel(graph, model, ISSUE.Issue, label, severity, contexts);
    }

    public static Resource newUserIssueForModel(WriteGraph graph, Resource model, Resource type, String label, Resource severity, List<Resource> contexts) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource issue = graph.newResource();
        graph.claim(issue, ISSUE.UserIssue, ISSUE.UserIssue, issue);
        graph.claim(issue, L0.InstanceOf, null, type);
        graph.claim(issue, ISSUE.Issue_HasSeverity, null, severity);
        graph.claim(issue, ISSUE.Issue_HasContexts, ListUtils.create((WriteGraph)graph, (Resource)L0.List, contexts));
        IssueUtils.writeAdditionalContext(graph, issue, contexts);
        graph.claimLiteral(issue, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(issue, L0.HasLabel, (Object)label, (Binding)Bindings.STRING);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String time = format.format(new Date());
        graph.claimLiteral(issue, ISSUE.Issue_creationTime, (Object)time, (Binding)Bindings.STRING);
        graph.claim(model, L0.ConsistsOf, L0.PartOf, issue);
        return issue;
    }

    public static void newSimpleIssueForModel(WriteGraph graph, Resource model, Resource issueType, List<Resource> contexts, SimpleIssue simpleIssue) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource issue = graph.newResource();
        graph.claim(issue, L0.InstanceOf, null, issueType);
        graph.claim(issue, ISSUE.Issue_HasSeverity, null, IssueUtils.toSeverityResource(ISSUE, simpleIssue.severity));
        graph.claim(issue, ISSUE.Issue_HasContexts, ListUtils.create((WriteGraph)graph, (Resource)L0.List, contexts));
        IssueUtils.writeAdditionalContext(graph, issue, contexts);
        graph.claimLiteral(issue, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(issue, L0.HasLabel, (Object)simpleIssue.label, (Binding)Bindings.STRING);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String time = format.format(new Date());
        graph.claimLiteral(issue, ISSUE.Issue_creationTime, (Object)time, (Binding)Bindings.STRING);
        graph.claim(model, L0.ConsistsOf, L0.PartOf, issue);
    }

    public static Set<SimpleIssue> getSimpleIssues(ReadGraph graph, List<Resource> contexts, Resource issueType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        THashSet currentIssues = null;
        for (Resource issue : graph.getObjects(contexts.get(0), ISSUE.Issue_HasContext_Inverse)) {
            List curContexts;
            if (!graph.isInstanceOf(issue, issueType) || !contexts.equals(curContexts = ListUtils.toList((ReadGraph)graph, (Resource)graph.getSingleObject(issue, ISSUE.Issue_HasContexts)))) continue;
            if (currentIssues == null) {
                currentIssues = new THashSet();
            }
            currentIssues.add((Object)new SimpleIssue((String)graph.getRelatedValue(issue, L0.HasLabel), IssueUtils.toSeverity(ISSUE, graph.getSingleObject(issue, ISSUE.Issue_HasSeverity)), issue));
        }
        if (currentIssues == null) {
            return Collections.emptySet();
        }
        return currentIssues;
    }

    public static void setSimpleIssues(WriteGraph graph, Resource model, List<Resource> contexts, Resource issueType, SimpleIssue ... issues) throws DatabaseException {
        Set<SimpleIssue> currentIssues = IssueUtils.getSimpleIssues((ReadGraph)graph, contexts, issueType);
        SimpleIssue[] simpleIssueArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleIssue newIssue = simpleIssueArray[n2];
            if (currentIssues.contains(newIssue)) {
                currentIssues.remove(newIssue);
            } else {
                IssueUtils.newSimpleIssueForModel(graph, model, issueType, contexts, newIssue);
            }
            ++n2;
        }
        for (SimpleIssue oldIssue : currentIssues) {
            RemoverUtil.remove((WriteGraph)graph, (Resource)oldIssue.issueResource);
        }
    }

    public static void setSimpleIssues(WriteGraph graph, List<Resource> contexts, Resource issueType, SimpleIssue ... issues) throws DatabaseException {
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(contexts.get(0)));
        if (model == null) {
            throw new DatabaseException("No model for main context");
        }
        IssueUtils.setSimpleIssues(graph, model, contexts, issueType, issues);
    }

    public static void setSimpleIssuesAsync(ReadGraph graph, List<Resource> contexts, Resource issueType, SimpleIssue ... issues) throws DatabaseException {
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(contexts.get(0)));
        if (model == null) {
            throw new DatabaseException("No model for main context");
        }
        IssueUtils.setSimpleIssuesAsync(graph, model, contexts, issueType, issues);
    }

    public static void setSimpleIssuesAsync(ReadGraph graph, final Resource model, final List<Resource> contexts, final Resource issueType, final SimpleIssue ... issues) throws DatabaseException {
        Set<SimpleIssue> oldIssues = IssueUtils.getSimpleIssues(graph, contexts, issueType);
        boolean needsUpdating = false;
        if (issues.length != oldIssues.size()) {
            needsUpdating = true;
        } else {
            SimpleIssue[] simpleIssueArray = issues;
            int n = issues.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleIssue newIssue = simpleIssueArray[n2];
                if (!oldIssues.contains(newIssue)) {
                    needsUpdating = true;
                    break;
                }
                ++n2;
            }
        }
        if (needsUpdating) {
            VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = support.getWorkspacePersistent("issues");
            Simantics.getSession().asyncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    IssueUtils.setSimpleIssues(graph, model, contexts, issueType, issues);
                }
            });
        }
    }

    public static Resource addIssueSource(WriteGraph g, Resource model, Resource sourceType, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        Resource source = g.newResource();
        g.claim(source, L0.InstanceOf, null, sourceType);
        g.addLiteral(source, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.claim(source, L0X.IsActivatedBy, L0X.Activates, model);
        g.claim(source, L0.PartOf, L0.ConsistsOf, model);
        return source;
    }

    public static String pathString(String uri, int startIndex) {
        StringBuilder sb = new StringBuilder(uri.length() - startIndex + 1);
        sb.append('/');
        while (true) {
            int nextSlash;
            if ((nextSlash = uri.indexOf(47, startIndex)) == -1) break;
            sb.append(URIStringUtils.unescape((String)uri.substring(startIndex, nextSlash))).append('/');
            startIndex = nextSlash + 1;
        }
        sb.append(URIStringUtils.unescape((String)uri.substring(startIndex, uri.length())));
        return sb.toString();
    }

    private static class ActiveIssueSourceListener
    extends SingleSetSyncListener<Resource> {
        private final AtomicBoolean disposed;
        private Map<Resource, Pair<IssueSource, IssueSourceDirtyListener>> sources = new HashMap<Resource, Pair<IssueSource, IssueSourceDirtyListener>>();

        public ActiveIssueSourceListener(AtomicBoolean disposed) {
            this.disposed = disposed;
        }

        public void add(ReadGraph graph, Resource source) throws DatabaseException {
            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
            boolean isListeningTracker = graph.isInstanceOf(source, ISSUE.Sources_ListeningDependencyTracker);
            IssueSource is = (IssueSource)graph.adapt(source, IssueSource.class);
            Resource model = isListeningTracker ? (Resource)graph.syncRequest((Read)new Model(source)) : null;
            IssueSourceDirtyListener listener = new IssueSourceDirtyListener(is);
            is.addDirtyListener((Function2<ReadGraph, List<Resource>, Boolean>)listener);
            this.sources.put(source, (Pair<IssueSource, IssueSourceDirtyListener>)Pair.make((Object)is, (Object)((Object)listener)));
            if (isListeningTracker) {
                graph.asyncRequest((Read)new Objects(source, ISSUE.IssueSource_Manages), (AsyncListener)new IssueSourceManagedIssuesListener(this.disposed, source, model));
            }
        }

        public void remove(ReadGraph graph, Resource source) throws DatabaseException {
            Pair<IssueSource, IssueSourceDirtyListener> is = this.sources.remove(source);
            if (is != null) {
                ((IssueSource)is.first).removeDirtyListener((Function2<ReadGraph, List<Resource>, Boolean>)((Function2)is.second));
            }
        }

        public void exception(ReadGraph graph, Throwable t) {
            LOGGER.error("ActiveIssueSourceListener received an exception.", t);
        }

        public boolean isDisposed() {
            return this.disposed.get();
        }
    }

    private static class IssueSourceDirtyListener
    extends FunctionImpl2<ReadGraph, List<Resource>, Boolean> {
        private final IssueSource is;

        public IssueSourceDirtyListener(IssueSource is) {
            this.is = is;
        }

        public Boolean apply(ReadGraph graph, final List<Resource> resources) {
            VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = support.getWorkspacePersistent("issues");
            if (graph instanceof WriteGraph) {
                try {
                    if (this.is.needUpdate(graph, resources)) {
                        graph.sync((WriteInterface)new WriteRequest(vg){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                is.update(graph, resources);
                            }
                        });
                    }
                }
                catch (DatabaseException e) {
                    LOGGER.error("Updating issue source failed.", (Throwable)e);
                }
            } else {
                Session session = Simantics.getSession();
                session.asyncRequest((Write)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        is.update(graph, resources);
                    }
                });
            }
            return true;
        }
    }

    private static class IssueSourceManagedIssuesListener
    extends SingleSetSyncListener<Resource> {
        private final HashMap<Resource, IssueValidityListener> listeners = new HashMap();
        private final AtomicBoolean disposed;
        private final Resource source;
        private final Resource model;

        public IssueSourceManagedIssuesListener(AtomicBoolean disposed, Resource source, Resource model) {
            this.disposed = disposed;
            this.source = source;
            this.model = model;
        }

        public void add(ReadGraph graph, Resource issue) throws DatabaseException {
            IssueValidityListener listener = new IssueValidityListener(issue);
            graph.asyncRequest((Read)new ResourceRead3<Boolean>(issue, this.model, this.source){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    Issue desc = (Issue)graph.sync((ReadInterface)new StandardIssueDescription(this.resource));
                    if (desc == null) {
                        return false;
                    }
                    Resource context = (Resource)desc.getMainContext();
                    return (Boolean)graph.syncRequest((Read)new DependencyIssueValidator2(context, this.resource2, this.resource3), (Listener)TransientCacheListener.instance());
                }
            }, (SyncListener)listener);
            this.listeners.put(issue, listener);
        }

        public void remove(ReadGraph graph, Resource issue) throws DatabaseException {
            IssueValidityListener listener = this.listeners.remove(issue);
            if (listener != null) {
                listener.dispose();
            }
        }

        public void exception(ReadGraph graph, Throwable t) {
            LOGGER.error("IssueSourceManagedIssuesListener received an exception.", t);
        }

        public boolean isDisposed() {
            boolean disp = this.disposed.get();
            if (disp && !this.listeners.isEmpty()) {
                for (IssueValidityListener listener : this.listeners.values()) {
                    listener.dispose();
                }
                this.listeners.clear();
            }
            return disp;
        }

        class IssueValidityListener
        extends DisposableSyncListener<Boolean> {
            private final Resource issue;

            public IssueValidityListener(Resource issue) {
                this.issue = issue;
            }

            public void execute(ReadGraph graph, Boolean valid) throws DatabaseException {
                if (!valid.booleanValue()) {
                    VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                    VirtualGraph vg = support.getWorkspacePersistent("issues");
                    graph.asyncRequest((Write)new WriteRequest(vg){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Issue desc = (Issue)graph.sync((ReadInterface)new StandardIssueDescription(IssueValidityListener.this.issue));
                            if (desc == null) {
                                return;
                            }
                            Resource context = (Resource)desc.getMainContext();
                            new DependencyIssueSynchronizer2(context, IssueSourceManagedIssuesListener.this.source).perform(graph);
                        }
                    });
                }
            }

            public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                LOGGER.error("IssueValidityListener received an exception.", throwable);
            }
        }
    }
}

