/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRuleset;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionTransformer;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ToplevelEffectDecorator
extends StandardExpressionTransformer {
    ErrorLog errorLog;
    Environment environment;
    private static final THashMap<TCon, Name> DECORATION_MAP = new THashMap();

    static {
        DECORATION_MAP.put((Object)Types.WRITE_GRAPH, (Object)Names.Simantics_DB_syncWrite);
        DECORATION_MAP.put((Object)Types.READ_GRAPH, (Object)Names.Simantics_DB_syncRead);
        DECORATION_MAP.put((Object)Types.con("R/R", "R"), (Object)Names.R_R_runR);
        DECORATION_MAP.put((Object)Types.RANDOM, (Object)Names.Random_runRandom);
    }

    public ToplevelEffectDecorator(ErrorLog errorLog, Environment environment) {
        this.errorLog = errorLog;
        this.environment = environment;
    }

    @Override
    public Expression transform(EEnforce expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(EWhen expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(ERuleset expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(ECHRRuleset expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(EFieldAccess expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(ESelect expression) {
        return this.decorateByEffect(expression, expression.getEffect());
    }

    @Override
    public Expression transform(EApply expression) {
        return this.decorateByEffect(super.transform(expression), expression.getLocalEffect());
    }

    @Override
    public Expression transform(ESimpleLambda expression) {
        return expression;
    }

    @Override
    public Expression transform(ELambda expression) {
        return expression;
    }

    @Override
    protected void transformCases(Case[] cases) {
        Case[] caseArray = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.value = case_.value.accept(this);
            ++n2;
        }
    }

    private Expression decorateByEffect(Expression expression, Type effect) {
        if (effect == Types.NO_EFFECTS) {
            return expression;
        }
        ArrayList<TCon> concreteEffects = new ArrayList<TCon>();
        effect.collectConcreteEffects(concreteEffects);
        for (TCon ce : concreteEffects) {
            Name transactionFunctionName = (Name)DECORATION_MAP.get((Object)ce);
            if (transactionFunctionName == null) continue;
            SCLValue transactionFunction = this.environment.getValue(transactionFunctionName);
            if (transactionFunction == null) {
                this.errorLog.log(expression.location, "Cannot locate " + transactionFunctionName);
                continue;
            }
            expression = ToplevelEffectDecorator.decorate(transactionFunction, ce, expression);
        }
        return expression;
    }

    private static Expression decorate(SCLValue transactionFunction, Type effect, Expression expression) {
        Variable var = new Variable("_");
        var.setType(effect == Types.RANDOM ? Types.PUNIT : Types.UNIT);
        Expression trans = new EApply(expression.getLocation(), Types.PROC, (Expression)(effect == Types.RANDOM ? new EConstant(transactionFunction, Types.PROC, expression.getType()) : new EConstant(transactionFunction, expression.getType())), new ESimpleLambda(9223372034707292160L, var, effect, expression));
        if (expression instanceof EApply) {
            EApply apply = (EApply)expression;
            trans = apply.toANormalForm(trans);
        }
        return trans;
    }
}

