/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.set.hash.THashSet;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.JavaStaticMethod;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.LocalEnvironment;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.internal.codegen.types.DummyJavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuildingException;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.ValueFromMethod;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.codegen.writer.ExternalConstant;
import org.simantics.scl.compiler.internal.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.internal.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLBlockParser;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.top.ExpressionParseMode;
import org.simantics.scl.compiler.top.LocalStorage;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.top.ToplevelEffectDecorator;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.ProcedureType;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class ExpressionEvaluator {
    public static final boolean TRACE_INTERPRETATION_VS_COMPILATION = false;
    private static final String COMPUTATION_METHOD_NAME = "main";
    private final RuntimeEnvironment runtimeEnvironment;
    private final String expressionText;
    private Expression expression;
    private Type expressionType;
    private Type expectedEffect;
    private boolean decorateExpression;
    private Type expectedType;
    private LocalEnvironment localEnvironment;
    private LocalStorage localStorage;
    private boolean interpretIfPossible = true;
    private ExpressionParseMode parseMode = ExpressionParseMode.EXPRESSION;
    private boolean validateOnly;

    public ExpressionEvaluator(RuntimeEnvironment runtimeEnvironment, String expressionText) {
        if (runtimeEnvironment == null) {
            throw new NullPointerException();
        }
        if (expressionText == null) {
            throw new NullPointerException();
        }
        this.runtimeEnvironment = runtimeEnvironment;
        this.expressionText = expressionText;
    }

    public ExpressionEvaluator(RuntimeEnvironment runtimeEnvironment, LocalStorage localStorage, Expression expression) {
        if (runtimeEnvironment == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        this.runtimeEnvironment = runtimeEnvironment;
        this.localStorage = localStorage;
        this.expressionText = null;
        this.expression = expression;
    }

    public ExpressionEvaluator expectedEffect(Type expectedEffect) {
        this.expectedEffect = expectedEffect;
        return this;
    }

    public ExpressionEvaluator decorateExpression(boolean decorateExpression) {
        this.decorateExpression = decorateExpression;
        return this;
    }

    public ExpressionEvaluator expectedType(Type expectedType) {
        this.expectedType = expectedType;
        return this;
    }

    public ExpressionEvaluator validateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    public ExpressionEvaluator localEnvironment(LocalEnvironment localEnvironment) {
        this.localEnvironment = localEnvironment;
        return this;
    }

    public ExpressionEvaluator interpretIfPossible(boolean interpretIfPossible) {
        this.interpretIfPossible = interpretIfPossible;
        return this;
    }

    public ExpressionEvaluator parseAsBlock(boolean parseAsBlock) {
        this.parseMode = parseAsBlock ? ExpressionParseMode.BLOCK : ExpressionParseMode.EXPRESSION;
        return this;
    }

    public ExpressionEvaluator parseModel(ExpressionParseMode parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    private void fillDefaults() {
        if (this.expectedEffect == null) {
            this.expectedEffect = Types.metaVar(Kinds.EFFECT);
        }
        if (this.expectedType == null) {
            this.expectedType = Types.metaVar(Kinds.STAR);
        }
    }

    public CompilationError[] validate() {
        try {
            this.validateOnly = true;
            this.eval();
            return CompilationError.EMPTY_ARRAY;
        }
        catch (SCLExpressionCompilationException e) {
            return e.getErrors();
        }
    }

    public Object eval() throws SCLExpressionCompilationException {
        JavaNamingPolicy namingPolicy;
        JavaTypeTranslator javaTypeTranslator;
        Environment environment;
        this.fillDefaults();
        CompilationContext compilationContext = new CompilationContext();
        ErrorLog errorLog = compilationContext.errorLog;
        compilationContext.environment = environment = this.runtimeEnvironment.getEnvironment();
        if (this.expressionText != null) {
            try {
                switch (this.parseMode) {
                    case BLOCK: {
                        SCLParserImpl parser = new SCLBlockParser(new StringReader(this.expressionText));
                        parser.parseCommands();
                        this.expression = ((SCLBlockParser)parser).block;
                        break;
                    }
                    case EXPRESSION: {
                        SCLParserImpl parser = new SCLParserImpl(new StringReader(this.expressionText));
                        this.expression = (Expression)parser.parseExp();
                        break;
                    }
                    case EQUATION_BLOCK: {
                        SCLParserImpl parser = new SCLParserImpl(new StringReader(this.expressionText));
                        SCLParserOptions parserOptions = new SCLParserOptions();
                        parserOptions.supportEq = true;
                        parser.setParserOptions(parserOptions);
                        this.expression = (Expression)parser.parseEquationBlock();
                    }
                }
            }
            catch (SCLSyntaxErrorException e) {
                errorLog.log(e.location, e.getMessage());
                throw new SCLExpressionCompilationException(errorLog.getErrors());
            }
            catch (Exception e) {
                errorLog.log(e);
                throw new SCLExpressionCompilationException(errorLog.getErrors());
            }
        }
        ArrayList<TMetaVar> lvTypes = new ArrayList<TMetaVar>();
        if (this.expression instanceof EBlock) {
            EBlock block = (EBlock)this.expression;
            if (this.localStorage != null && !(block.getLast() instanceof GuardStatement)) {
                THashSet tHashSet = new THashSet();
                ListIterator<Statement> listIterator = block.getStatements().listIterator();
                while (listIterator.hasNext()) {
                    String variableName;
                    Statement stat = listIterator.next();
                    if (!(stat instanceof LetStatement)) continue;
                    try {
                        variableName = ((LetStatement)stat).pattern.getPatternHead().name;
                    }
                    catch (NotPatternException notPatternException) {
                        continue;
                    }
                    tHashSet.add((Object)variableName);
                }
                for (Object variableName : tHashSet) {
                    TMetaVar type = Types.metaVar(Kinds.STAR);
                    lvTypes.add(type);
                    block.addStatement(new GuardStatement(new EApply((Expression)new EExternalConstant((Object)new StoreFunction(this.localStorage, (String)variableName, type), Types.functionE(type, (Type)Types.PROC, (Type)Types.UNIT)), (Expression)new EVar((String)variableName))));
                    if (!this.validateOnly) continue;
                    this.localStorage.store((String)variableName, null, type);
                }
            }
            if (!(block.getLast() instanceof GuardStatement)) {
                block.addStatement(new GuardStatement(new EConstant(Builtins.TUPLE_CONSTRUCTORS[0])));
            }
        }
        Object context = new TranslationContext(compilationContext, this.localEnvironment);
        this.expression = this.expression.resolve((TranslationContext)context);
        if (!errorLog.hasNoErrors()) {
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        if (this.localEnvironment != null) {
            this.expression = this.localEnvironment.preDecorateExpression(this.expression);
            ProcedureType procedureType = this.localEnvironment.decorateExpectedType(this.expectedType, this.expectedEffect);
            this.expectedType = procedureType.type;
            this.expectedEffect = procedureType.effect;
        }
        context = new TypingContext(compilationContext);
        ((TypingContext)context).pushEffectUpperBound(this.expression.location, this.expectedEffect);
        this.expression = this.expression.checkType((TypingContext)context, this.expectedType);
        ((TypingContext)context).popEffectUpperBound();
        for (Type type : lvTypes) {
            type.addPolarity(Polarity.POSITIVE);
        }
        this.expectedType.addPolarity(Polarity.POSITIVE);
        ((TypingContext)context).solveSubsumptions(this.expression.location);
        if (!errorLog.hasNoErrors()) {
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        if (this.decorateExpression && Types.canonical(this.expectedEffect) != Types.NO_EFFECTS) {
            ToplevelEffectDecorator toplevelEffectDecorator = new ToplevelEffectDecorator(errorLog, environment);
            this.expression = this.expression.accept(toplevelEffectDecorator);
        }
        this.expression = ((TypingContext)context).solveConstraints(environment, this.expression);
        this.expressionType = this.expression.getType();
        if (!errorLog.hasNoErrors()) {
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        if (this.localEnvironment != null) {
            this.expression = this.localEnvironment.postDecorateExpression(this.expression);
        }
        if (this.validateOnly) {
            return null;
        }
        Type type2 = this.expression.getType();
        type2 = type2.convertMetaVarsToVars();
        for (Type type3 : lvTypes) {
            type3.convertMetaVarsToVars();
        }
        ArrayList<TVar> arrayList = Types.freeVars(type2);
        this.expression = this.expression.closure(arrayList.toArray(new TVar[arrayList.size()]));
        MutableClassLoader classLoader = this.runtimeEnvironment.getMutableClassLoader();
        String string = classLoader.getFreshPackageName();
        compilationContext.javaTypeTranslator = javaTypeTranslator = new JavaTypeTranslator(environment);
        compilationContext.namingPolicy = namingPolicy = new JavaNamingPolicy(string);
        ModuleBuilder moduleBuilder = new ModuleBuilder(namingPolicy, javaTypeTranslator);
        SimplificationContext context2 = new SimplificationContext(compilationContext, DummyJavaReferenceValidator.INSTANCE);
        this.expression = this.expression.simplify(context2);
        if (!errorLog.hasNoErrors()) {
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        if (this.interpretIfPossible) {
            try {
                ExpressionInterpretationContext expressionInterpretationContext = new ExpressionInterpretationContext(this.runtimeEnvironment, new TransientClassBuilder(classLoader, javaTypeTranslator));
                IExpression iexp = this.expression.toIExpression(expressionInterpretationContext);
                return iexp.execute(new Object[expressionInterpretationContext.getMaxVariableId()]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        ModuleWriter mw = new ModuleWriter(namingPolicy.getModuleClassName());
        DecomposedExpression decomposed = DecomposedExpression.decompose(errorLog, this.expression);
        SCLConstant constant = new SCLConstant(Name.create(string, COMPUTATION_METHOD_NAME), this.expression.getType());
        constant.setBase(new JavaStaticMethod(string, COMPUTATION_METHOD_NAME, decomposed.effect, decomposed.typeParameters, decomposed.returnType, decomposed.parameterTypes));
        try {
            CodeWriter w = mw.createFunction(constant, decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
            constant.setDefinition(w.getFunction());
            IVal[] parameterVals = w.getParameters();
            int i = 0;
            while (i < decomposed.parameters.length) {
                decomposed.parameters[i].setVal(parameterVals[i]);
                ++i;
            }
            w.return_(decomposed.body.toVal(compilationContext, w));
        }
        catch (RuntimeException runtimeException) {
            errorLog.setExceptionPosition(this.expression.location);
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        SSAModule ssaModule = mw.getModule();
        ExternalConstant[] externalConstants = mw.getExternalConstants();
        int phase = 0;
        while (phase < 2) {
            int optCount = 0;
            while (optCount++ < 4 && ssaModule.simplify(environment, phase)) {
            }
            ++phase;
        }
        ssaModule.lambdaLift(errorLog);
        ssaModule.markGenerateOnFly();
        try {
            ssaModule.generateCode(moduleBuilder);
        }
        catch (CodeBuildingException e) {
            errorLog.log(e);
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        Map<String, byte[]> classes = moduleBuilder.getClasses();
        ssaModule.cleanup();
        try {
            classLoader.addClasses(classes);
            Class<?> clazz = classLoader.loadClass("scl." + string);
            Object[] objectArray = externalConstants;
            int n = externalConstants.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalConstant externalConstant = objectArray[n2];
                clazz.getField(externalConstant.fieldName).set(null, externalConstant.value);
                ++n2;
            }
            objectArray = clazz.getMethods();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object method = objectArray[n2];
                if (((Method)method).getName().equals(COMPUTATION_METHOD_NAME)) {
                    return ValueFromMethod.getValueFromStaticMethod((Method)method);
                }
                ++n2;
            }
            errorLog.log("Internal compiler error: didn't find method main from generated byte code.");
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
        catch (ReflectiveOperationException e) {
            errorLog.log(e);
            throw new SCLExpressionCompilationException(errorLog.getErrors());
        }
    }

    public Type getType() {
        return this.expressionType;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    private static class StoreFunction
    extends FunctionImpl1<Object, Object> {
        final LocalStorage storage;
        final String name;
        final Type type;

        public StoreFunction(LocalStorage storage, String name, Type type) {
            this.storage = storage;
            this.name = name;
            this.type = type;
        }

        public Object apply(Object value) {
            Type type = Types.closure(this.type.convertMetaVarsToVars());
            this.storage.store(this.name, value, type);
            return Tuple0.INSTANCE;
        }

        public String toString() {
            return "store_" + this.name;
        }
    }
}

