/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.decomposed;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class DecomposedExpression {
    public final TVar[] typeParameters;
    public final Variable[] parameters;
    public final Type[] parameterTypes;
    public final Type effect;
    public final Type returnType;
    public final Expression body;

    public DecomposedExpression(TVar[] typeParameters, Variable[] parameters, Type[] parameterTypes, Type effect, Type returnType, Expression body) {
        this.typeParameters = typeParameters;
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
        this.effect = effect;
        this.returnType = returnType;
        this.body = body;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static DecomposedExpression decompose(ErrorLog errorLog, Expression expression) {
        typeParameterList = new ArrayList<TVar>();
        parameterList = new ArrayList<Variable>();
        effect /* !! */  = Types.NO_EFFECTS;
        block0: while (true) {
            if (expression instanceof ESimpleLambda) {
                lambda = (ESimpleLambda)expression;
                parameterList.add(lambda.parameter);
                if (Types.canonical(effect /* !! */ ) != Types.NO_EFFECTS) {
                    errorLog.logWarning(expression.location, "Encountered nested lambdas where outermost lambda contains effects. The reason is probably in the subsumption solver and code should be OK.");
                }
                expression = lambda.value;
                effect /* !! */  = Types.simplifyFinalEffect(lambda.getLocalEffect());
                continue;
            }
            if (!(expression instanceof ELambdaType)) break;
            lambda = (ELambdaType)expression;
            expression = lambda.value;
            var9_11 = lambda.parameters;
            var8_9 = lambda.parameters.length;
            var7_7 = 0;
            while (true) {
                if (var7_7 < var8_9) ** break;
                continue block0;
                parameter = var9_11[var7_7];
                typeParameterList.add(parameter);
                ++var7_7;
            }
            break;
        }
        typeParameters = typeParameterList.isEmpty() != false ? TVar.EMPTY_ARRAY : typeParameterList.toArray(new TVar[typeParameterList.size()]);
        parameters = parameterList.toArray(new Variable[parameterList.size()]);
        parameterTypes = Types.getTypes(parameters);
        returnType = expression.getType();
        return new DecomposedExpression(typeParameters, (Variable[])parameters, parameterTypes, effect /* !! */ , returnType, expression);
    }
}

