/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationMode;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ESelect
extends SimplifiableExpression {
    private final Type ARRAY_LIST = Types.con("ArrayList", "T");
    int selectVariant;
    public Expression expression;
    public Query query;
    public Variable[] variables;

    public ESelect(int selectVariant, Expression expression, Query query) {
        this.selectVariant = selectVariant;
        this.expression = expression;
        this.query = query;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.selectVariant == 60 ? Types.apply((Type)Types.MAYBE, this.expression.getType()) : Types.list(this.expression.getType()));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        Expression result;
        Type componentType;
        switch (this.selectVariant) {
            case 59: 
            case 61: {
                try {
                    componentType = Types.unifyApply(Types.LIST, requiredType);
                    break;
                }
                catch (MatchException matchException) {
                    context.getErrorLog().log(this.location, "Select expression produces a list of values.");
                    return new EError(this.location);
                }
            }
            case 60: {
                try {
                    componentType = Types.unifyApply(Types.MAYBE, requiredType);
                    break;
                }
                catch (MatchException matchException) {
                    context.getErrorLog().log(this.location, "Select first expression produces an optional value.");
                    return new EError(this.location);
                }
            }
            default: {
                throw new InternalCompilerError();
            }
        }
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.expression.checkType(context, componentType);
        this.query.checkType(context);
        Type elType = this.expression.getType();
        if (this.selectVariant == 60) {
            QueryCompilationContext queryCompilationContext = new QueryCompilationContext(context, QueryCompilationMode.GET_FIRST, this.expression.getType(), Expressions.Just(this.expression));
            try {
                new QExists(this.variables, this.query).generate(queryCompilationContext);
            }
            catch (UnsolvableQueryException e) {
                context.getErrorLog().log(this.getLocation(), "Failed to compile the query.\n" + e.getMessage());
                return new EError(this.getLocation());
            }
            result = queryCompilationContext.getContinuation();
        } else {
            Variable accumulator = Expressions.newVar("accum", Types.apply(this.ARRAY_LIST, elType));
            result = Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.ArrayList_freeze, elType, Expressions.var(accumulator));
            Expression innerExpression = Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.ArrayList_add, elType, Expressions.var(accumulator), this.expression);
            try {
                QueryCompilationContext queryCompilationContext = new QueryCompilationContext(context, QueryCompilationMode.ITERATE, null, innerExpression);
                new QExists(this.variables, this.query).generate(queryCompilationContext);
                result = Expressions.seq(queryCompilationContext.getContinuation(), result);
            }
            catch (UnsolvableQueryException e) {
                context.getErrorLog().log(this.getLocation(), "Failed to compile the query.\n" + e.getMessage());
                return new EError(this.getLocation());
            }
            result = Expressions.let(accumulator, Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.ArrayList_new, elType, Expressions.tuple()), result);
        }
        return Expressions.loc(this.location, result);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.expression = this.expression.resolve(context);
        this.query = this.query.resolve(context);
        this.variables = context.popExistentialFrame();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.expression.setLocationDeep(loc);
            this.query.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

