/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.elaboration.java.DynamicConstructor;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class EConstant
extends Expression {
    public SCLValue value;
    Type[] typeParameters;

    public EConstant(SCLValue value, Type ... typeParameters) {
        this.value = value;
        this.typeParameters = typeParameters;
    }

    public EConstant(SCLValue value) {
        this.value = value;
        this.typeParameters = Type.EMPTY_ARRAY;
    }

    public EConstant(long loc, SCLValue value) {
        super(loc);
        this.value = value;
        this.typeParameters = Type.EMPTY_ARRAY;
    }

    public EConstant(long loc, SCLValue value, Type ... typeParameters) {
        super(loc);
        this.value = value;
        this.typeParameters = typeParameters;
    }

    public void addTypeParameters(Type ... newTypeParameters) {
        this.typeParameters = Types.concat(this.typeParameters, newTypeParameters);
    }

    @Override
    public Expression applyType(Type type) {
        this.typeParameters = Types.concat(this.typeParameters, new Type[]{type});
        if (this.getType() != null) {
            this.setType(Types.instantiate(this.getType(), type));
        }
        return this;
    }

    @Override
    public Set<Variable> getFreeVariables() {
        return Collections.emptySet();
    }

    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        Name name = this.value.getName();
        if (name.module.equals("Builtin") || name.module.equals("Prelude")) {
            b.append(name.name);
        } else {
            b.append(name);
        }
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.instantiate(this.value.getType(), this.typeParameters));
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        IVal val = this.value.getValue();
        if (this.typeParameters.length > 0) {
            val = val.createSpecialization(this.typeParameters);
        }
        return val;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        if (this.value.getInlineInSimplification()) {
            if (this.typeParameters.length > 0) {
                context.getErrorLog().log(this.location, "Inlining with type parameters not currently supported in simplification.");
                return this;
            }
            return this.value.getExpression().copy().simplify(context);
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
    }

    public SCLValue getValue() {
        return this.value;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Type[] newTypeParameters;
        if (this.typeParameters.length == 0) {
            newTypeParameters = Type.EMPTY_ARRAY;
        } else {
            newTypeParameters = new Type[this.typeParameters.length];
            int i = 0;
            while (i < newTypeParameters.length) {
                newTypeParameters[i] = this.typeParameters[i].replace(context.tvarMap);
                ++i;
            }
        }
        return new EConstant(this.value, newTypeParameters);
    }

    public Type[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public LhsType getLhsType() throws NotPatternException {
        return new PatternMatchingLhs();
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        Name name = this.value.getName();
        try {
            return new IConstant(target.runtimeEnvironment.getRuntimeModule(name.module).getValue(name.name));
        }
        catch (ValueNotFound valueNotFound) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Expression inferType(TypingContext context) {
        if (context.recursiveValues != null && context.recursiveValues.contains((Object)this.value)) {
            EPlaceholder placeholder = new EPlaceholder(this.location, this);
            placeholder.setType(this.value.getType());
            context.recursiveReferences.add(placeholder);
            return placeholder;
        }
        if (context.isInPattern() && this.value.getValue() != DynamicConstructor.INSTANCE) {
            Type resultType = this.value.getType();
            if (resultType instanceof TForAll) {
                ArrayList<TMetaVar> vars = new ArrayList<TMetaVar>();
                resultType = Types.instantiate(resultType, vars);
                MultiFunction mfun = Types.matchFunction(resultType);
                resultType = mfun.returnType;
                for (TMetaVar var : vars) {
                    if (resultType.contains(var)) break;
                    this.addTypeParameters(Types.var(var.getKind()));
                }
            }
            return this;
        }
        return this.applyPUnit(context);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Precedence getPrecedence() {
        return this.value.getPrecedence();
    }

    @Override
    public boolean isPattern(int arity) {
        IVal val = this.value.getValue();
        if (!(val instanceof Constant)) {
            return false;
        }
        Constant constant = (Constant)val;
        return constant.constructorTag() >= 0 && constant.getArity() == arity;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public boolean equalsExpression(Expression expression) {
        if (expression.getClass() != this.getClass()) {
            return false;
        }
        EConstant other = (EConstant)expression;
        return this.value == other.value && Types.equals(this.typeParameters, other.typeParameters);
    }
}

