/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EBind
extends SimplifiableExpression {
    public Expression pattern;
    public Expression value;
    public Expression in;
    public EVariable monadEvidence;
    SCLValue bindFunction;
    Type monadType;
    Type valueContentType;
    Type inContentType;

    public EBind(long loc, Expression pattern, Expression value, Expression in) {
        super(loc);
        this.pattern = pattern;
        this.value = value;
        this.in = in;
    }

    public EBind(long loc, Expression pattern, Expression value, Expression in, SCLValue bindFunction) {
        super(loc);
        this.pattern = pattern;
        this.value = value;
        this.in = in;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.monadType = Types.metaVar(Kinds.STAR_TO_STAR);
        this.inContentType = Types.metaVar(Kinds.STAR);
        TApply monadContent = Types.apply(this.monadType, this.inContentType);
        try {
            Types.unify(requiredType, (Type)monadContent);
        }
        catch (UnificationException unificationException) {
            context.typeError(this.location, requiredType, monadContent);
            return this;
        }
        Variable variable = new Variable("monadEvidence");
        variable.setType(Types.pred(Types.MONAD, this.monadType));
        this.monadEvidence = new EVariable(this.getLocation(), variable);
        this.monadEvidence.setType(variable.getType());
        context.addConstraintDemand(this.monadEvidence);
        this.pattern = this.pattern.checkTypeAsPattern(context, Types.metaVar(Kinds.STAR));
        this.valueContentType = this.pattern.getType();
        this.value = this.value.checkType(context, Types.apply(this.monadType, this.valueContentType));
        this.in = this.in.checkType(context, requiredType);
        Type inType = this.in.getType();
        this.setType(inType);
        return this;
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new InternalCompilerError("EBind should be eliminated.");
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        this.in = this.in.simplify(context);
        this.pattern = this.pattern.simplify(context);
        long loc = this.getLocation();
        EApply simplified = new EApply(loc, (Expression)new EConstant(loc, this.bindFunction, Types.canonical(this.monadType), Types.canonical(this.valueContentType), Types.canonical(this.inContentType)), this.monadEvidence, this.value, new ELambda(loc, new Case(new Expression[]{this.pattern}, this.in)));
        simplified.setType(this.getType());
        return ((Expression)simplified).simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        context.pushFrame();
        this.pattern = this.pattern.resolveAsPattern(context);
        this.in = this.in.resolve(context);
        context.popFrame();
        this.bindFunction = context.getBindFunction();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

