/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.ClassificationsRequest;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.layer0.variable.StandardAssertedGraphPropertyVariable;
import org.simantics.db.layer0.variable.StandardConstantGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.structural2.Functions;
import org.simantics.structural2.procedural.ConnectionPoint;
import org.simantics.structural2.procedural.Expression;
import org.simantics.structural2.procedural.Interface;
import org.simantics.structural2.procedural.Property;
import org.simantics.structural2.procedural.Terminal;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.StructuralProceduralExpressionPropertyVariable;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.Pair;

public class StandardProceduralChildVariable
extends AbstractChildVariable {
    protected final String name;
    protected final Variable parent;
    private final Resource type;
    private final Map<String, Variable> properties;
    private final List<Object> propertyIdentity;

    public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    public void collectSpecialChildren(ReadGraph graph, Map<String, Variable> children) throws DatabaseException {
    }

    public StandardProceduralChildVariable(ReadGraph graph, Variable parent, VariableNode node, String name, Resource type, List<Property> properties, Collection<org.simantics.structural2.procedural.Connection> conns) throws DatabaseException {
        super(node);
        assert (name != null);
        assert (type != null);
        this.name = name;
        this.parent = parent;
        this.type = type;
        this.properties = new THashMap();
        this.propertyIdentity = new ArrayList<Object>(properties.size() + conns.size());
        this.propertyIdentity.addAll(properties);
        this.propertyIdentity.addAll(conns);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        THashMap assertedProperties = new THashMap();
        for (Statement stm : graph.getAssertedStatements(type, L0.HasProperty)) {
            String string = (String)graph.getRelatedValue(stm.getPredicate(), L0.HasName, (Binding)Bindings.STRING);
            assertedProperties.put(string, stm);
        }
        Collection nodeProperties = All.getPossibleNodeProperties((ReadGraph)graph, (Variable)this);
        HashSet<String> used = new HashSet<String>(nodeProperties.size());
        for (Object e : nodeProperties) {
            NodeSupport support = node.support;
            NodeManager manager = support.manager;
            String pName = manager.getName(e);
            used.add(pName);
            Statement assertedProperty = (Statement)assertedProperties.get(pName);
            if (assertedProperty == null) continue;
            this.properties.put(pName, (Variable)new StandardAssertedGraphPropertyVariable(graph, (Variable)this, new VariableNode(support, e), assertedProperty.getSubject(), assertedProperty.getPredicate(), assertedProperty.getObject()));
        }
        for (Map.Entry entry : assertedProperties.entrySet()) {
            String pName = (String)entry.getKey();
            if (used.contains(pName)) continue;
            Statement assertedProperty = (Statement)entry.getValue();
            this.properties.put(pName, (Variable)new StandardAssertedGraphPropertyVariable(graph, (Variable)this, null, assertedProperty.getSubject(), assertedProperty.getPredicate(), assertedProperty.getObject()));
        }
        for (Property property : properties) {
            String pn = (String)graph.getRelatedValue(property.relation, L0.HasName, (Binding)Bindings.STRING);
            if (property.value == null) {
                Logger.defaultLogError((String)("StandardProceduralChildVariable " + this.getURI(graph) + ": null value for property " + pn));
                continue;
            }
            if (property.value instanceof Expression) {
                Expression expression = (Expression)property.value;
                this.properties.put(pn, (Variable)new StructuralProceduralExpressionPropertyVariable(graph, (Variable)this, property.relation, expression.text));
                continue;
            }
            this.properties.put(pn, (Variable)new StandardConstantGraphPropertyVariable(graph, (Variable)this, property.relation, property.value));
        }
        HashMap<Resource, FixedConnection> hashMap = new HashMap<Resource, FixedConnection>();
        for (org.simantics.structural2.procedural.Connection connection : conns) {
            Resource p = null;
            ArrayList<Pair> cps = new ArrayList<Pair>();
            for (ConnectionPoint cp : connection.connectionPoints) {
                if (cp instanceof Terminal) {
                    Terminal t = (Terminal)cp;
                    if (t.component.equals(name)) {
                        p = t.relation;
                        continue;
                    }
                    cps.add(Pair.make((Object)t.component, (Object)t.relation));
                }
                if (!(cp instanceof Interface)) continue;
                Interface inf = (Interface)cp;
                cps.add(new Pair(null, (Object)inf.relation));
            }
            if (p == null) continue;
            FixedConnection fc = (FixedConnection)hashMap.get(p);
            if (fc == null) {
                fc = new FixedConnection(parent);
                hashMap.put(p, fc);
            }
            fc.cps.addAll(cps);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Resource cp = (Resource)entry.getKey();
            String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
            this.properties.put(cpName, (Variable)new StandardConstantGraphPropertyVariable(graph, (Variable)this, cp, entry.getValue()));
        }
    }

    public void validate(ReadGraph graph) throws DatabaseException {
    }

    public Resource getType(ReadGraph graph) throws DatabaseException {
        return this.type;
    }

    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        return this.type;
    }

    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        if (graph.isInheritedFrom(this.type, baseType)) {
            return this.type;
        }
        throw new NoSingleResultException("variable " + this.getPossibleURI(graph) + " has no type");
    }

    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return graph.isInheritedFrom(this.type, baseType) ? this.type : null;
    }

    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        return this.properties.get(name);
    }

    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        return Functions.structuralChildDomainChildren.getVariable(graph, (Variable)this, name);
    }

    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        if (!this.properties.isEmpty()) {
            if (properties == null) {
                properties = new THashMap(this.properties.size());
            }
            properties.putAll(this.properties);
        }
        return properties;
    }

    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        Map result = Functions.structuralChildDomainChildren.getVariables(graph, (Variable)this, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return result.values();
    }

    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        Resource type = this.getPossibleType(graph);
        return type != null ? (Set)graph.syncRequest((Read)new ClassificationsRequest(Collections.singleton(type))) : Collections.emptySet();
    }

    public String getName(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    public final Resource getRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public int hashCode() {
        return this.parent.hashCode() + 31 * this.name.hashCode() + 41 * this.type.hashCode() + 71 * System.identityHashCode(this.propertyIdentity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StandardProceduralChildVariable other = (StandardProceduralChildVariable)((Object)obj);
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.parent.equals(other.parent)) {
            return false;
        }
        return this.propertyIdentity == other.propertyIdentity;
    }

    public static class FixedConnection
    implements Connection {
        public final Collection<Pair<String, Resource>> cps = new ArrayList<Pair<String, Resource>>();
        private final Variable parent;

        public FixedConnection(Variable parent) {
            this.parent = parent;
        }

        @Override
        public Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException {
            THashSet result = new THashSet();
            for (Pair<String, Resource> cp : this.cps) {
                Variable component = cp.first == null ? this.parent : this.parent.getChild(graph, (String)cp.first);
                Variable cp2 = component.getPossibleProperty(graph, (Resource)cp.second);
                if (cp2 != null) {
                    for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, component, (Resource)cp.second, relationType)) {
                        result.add(desc.getVariable(graph));
                    }
                    continue;
                }
                System.err.println("no cp " + (String)cp.first + " for " + component.getURI(graph));
            }
            return result;
        }

        @Override
        public Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException {
            THashSet result = new THashSet();
            for (Pair<String, Resource> cp : this.cps) {
                Variable component = cp.first == null ? this.parent : this.parent.getChild(graph, (String)cp.first);
                Variable cp2 = component.getPossibleProperty(graph, (Resource)cp.second);
                if (cp2 != null) {
                    for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, component, (Resource)cp.second, relationType)) {
                        result.add(desc.getURI(graph));
                    }
                    continue;
                }
                System.err.println("no cp " + (String)cp.first + " for " + component.getURI(graph));
            }
            return result;
        }

        @Override
        public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Resource relationType) throws DatabaseException {
            THashSet result = new THashSet();
            for (Pair<String, Resource> cp : this.cps) {
                Variable component = cp.first == null ? this.parent : this.parent.getChild(graph, (String)cp.first);
                Variable cp2 = component.getPossibleProperty(graph, (Resource)cp.second);
                if (cp2 != null) {
                    result.addAll(ConnectionBrowser.flatten(graph, component, (Resource)cp.second, relationType));
                    continue;
                }
                System.err.println("no cp " + (String)cp.first + " for " + component.getURI(graph));
            }
            return result;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.cps == null ? 0 : this.cps.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixedConnection other = (FixedConnection)obj;
            if (this.cps == null ? other.cps != null : !this.cps.equals(other.cps)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }
    }
}

