/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ExceptionUtils;

public class ModelBrowser
extends GraphExplorerComposite {
    volatile DndBrowseContext dndBrowseContext;
    private static final String CONTEXT_MENU_ID = "#GraphExplorerPopup";
    protected Set<String> propertyBrowseContexts = Collections.emptySet();
    protected boolean hideComparatorSelector = false;
    protected boolean hideViewpointSelector = false;
    protected boolean hideFilter = false;

    @Override
    protected String getContextMenuId() {
        if (this.contextMenuId != null) {
            return this.contextMenuId;
        }
        return CONTEXT_MENU_ID;
    }

    @Override
    protected void createControls(Composite parent) {
        this.propertyBrowseContexts = ModelBrowser.loadBrowseContexts(this.getBrowseContexts());
        super.createControls(parent);
    }

    protected static Set<String> loadBrowseContexts(final Set<String> browseContexts) {
        try {
            return (Set)Simantics.getSession().syncRequest((Read)new Read<Set<String>>(){

                public Set<String> perform(ReadGraph graph) throws DatabaseException {
                    ArrayList<Resource> browseContextResources = new ArrayList<Resource>(browseContexts.size());
                    for (String browseContext : browseContexts) {
                        try {
                            browseContextResources.add(graph.getResource(browseContext));
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                        }
                        catch (DatabaseException e) {
                            ExceptionUtils.logError((String)("Didn't find " + browseContext + " while loading model browser."), (Throwable)e);
                        }
                    }
                    Collection allBrowseContextResources = BrowseContext.findSubcontexts((ReadGraph)graph, browseContextResources);
                    HashSet<String> result = new HashSet<String>();
                    for (Resource r : allBrowseContextResources) {
                        result.add(graph.getURI(r));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Failed to load modeled browse contexts for property page, see exception for details.", (Throwable)e);
            return browseContexts;
        }
    }

    public ModelBrowser(final Set<String> _browseContexts, Map<String, Object> args, IWorkbenchSite site, Composite parent, WidgetSupport support, int style) {
        super(args, site, parent, support, style);
        this.setBrowseContexts(_browseContexts);
        this.hideComparatorSelector = true;
        this.hideViewpointSelector = true;
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : _browseContexts) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext == null) continue;
                    browseContexts.add(browseContext);
                }
                try {
                    ModelBrowser.this.dndBrowseContext = DndBrowseContext.create((ReadGraph)graph, browseContexts);
                }
                catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }

    @Override
    protected void handleDrop(final Object data, final NodeContext target) {
        if (target == null) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new Read<Runnable>(){

            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (ModelBrowser.this.dndBrowseContext == null) {
                    return null;
                }
                return ModelBrowser.this.dndBrowseContext.getAction(graph, target, data);
            }
        }, (Procedure)new Procedure<Runnable>(){

            public void execute(Runnable result) {
                Display.getDefault().asyncExec(() -> {
                    if (!Display.getCurrent().isDisposed() && result != null) {
                        result.run();
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }
}

