/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.GraphExplorerImpl;
import org.simantics.browsing.ui.swt.TreeItemReference;

public class GraphExplorerToolTip
extends ToolTip {
    private boolean DEBUG = false;
    private Tree parent;
    private NodeContext nodeContext;
    private Labeler labeler;
    private GraphExplorerImpl.GraphExplorerContext explorerContext;

    public GraphExplorerToolTip(GraphExplorerImpl.GraphExplorerContext explorerContext, Tree parent) {
        super((Control)parent, 2, false);
        this.setHideOnMouseDown(false);
        this.setPopupDelay(400);
        this.explorerContext = explorerContext;
        this.parent = parent;
        this.nodeContext = null;
        if (this.DEBUG) {
            System.out.println("GraphExplorerToolTip constructor called for parent : " + parent + ", class : " + parent.getClass().toString());
        }
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        return ((LabelerStub)this.labeler).createToolTipContentArea(event, parent, this.nodeContext);
    }

    protected boolean shouldCreateToolTip(Event event) {
        TreeItem treeItem = this.parent.getItem(new Point(event.x, event.y));
        if (treeItem == null) {
            return false;
        }
        GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.explorerContext, null, null, (UIElementReference)TreeItemReference.create(treeItem.getParentItem()));
        this.nodeContext = (NodeContext)treeItem.getData();
        if (this.nodeContext != null) {
            this.labeler = (Labeler)manager.query(this.nodeContext, BuiltinKeys.SELECTED_LABELER);
        }
        if (this.nodeContext == null || !(this.labeler instanceof LabelerStub)) {
            return false;
        }
        return ((LabelerStub)this.labeler).shouldCreateToolTip(event, this.nodeContext);
    }

    public void setGraphExplorerContext(GraphExplorerImpl.GraphExplorerContext explorerContext) {
        this.explorerContext = explorerContext;
    }
}

