/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class Types
extends UnaryQuery<InternalProcedure<IntSet>> {
    private Types(int resource) {
        super(resource);
    }

    static final Types entry(QueryProcessor provider, int r) {
        return (Types)provider.typesMap.get(r);
    }

    static final void runner(ReadGraphImpl graph, int r, QueryProcessor provider, Types cached, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        Types entry;
        Types types = entry = cached != null ? cached : (Types)provider.typesMap.get(r);
        if (entry == null) {
            entry = new Types(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (!entry.isReady()) {
                throw new IllegalStateException();
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    static final IntSet runner2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent) throws Throwable {
        Types entry = (Types)provider.typesMap.get(r);
        if (entry == null) {
            entry = new Types(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            return (IntSet)provider.performForEach2(graph, entry, parent, null, null);
        }
        if (!entry.isReady()) {
            throw new IllegalStateException();
        }
        return (IntSet)provider.performForEach2(graph, entry, parent, null, null);
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        Types entry = (Types)provider.typesMap.get(r);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        Types.runner(graph, r, provider, entry, parent, listener, procedure);
    }

    public static final IntSet queryEach2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent) throws Throwable {
        Types entry;
        if (parent == null && (entry = (Types)provider.typesMap.get(r)) != null && entry.isReady()) {
            return (IntSet)entry.get(graph, provider, null);
        }
        return Types.runner2(graph, r, provider, parent);
    }

    @Override
    public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.typesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.typesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.typesMap.remove(this.id);
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor queryProvider, final InternalProcedure<IntSet> procedure, final boolean store) {
        queryProvider.querySupport.ensureLoaded(graph, this.id);
        int ret = queryProvider.querySupport.getSingleInstance(this.id);
        if (ret > 0) {
            TypeHierarchy.queryEach(graph, ret, queryProvider, store ? this : null, null, new InternalProcedure<IntSet>(){

                @Override
                public void execute(ReadGraphImpl graph, IntSet types) {
                    Types.this.addOrSet(graph, types, queryProvider);
                    procedure.execute(graph, types);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception(graph, t);
                }
            });
            return this.getResult();
        }
        int instanceOf = queryProvider.getInstanceOf();
        int inherits = queryProvider.getInherits();
        int subrelationOf = queryProvider.getSubrelationOf();
        final IntSet result = new IntSet(queryProvider.querySupport);
        final TIntProcedure addToResult = new TIntProcedure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(int r) {
                IntSet intSet = result;
                synchronized (intSet) {
                    result.add(r);
                }
                return true;
            }
        };
        final AtomicInteger finishes = new AtomicInteger(0);
        SyncIntProcedure instanceOfProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                if (finishes.addAndGet(1) == 3) {
                    if (store) {
                        Types.this.addOrSet(graph, result, queryProvider);
                    }
                    procedure.execute(graph, result);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ReadGraphImpl graph, int i) {
                IntSet intSet = result;
                synchronized (intSet) {
                    result.add(i);
                }
                this.inc();
                SuperTypes.queryEach(graph, i, queryProvider, store ? Types.this : null, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        };
        SyncIntProcedure inheritsProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                int current = finishes.addAndGet(1);
                if (current == 3) {
                    if (store) {
                        Types.this.addOrSet(graph, result, queryProvider);
                    }
                    procedure.execute(graph, result);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                this.inc();
                Types.queryEach(graph, i, queryProvider, store ? Types.this : null, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        };
        SyncIntProcedure subrelationOfProcedure = new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                int current = finishes.addAndGet(1);
                if (current == 3) {
                    if (store) {
                        Types.this.addOrSet(graph, result, queryProvider);
                    }
                    procedure.execute(graph, result);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                this.inc();
                Types.queryEach(graph, i, queryProvider, store ? Types.this : null, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        };
        queryProvider.querySupport.getObjects(graph, this.id, instanceOf, instanceOfProcedure);
        instanceOfProcedure.finished(graph);
        queryProvider.querySupport.getObjects(graph, this.id, inherits, inheritsProcedure);
        inheritsProcedure.finished(graph);
        queryProvider.querySupport.getObjects(graph, this.id, subrelationOf, subrelationOfProcedure);
        subrelationOfProcedure.finished(graph);
        return result;
    }

    public String toString() {
        return "Types[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrSet(ReadGraphImpl graph, IntSet value, QueryProcessor provider) {
        assert (!this.isReady());
        Types types = this;
        synchronized (types) {
            value.trim();
            this.setResult(value);
            this.setReady();
        }
    }

    @Override
    public final Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntSet result = (IntSet)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

