/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

public final class AsyncReadEntry<T>
extends CacheEntryBase {
    protected AsyncRead<T> request;

    public AsyncReadEntry(AsyncRead<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrSet(AsyncReadGraph graph, Object item) {
        assert (this.isPending());
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.setResult(item);
            this.setReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void except(AsyncReadGraph graph, Throwable t) {
        assert (this.isPending());
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.except(t);
        }
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
                QueryProcessor qp = (QueryProcessor)provider;
                ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp);
                try {
                    AsyncReadEntry.this.request.perform((AsyncReadGraph)parentGraph, new AsyncProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            AsyncReadEntry.this.addOrSet(graph, result);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            AsyncReadEntry.this.except(t);
                        }
                    });
                }
                catch (Throwable t) {
                    AsyncReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor qp) {
                qp.asyncReadMap.remove(AsyncReadEntry.this.request);
            }

            @Override
            public int type() {
                return AsyncReadEntry.this.request.getFlags();
            }

            public String toString() {
                if (AsyncReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                if (AsyncReadEntry.this.isExcepted()) {
                    return String.valueOf(AsyncReadEntry.this.request.toString()) + " " + AsyncReadEntry.this.getResult();
                }
                return String.valueOf(AsyncReadEntry.this.request.toString()) + " " + AsyncReadEntry.this.statusOrException;
            }
        };
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        AsyncProcedure proc = (AsyncProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                proc.execute((AsyncReadGraph)graph, this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.isDiscarded()) {
            return "DISCARDED " + this.request.toString();
        }
        if (this.isExcepted()) {
            return String.valueOf(this.request.toString()) + " " + this.getResult();
        }
        return String.valueOf(this.request.toString()) + " " + this.statusOrException;
    }
}

