/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.procedure.ListenerBase;

public final class AssertedStatements
extends CollectionBinaryQuery<TripleIntProcedure> {
    public AssertedStatements(int r1, int r2) {
        super(r1, r2);
    }

    public static AssertedStatements newInstance(int r1, int r2) {
        return new AssertedStatements(r1, r2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final AssertedStatements runner(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, AssertedStatements cached, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) {
        AssertedStatements entry;
        AssertedStatements assertedStatements = entry = cached != null ? cached : (AssertedStatements)provider.assertedStatementsMap.get(AssertedStatements.id(r1, r2));
        if (entry == null) {
            entry = new AssertedStatements(r1, r2);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
            return entry;
        }
        if (entry.isPending()) {
            AssertedStatements assertedStatements2 = entry;
            synchronized (assertedStatements2) {
                if (entry.isPending()) {
                    throw new IllegalStateException();
                }
            }
        }
        provider.performForEach(graph, entry, parent, listener, procedure);
        return entry;
    }

    public static final AssertedStatements queryEach(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) {
        assert (r1 != 0);
        assert (r2 != 0);
        AssertedStatements entry = (AssertedStatements)provider.assertedStatementsMap.get(AssertedStatements.id(r1, r2));
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return entry;
        }
        return AssertedStatements.runner(graph, r1, r2, provider, entry, parent, listener, procedure);
    }

    @Override
    public BinaryQuery<TripleIntProcedure> getEntry(QueryProcessor provider) {
        return provider.assertedStatementsMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.assertedStatementsMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.assertedStatementsMap.remove(this.id);
    }

    void computeInheritedAssertions(ReadGraphImpl graph, int type, final int predicate, RelationInfo ri, final QueryProcessor queryProvider, final TripleIntProcedure proc) {
        DirectObjects.queryEach(graph, type, queryProvider.getInherits(), queryProvider, this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                AssertedStatements.this.finish(graph, queryProvider);
                proc.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int inh) {
                this.inc();
                AssertedStatements.queryEach(graph, inh, predicate, queryProvider, AssertedStatements.this, null, new TripleIntProcedureAdapter(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) {
                        if (AssertedStatements.this.addOrSet(s, p, o)) {
                            proc.execute(graph, s, p, o);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        proc.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
    }

    void computeLocalAssertions(ReadGraphImpl graph, final int type, final int predicate, final RelationInfo ri, final QueryProcessor queryProvider, final TripleIntProcedure proc) {
        final AtomicInteger found = new AtomicInteger(0);
        DirectObjects.queryEach(graph, type, queryProvider.getAsserts(), queryProvider, this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                if (ri.isFunctional && found.get() > 1) {
                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one asserted statement.");
                    AssertedStatements.this.except((Throwable)exception);
                    proc.exception(graph, (Throwable)exception);
                    return;
                }
                if (ri.isFunctional && found.get() == 1) {
                    AssertedStatements.this.finish(graph, queryProvider);
                    proc.finished(graph);
                    return;
                }
                AssertedStatements.this.computeInheritedAssertions(graph, type, predicate, ri, queryProvider, proc);
            }

            @Override
            public void execute(ReadGraphImpl graph, final int ass) {
                if (ri.isFunctional && found.get() > 1) {
                    return;
                }
                this.inc();
                DirectObjects.queryEach(graph, ass, queryProvider.getHasPredicate(), queryProvider, AssertedStatements.this, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, final int pred) {
                        if (ri.isFunctional) {
                            if (found.get() > 1) {
                                return;
                            }
                            this.inc();
                            DirectObjects.queryEach(graph, ass, queryProvider.getHasObject(), queryProvider, AssertedStatements.this, null, new IntProcedure(){

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) {
                                    if (found.get() > 1) {
                                        return;
                                    }
                                    if (pred == predicate) {
                                        if (found.getAndIncrement() == 0 && AssertedStatements.this.addOrSet(type, pred, object)) {
                                            proc.execute(graph, type, pred, object);
                                        }
                                        return;
                                    }
                                    if (!ri.isFinal) {
                                        this.inc();
                                        SuperRelations.queryEach(graph, pred, queryProvider, AssertedStatements.this, null, new InternalProcedure<IntSet>(){

                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) {
                                                if (found.get() > 1) {
                                                    this.dec(graph);
                                                    return;
                                                }
                                                if (result.contains(predicate) && found.getAndIncrement() == 0 && AssertedStatements.this.addOrSet(type, pred, object)) {
                                                    proc.execute(graph, type, pred, object);
                                                }
                                                this.dec(graph);
                                            }

                                            @Override
                                            public void exception(ReadGraphImpl graph, Throwable t) {
                                                proc.exception(graph, t);
                                                this.dec(graph);
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void finished(ReadGraphImpl graph) {
                                    this.dec(graph);
                                }

                                @Override
                                public void exception(ReadGraphImpl graph, Throwable t) {
                                    proc.exception(graph, t);
                                    this.dec(graph);
                                }
                            });
                        } else {
                            this.inc();
                            DirectObjects.queryEach(graph, ass, queryProvider.getHasObject(), queryProvider, AssertedStatements.this, null, new IntProcedure(){

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) {
                                    if (pred == predicate) {
                                        AssertedStatements.this.addOrSet(type, pred, object);
                                        proc.execute(graph, type, pred, object);
                                        return;
                                    }
                                    if (!ri.isFinal) {
                                        this.inc();
                                        SuperRelations.queryEach(graph, pred, queryProvider, AssertedStatements.this, null, new InternalProcedure<IntSet>(){

                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) {
                                                if (result.contains(predicate)) {
                                                    AssertedStatements.this.addOrSet(type, pred, object);
                                                    proc.execute(graph, type, pred, object);
                                                }
                                                this.dec(graph);
                                            }

                                            @Override
                                            public void exception(ReadGraphImpl graph, Throwable t) {
                                                proc.exception(graph, t);
                                                this.dec(graph);
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void finished(ReadGraphImpl graph) {
                                    this.dec(graph);
                                }

                                @Override
                                public void exception(ReadGraphImpl graph, Throwable t) {
                                    proc.exception(graph, t);
                                    this.dec(graph);
                                }
                            });
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        proc.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final TripleIntProcedure procedure, boolean store) {
        RelationInfoQuery.queryEach(graph, this.r2(), provider, this, null, new InternalProcedure<RelationInfo>(){

            @Override
            public void execute(ReadGraphImpl graph, RelationInfo ri) {
                AssertedStatements.this.computeLocalAssertions(graph, AssertedStatements.this.r1(), AssertedStatements.this.r2(), ri, provider, procedure);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
    }

    public String toString() {
        return "AssertedStatements2[" + this.r1() + " - " + this.r2() + "]";
    }

    private boolean addOrSet(int s, int p, int o) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        if (value.data != null) {
            int i = 0;
            while (i < value.sizeOrData) {
                int existingO;
                int existingP = value.data[i + 1];
                if (p == existingP && (existingO = value.data[i + 2]) == o) {
                    return false;
                }
                i += 3;
            }
            value.add(s);
            value.add(p);
            value.add(o);
        } else {
            value.add(s);
            value.add(p);
            value.add(o);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        assert (this.isPending());
        AssertedStatements assertedStatements = this;
        synchronized (assertedStatements) {
            this.setReady();
        }
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, TripleIntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return;
        }
        IntArray value = (IntArray)this.getResult();
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new TripleIntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute", t);
            }
        }, true);
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.r1());
    }
}

