/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.translation;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import org.antlr.runtime.tree.Tree;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Problem;
import org.simantics.ltk.antlr.ANTLRUtils;

public class DataTypeTranslator {
    ISource source;
    Collection<Problem> problems;

    public DataTypeTranslator(ISource source, Collection<Problem> problems) {
        this.source = source;
        this.problems = problems;
    }

    public Datatype translate(Tree tree) {
        switch (tree.getType()) {
            case 27: {
                return this.translateRecordType(tree);
            }
            case 26: {
                return this.translateUnionType(tree);
            }
            case 28: {
                return this.translateTupleType(tree);
            }
            case 29: {
                return this.translateArrayType(tree);
            }
            case 30: {
                return this.translateTypeReference(tree);
            }
        }
        DataTypeTranslator.printTree(0, tree);
        throw new IllegalArgumentException("The argument is not a data type AST");
    }

    private Datatype translateArrayType(Tree tree) {
        return new ArrayType(this.translate(tree.getChild(0)));
    }

    private Datatype translateTupleType(Tree tree) {
        int count = tree.getChildCount();
        if (count == 1) {
            return this.translate(tree.getChild(0));
        }
        Component[] components = new Component[count];
        int i = 0;
        while (i < count) {
            components[i] = new Component(Integer.toString(i), this.translate(tree.getChild(i)));
            ++i;
        }
        return new RecordType(false, components);
    }

    private static THashMap<String, String> getAnnotations(Tree tree) {
        THashMap result = new THashMap();
        int i = 1;
        while (i < tree.getChildCount()) {
            Tree child = tree.getChild(i);
            if (child.getType() == 31) {
                result.put((Object)child.getChild(0).getText(), (Object)DataTypeTranslator.convertValue(child.getChild(1)));
            }
            ++i;
        }
        return result;
    }

    private static String convertValue(Tree value) {
        switch (value.getType()) {
            case 61: {
                String str = value.getText();
                return str.substring(1, str.length() - 1);
            }
            case 54: 
            case 56: {
                return value.getText();
            }
            case 57: {
                return String.valueOf(value.getChild(0).getText()) + value.getChild(1).getText() + value.getChild(2).getText();
            }
        }
        throw new IllegalArgumentException();
    }

    private Datatype translateTypeReference(Tree tree) {
        String name = tree.getChild(0).getText();
        if (name.equals("Boolean")) {
            return Datatypes.BOOLEAN;
        }
        if (name.equals("Byte")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new ByteType((String)annotations.get((Object)"unit"), (String)annotations.get((Object)"range"));
        }
        if (name.equals("Integer")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new IntegerType((String)annotations.get((Object)"unit"), (String)annotations.get((Object)"range"));
        }
        if (name.equals("Float")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new FloatType((String)annotations.get((Object)"unit"), (String)annotations.get((Object)"range"));
        }
        if (name.equals("Double")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new DoubleType((String)annotations.get((Object)"unit"), (String)annotations.get((Object)"range"));
        }
        if (name.equals("Long")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new LongType((String)annotations.get((Object)"unit"), (String)annotations.get((Object)"range"));
        }
        if (name.equals("String")) {
            THashMap<String, String> annotations = DataTypeTranslator.getAnnotations(tree);
            return new StringType((String)annotations.get((Object)"pattern"), (String)annotations.get((Object)"mimeType"), (String)annotations.get((Object)"length"));
        }
        if (name.equals("Variant")) {
            return Datatypes.VARIANT;
        }
        if (name.equals("Optional")) {
            return new OptionalType(this.translate(tree.getChild(1)));
        }
        if (name.equals("Map")) {
            return new MapType(this.translate(tree.getChild(1)), this.translate(tree.getChild(2)));
        }
        if (name.equals("DataType")) {
            return Datatypes.getDatatypeUnchecked(Datatype.class);
        }
        this.error(tree, "Invalid data type " + name + ".");
        return null;
    }

    private Datatype translateUnionType(Tree tree) {
        Component[] components = new Component[tree.getChildCount()];
        int i = 0;
        while (i < components.length) {
            Tree c = tree.getChild(i);
            components[i] = new Component(c.getChild(0).getText(), c.getChildCount() > 1 ? this.translate(c.getChild(1)) : RecordType.VOID_TYPE);
            ++i;
        }
        return new UnionType(components);
    }

    private Datatype translateRecordType(Tree tree) {
        Component[] components = new Component[tree.getChildCount()];
        int i = 0;
        while (i < components.length) {
            Tree c = tree.getChild(i);
            components[i] = new Component(c.getChild(0).getText(), this.translate(c.getChild(1)));
            ++i;
        }
        return new RecordType(false, components);
    }

    public static void printTree(int indent, Tree tree) {
        int i = 0;
        while (i < indent) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(tree.getText());
        i = 0;
        while (i < tree.getChildCount()) {
            DataTypeTranslator.printTree(indent + 1, tree.getChild(i));
            ++i;
        }
    }

    private void error(Tree tree, String description) {
        this.problems.add(new Problem(ANTLRUtils.location((ISource)this.source, (Tree)tree), description));
    }
}

