/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.simantics.db.Resource;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.ui.SheetNode;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SheetClass {
    public static final IHintContext.Key KEY_SERVER_INTERFACE = new IHintContext.KeyOf(Adaptable.class, "SERVER_INTERFACE");
    public static final IHintContext.Key KEY_SHEET = new IHintContext.KeyOf(Resource.class, "SHEET");
    public static final IHintContext.Key KEY_RVI = new IHintContext.KeyOf(String.class, "RVI");
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "SG_NODE");
    public static final ElementClass INSTANCE = ElementClass.compile((ElementHandler[])new ElementHandler[]{DefaultTransform.INSTANCE, BorderColorImpl.BLACK, SheetSGNode.INSTANCE, SimpleElementLayers.INSTANCE});

    public static class SheetSGNode
    implements SceneGraph,
    InternalSize,
    Outline {
        private static final long serialVersionUID = -5823585015844593347L;
        static final SheetSGNode INSTANCE = new SheetSGNode();

        public void init(IElement e, G2DParentNode parent) {
            SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
            if (node == null || node.getBounds() == null || node.getParent() != parent) {
                node = (SheetNode)parent.addNode(ElementUtils.generateNodeId((IElement)e), SheetNode.class);
                e.setHint(KEY_SG_NODE, (Object)node);
                Adaptable serverInterface = (Adaptable)e.getHint(KEY_SERVER_INTERFACE);
                node.init(serverInterface);
                Callback callback = (Callback)e.getHint(ElementHints.KEY_SG_CALLBACK);
                if (callback != null) {
                    callback.run((Object)node);
                }
                System.out.println("SHEET PARENT NODE: " + parent);
                node.setBounds(new Rectangle2D.Double(0.0, 0.0, 400.0, 200.0));
            }
            this.update(e);
        }

        public void update(IElement e) {
        }

        public void cleanup(IElement e) {
            SheetNode node = (SheetNode)e.removeHint(KEY_SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds().getBounds2D();
            }
            if (size != null) {
                size.setRect(shape);
            }
            return shape;
        }

        public Shape getElementShape(IElement e) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds();
            }
            return shape;
        }
    }
}

