/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import java.util.HashMap;
import java.util.Map;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.ui.properties.widgets.modules.ModuleParameterOverrideUtils;
import org.simantics.sysdyn.ui.properties.widgets.modules.ParameterNode;

public class ParameterLabelRule
implements LabelRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Object.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (content instanceof ParameterNode) {
            ParameterNode node = (ParameterNode)content;
            String parameterExpression = ModuleParameterOverrideUtils.getParameterExpressionOrOverride(graph, node.getParent(), node.getIndependentVariable());
            String name = node.getIndependentVariable().getName();
            result.put("Parameter in Module", name);
            result.put("Value", parameterExpression);
        }
        return result;
    }
}

