/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.tableParser.ParseException;
import org.simantics.sysdyn.tableParser.TableParser;
import org.simantics.sysdyn.tableParser.Token;
import org.simantics.sysdyn.ui.properties.widgets.expressions.LookupChartPanel;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTAWTComponent;

public class ChartWidget
implements Widget {
    JFreeChart chart;
    LookupChartPanel chartPanel;
    SWTAWTComponent swtawtcomponent;

    public ChartWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.chartPanel = new LookupChartPanel(this.createChart());
        this.chartPanel.setMouseZoomable(true, false);
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.swtawtcomponent = new SWTAWTComponent(parent, 2048){

            protected JComponent createSwingComponent() {
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(1, 1));
                panel.add((Component)((Object)ChartWidget.this.chartPanel));
                panel.doLayout();
                return panel;
            }
        };
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.swtawtcomponent);
        this.swtawtcomponent.populate();
    }

    public void setInput(ISessionContext context, Object input) {
        final Resource expression = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
        try {
            SimanticsUI.getSession().syncRequest((Read)new Read<1Auxiliary>(){

                public 1Auxiliary perform(ReadGraph graph) throws DatabaseException {
                    class Auxiliary {
                        Double minX;
                        Double minY;
                        Double maxX;
                        Double maxY;
                        String table;

                        Auxiliary() {
                        }
                    }
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(expression, sr.WithLookupExpression)) {
                        return null;
                    }
                    Auxiliary auxiliary = new Auxiliary();
                    auxiliary.minX = (Double)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_minX);
                    auxiliary.maxX = (Double)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_maxX);
                    auxiliary.minY = (Double)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_minY);
                    auxiliary.maxY = (Double)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_maxY);
                    auxiliary.table = (String)graph.getPossibleRelatedValue(expression, sr.WithLookupExpression_lookup);
                    return auxiliary;
                }
            }, (Listener)new Listener<1Auxiliary>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(1Auxiliary result) {
                    if (result == null) {
                        return;
                    }
                    XYDataset dataset = ChartWidget.this.createDataset(result.table);
                    ChartWidget.this.chartPanel.resetChart(dataset);
                    ChartWidget.this.chartPanel.addSeriesChangeListener(new _SeriesChangeListener(expression));
                    XYPlot plot = (XYPlot)ChartWidget.this.chart.getPlot();
                    ValueAxis rangeAxis = plot.getRangeAxis();
                    rangeAxis.setAutoRange(false);
                    if (result.minY == null) {
                        result.minY = rangeAxis.getLowerBound();
                    }
                    if (result.maxY == null) {
                        result.maxY = rangeAxis.getUpperBound();
                    }
                    rangeAxis.setRange(result.minY.doubleValue(), result.maxY.doubleValue());
                    ValueAxis domainAxis = plot.getDomainAxis();
                    domainAxis.setAutoRange(false);
                    if (result.minX == null) {
                        result.minX = domainAxis.getLowerBound();
                    }
                    if (result.maxX == null) {
                        result.maxX = domainAxis.getUpperBound();
                    }
                    domainAxis.setRange(result.minX.doubleValue(), result.maxX.doubleValue());
                }

                public boolean isDisposed() {
                    return ChartWidget.this.swtawtcomponent.isDisposed();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private JFreeChart createChart() {
        XYDataset dataset = this.createDataset(null);
        this.chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setBaseFillPaint((Paint)Color.white);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
        return this.chart;
    }

    public XYDataset createDataset(String table) {
        XYSeries series = new XYSeries((Comparable)((Object)"Series"));
        if (table != null) {
            TableParser parser = new TableParser((Reader)new StringReader(""));
            parser.ReInit((Reader)new StringReader(table));
            try {
                parser.table();
                ArrayList xTokens = parser.getXTokens();
                ArrayList yTokens = parser.getYTokens();
                int i = 0;
                while (i < xTokens.size()) {
                    series.add(Double.parseDouble(((Token)xTokens.get((int)i)).image), Double.parseDouble(((Token)yTokens.get((int)i)).image));
                    ++i;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public LookupChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private class _SeriesChangeListener
    implements SeriesChangeListener {
        Resource expression;

        public _SeriesChangeListener(Resource expression) {
            this.expression = expression;
        }

        public void seriesChanged(SeriesChangeEvent event) {
            if (ChartWidget.this.chartPanel.isDragging()) {
                return;
            }
            StringBuilder b = new StringBuilder();
            b.append("{");
            XYSeriesCollection collection = (XYSeriesCollection)((XYPlot)ChartWidget.this.chart.getPlot()).getDataset();
            XYSeries series = collection.getSeries(0);
            if (series.isEmpty()) {
                return;
            }
            Iterator iterator = series.getItems().iterator();
            while (iterator.hasNext()) {
                XYDataItem item = (XYDataItem)iterator.next();
                b.append("{" + item.getX() + "," + item.getY() + "}");
                if (!iterator.hasNext()) continue;
                b.append(",");
            }
            b.append("}");
            final String table = b.toString();
            SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(_SeriesChangeListener.this.expression, sr.WithLookupExpression_lookup, (Object)table);
                }
            });
        }
    }
}

