/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.preferences;

import gnu.trove.set.hash.THashSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPropertySubscription;

public class SysdynDiagramPropertySupport {
    public static SysdynDiagramPropertySupport INSTANCE = new SysdynDiagramPropertySupport();
    private Set<String> diagramProperties;
    private THashSet<SysdynDiagramPropertySubscription> subscriptions = new THashSet();
    private SysdynDiagramPropertySubscription[] subscriptionSnapshot = null;

    private void add(String property) {
        this.diagramProperties.add(property);
        String useDefault = SysdynDiagramPreferences.getUseDefaultProperty(property);
        if (useDefault != null) {
            this.diagramProperties.add(useDefault);
        }
    }

    public SysdynDiagramPropertySupport() {
        this.diagramProperties = new HashSet<String>();
        for (String property : SysdynDiagramPreferences.colorPreferenceNames.values()) {
            this.add(property);
        }
        this.add(SysdynDiagramPreferences.DEFAULT_COLOR);
        this.add(SysdynDiagramPreferences.DEFAULT_FONT);
        for (String property : SysdynDiagramPreferences.fontPreferenceNames.values()) {
            this.add(property);
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getProperty();
                if (SysdynDiagramPropertySupport.this.diagramProperties.contains(propertyName)) {
                    SysdynDiagramPropertySubscription[] sysdynDiagramPropertySubscriptionArray = SysdynDiagramPropertySupport.this.getSubscriptionSnapshot();
                    int n = sysdynDiagramPropertySubscriptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SysdynDiagramPropertySubscription subscription = sysdynDiagramPropertySubscriptionArray[n2];
                        String p = subscription.getPropertyName();
                        String p2 = SysdynDiagramPreferences.getPreferenceName(p);
                        String dp = SysdynDiagramPreferences.getUseDefaultProperty(subscription.getPropertyName());
                        if (propertyName.equals(p) || propertyName.equals(p2) || propertyName.equals(dp)) {
                            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                            String result = store.getString(p2);
                            subscription.getListener().execute((Object)result);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SysdynDiagramPropertySubscription subscription) {
        assert (subscription != null);
        THashSet<SysdynDiagramPropertySubscription> tHashSet = this.subscriptions;
        synchronized (tHashSet) {
            this.subscriptions.add((Object)subscription);
            this.subscriptionSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SysdynDiagramPropertySubscription subscription) {
        assert (subscription != null);
        THashSet<SysdynDiagramPropertySubscription> tHashSet = this.subscriptions;
        synchronized (tHashSet) {
            this.subscriptions.remove((Object)subscription);
            this.subscriptionSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysdynDiagramPropertySubscription[] getSubscriptionSnapshot() {
        SysdynDiagramPropertySubscription[] snapshot = this.subscriptionSnapshot;
        if (snapshot == null) {
            THashSet<SysdynDiagramPropertySubscription> tHashSet = this.subscriptions;
            synchronized (tHashSet) {
                snapshot = this.subscriptionSnapshot;
                if (snapshot == null) {
                    this.subscriptionSnapshot = (SysdynDiagramPropertySubscription[])this.subscriptions.toArray((Object[])new SysdynDiagramPropertySubscription[this.subscriptions.size()]);
                    snapshot = this.subscriptionSnapshot;
                }
            }
        }
        return snapshot;
    }
}

