/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.preferences;

import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.Activator;

public class SysdynDiagramPreferences {
    public static String DEFAULT_COLOR = "Default color";
    public static String DEFAULT_FONT = "Default font";
    public static String ARROW_COLOR = "Arrow color";
    public static String ARROW_STOCK_INITIAL_COLOR = "Arrow stock initial color";
    public static String FLOW_COLOR = "Flow color";
    public static String AUXILIARY_COLOR = "Auxiliary color";
    public static String CLOUD_COLOR = "Cloud color";
    public static String STOCK_COLOR = "Stock color";
    public static String VALVE_COLOR = "Valve color";
    public static String INPUT_COLOR = "Input color";
    public static String MODULE_COLOR = "Module color";
    public static HashMap<String, String> colorPreferenceNames = new HashMap();
    public static String ARROW_USE_DEFAULT_COLOR;
    public static String ARROW_STOCK_INITIAL_USE_DEFAULT_COLOR;
    public static String FLOW_USE_DEFAULT_COLOR;
    public static String AUXILIARY_USE_DEFAULT_COLOR;
    public static String CLOUD_USE_DEFAULT_COLOR;
    public static String STOCK_USE_DEFAULT_COLOR;
    public static String VALVE_USE_DEFAULT_COLOR;
    public static String INPUT_USE_DEFAULT_COLOR;
    public static String MODULE_USE_DEFAULT_COLOR;
    public static HashMap<String, String> colorDefaults;
    public static String ARROW_FONT;
    public static String AUXILIARY_FONT;
    public static String CLOUD_FONT;
    public static String STOCK_FONT;
    public static String VALVE_FONT;
    public static String INPUT_FONT;
    public static String MODULE_FONT;
    public static HashMap<String, String> fontPreferenceNames;
    public static String ARROW_USE_DEFAULT_FONT;
    public static String AUXILIARY_USE_DEFAULT_FONT;
    public static String CLOUD_USE_DEFAULT_FONT;
    public static String STOCK_USE_DEFAULT_FONT;
    public static String VALVE_USE_DEFAULT_FONT;
    public static String INPUT_USE_DEFAULT_FONT;
    public static String MODULE_USE_DEFAULT_FONT;
    public static HashMap<String, String> fontDefaults;

    static {
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/DependencyConnection", ARROW_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/DependencyConnection_stockInitial", ARROW_STOCK_INITIAL_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/FlowConnection", FLOW_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/AuxiliarySymbol", AUXILIARY_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/CloudSymbol", CLOUD_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/StockSymbol", STOCK_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/ValveSymbol", VALVE_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/InputSymbol", INPUT_COLOR);
        colorPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/ModuleSymbol", MODULE_COLOR);
        ARROW_USE_DEFAULT_COLOR = "Arrow use default color";
        ARROW_STOCK_INITIAL_USE_DEFAULT_COLOR = "Arrow stock initial use default color";
        FLOW_USE_DEFAULT_COLOR = "Flow use default color";
        AUXILIARY_USE_DEFAULT_COLOR = "Auxiliary use default color";
        CLOUD_USE_DEFAULT_COLOR = "Cloud use default color";
        STOCK_USE_DEFAULT_COLOR = "Stock use default color";
        VALVE_USE_DEFAULT_COLOR = "Valve use default color";
        INPUT_USE_DEFAULT_COLOR = "Input use default color";
        MODULE_USE_DEFAULT_COLOR = "Module use default color";
        colorDefaults = new HashMap();
        colorDefaults.put(ARROW_COLOR, ARROW_USE_DEFAULT_COLOR);
        colorDefaults.put(ARROW_STOCK_INITIAL_COLOR, ARROW_STOCK_INITIAL_USE_DEFAULT_COLOR);
        colorDefaults.put(FLOW_COLOR, FLOW_USE_DEFAULT_COLOR);
        colorDefaults.put(AUXILIARY_COLOR, AUXILIARY_USE_DEFAULT_COLOR);
        colorDefaults.put(CLOUD_COLOR, CLOUD_USE_DEFAULT_COLOR);
        colorDefaults.put(STOCK_COLOR, STOCK_USE_DEFAULT_COLOR);
        colorDefaults.put(VALVE_COLOR, VALVE_USE_DEFAULT_COLOR);
        colorDefaults.put(INPUT_COLOR, INPUT_USE_DEFAULT_COLOR);
        colorDefaults.put(MODULE_COLOR, MODULE_USE_DEFAULT_COLOR);
        ARROW_FONT = "Arrow font";
        AUXILIARY_FONT = "Auxiliary font";
        CLOUD_FONT = "Cloud font";
        STOCK_FONT = "Stock font";
        VALVE_FONT = "Valve font";
        INPUT_FONT = "Input font";
        MODULE_FONT = "Module font";
        fontPreferenceNames = new HashMap();
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/DependencyConnection", ARROW_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/AuxiliarySymbol", AUXILIARY_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/CloudSymbol", CLOUD_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/StockSymbol", STOCK_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/ValveSymbol", VALVE_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/InputSymbol", INPUT_FONT);
        fontPreferenceNames.put("http://www.simantics.org/Sysdyn-1.1/ModuleSymbol", MODULE_FONT);
        ARROW_USE_DEFAULT_FONT = "Arrow use default font";
        AUXILIARY_USE_DEFAULT_FONT = "Auxiliary use default font";
        CLOUD_USE_DEFAULT_FONT = "Cloud use default font";
        STOCK_USE_DEFAULT_FONT = "Stock use default font";
        VALVE_USE_DEFAULT_FONT = "Valve use default font";
        INPUT_USE_DEFAULT_FONT = "Input use default font";
        MODULE_USE_DEFAULT_FONT = "Module use default font";
        fontDefaults = new HashMap();
        fontDefaults.put(ARROW_FONT, ARROW_USE_DEFAULT_FONT);
        fontDefaults.put(AUXILIARY_FONT, AUXILIARY_USE_DEFAULT_FONT);
        fontDefaults.put(CLOUD_FONT, CLOUD_USE_DEFAULT_FONT);
        fontDefaults.put(STOCK_FONT, STOCK_USE_DEFAULT_FONT);
        fontDefaults.put(VALVE_FONT, VALVE_USE_DEFAULT_FONT);
        fontDefaults.put(INPUT_FONT, INPUT_USE_DEFAULT_FONT);
        fontDefaults.put(MODULE_FONT, MODULE_USE_DEFAULT_FONT);
    }

    public static String getColorPreferenceName(ReadGraph graph, Resource resource) throws DatabaseException {
        String preference = colorPreferenceNames.get(SysdynDiagramPreferences.getSymbolUri(graph, resource));
        return preference;
    }

    public static String getFontPreferenceName(ReadGraph graph, Resource resource) throws DatabaseException {
        String preference = fontPreferenceNames.get(SysdynDiagramPreferences.getSymbolUri(graph, resource));
        return preference;
    }

    private static String getSymbolUri(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource symbol = graph.getSingleObject(resource, L0.InstanceOf);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (graph.isInheritedFrom(symbol, SR.ModuleSymbol)) {
            symbol = SR.ModuleSymbol;
        }
        return graph.getURI(symbol);
    }

    public static String getUseDefaultProperty(String property) {
        String result = colorDefaults.get(property);
        if (result == null) {
            result = fontDefaults.get(property);
        }
        return result;
    }

    public static String getPreferenceName(String property) {
        String useDefault = fontDefaults.get(property);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (useDefault != null && store.getBoolean(useDefault)) {
            return DEFAULT_FONT;
        }
        useDefault = colorDefaults.get(property);
        if (useDefault != null && store.getBoolean(useDefault)) {
            return DEFAULT_COLOR;
        }
        return property;
    }
}

