/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public class FlowArrowLineStyle
implements ILineEndStyle,
Serializable {
    private static final long serialVersionUID = 5348566089660986479L;
    public static final double length = 4.0;
    public static final double width = 2.0;
    public static final double space = 0.0;
    protected ArrowType type = ArrowType.None;
    protected Path2D path;
    protected double lineEndLength = 0.0;
    protected Color color;

    public FlowArrowLineStyle(String desc, Color color) {
        double l = 4.0;
        double w = 2.0;
        double s = 0.0;
        this.color = color != null ? color : Color.BLACK;
        StringTokenizer tokenizer = new StringTokenizer(desc);
        if (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            this.type = this.parseType(type);
            if (tokenizer.hasMoreTokens()) {
                String ls = tokenizer.nextToken();
                l = this.parseSize(ls, 4.0);
                if (tokenizer.hasMoreTokens()) {
                    String ws = tokenizer.nextToken();
                    w = this.parseSize(ws, 2.0);
                    if (tokenizer.hasMoreTokens()) {
                        String ss = tokenizer.nextToken();
                        s = this.parseSize(ss, 0.0);
                    }
                }
            }
            if (this.type != ArrowType.None) {
                this.path = FlowArrowLineStyle.arrow(l, w, s);
                this.lineEndLength = l + s;
            }
        }
    }

    public void render(Graphics2D g, double x, double y, int dir) {
        if (this.type == ArrowType.None || this.path == null) {
            return;
        }
        AffineTransform old = g.getTransform();
        g.translate(x, y);
        g.rotate((double)dir * Math.PI * 0.5);
        g.setColor(this.color);
        switch (this.type) {
            case Fill: {
                g.fill(this.path);
                break;
            }
            case Stroke: {
                g.draw(this.path);
                break;
            }
        }
        g.setTransform(old);
    }

    public double getLineEndLength(int direction) {
        return this.lineEndLength;
    }

    private static Path2D arrow(double length, double width, double space) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(-space, 0.0);
        path.lineTo(-length - space, -width);
        path.lineTo(-length - space, width);
        path.closePath();
        return path;
    }

    private double parseSize(String size, double defaultValue) {
        try {
            return Double.parseDouble(size);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private ArrowType parseType(String type) {
        String lower = type.toLowerCase();
        if ("none".equals(lower)) {
            return ArrowType.None;
        }
        if ("stroke".equals(lower)) {
            return ArrowType.Stroke;
        }
        if ("fill".equals(lower)) {
            return ArrowType.Fill;
        }
        throw new IllegalArgumentException("unrecognized arrow type: " + type);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + (Object)((Object)this.type) + ", " + this.path + "]";
    }

    public static enum ArrowType {
        None,
        Stroke,
        Fill;

    }
}

