/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.ComponentBase;
import org.simantics.structural.synchronization.base.ConnectionUpdateRule;
import org.simantics.structural.synchronization.base.ModuleUpdateContext;
import org.simantics.structural.synchronization.base.PropertyUpdateRule;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;

public abstract class ModuleUpdaterBase<T extends ComponentBase<T>> {
    public String moduleType;
    public THashMap<String, PropertyUpdateRule<T>> propertyUpdateRules = new THashMap();
    public THashMap<String, ConnectionUpdateRule<T>> connectionUpdateRules = new THashMap();
    public boolean isUserComponent;
    public boolean isComposite;
    public String subprocessType;

    public ModuleUpdaterBase(String moduleType) {
        this.moduleType = moduleType;
    }

    public void addPropertyUpdateRule(PropertyUpdateRule<T> rule) {
        this.propertyUpdateRules.put((Object)rule.getPropertyName(), rule);
    }

    public void addConnectionUpdateRule(ConnectionUpdateRule<T> rule) {
        this.connectionUpdateRules.put((Object)rule.getConnectionPointName(), rule);
    }

    public void create(ModuleUpdateContext<T> context, Collection<SerializedVariable> properties, Collection<Connection> connections) {
        context.command = this.createAddCommandBuilder(context.getModuleName());
        this.applyRules(context, true, properties, connections);
    }

    public abstract CommandBuilder createAddCommandBuilder(String var1);

    public void update(ModuleUpdateContext<T> context, Collection<SerializedVariable> properties, Collection<Connection> connections) {
        int moduleTypeId = context.getSolver().getModuleType(context.getModuleId());
        String moduleTypeName = context.getSolver().getName(moduleTypeId);
        if (!moduleTypeName.equals(this.moduleType)) {
            context.getSolver().remove(context.getModuleId());
            ((ComponentBase)context.component).componentId = -1;
            context.setModuleId(-1);
            this.create(context, properties, connections);
        } else {
            context.command = this.createUpdateCommandBuilder(context.getModuleName());
            this.applyRules(context, false, properties, connections);
        }
    }

    public abstract CommandBuilder createUpdateCommandBuilder(String var1);

    private void applyRules(ModuleUpdateContext<T> context, boolean inCreate, Collection<SerializedVariable> properties, Collection<Connection> connections) {
        Object rule;
        THashMap propertyMap = new THashMap(properties.size());
        THashMap connectionMap = connections.isEmpty() ? Collections.emptyMap() : new THashMap(connections.size());
        for (SerializedVariable property : properties) {
            propertyMap.put((Object)property.name, (Object)property.value);
        }
        for (Connection connection : connections) {
            connectionMap.put(connection.relation, connection.connectionPoints);
        }
        context.incPendingCount();
        for (SerializedVariable property : properties) {
            rule = (PropertyUpdateRule)this.propertyUpdateRules.get((Object)property.name);
            if (rule != null) {
                rule.apply(context, inCreate, (Map<String, Variant>)propertyMap, (Map<String, Collection<String>>)connectionMap, property.value);
                continue;
            }
            if (!property.name.equals("IsAttached")) continue;
        }
        if (inCreate) {
            for (Connection connection : connections) {
                rule = (ConnectionUpdateRule)this.connectionUpdateRules.get((Object)connection.relation);
                if (rule == null) continue;
                rule.apply(context, (Map<String, Variant>)propertyMap, connection.connectionPoints);
            }
        } else {
            THashMap unusedConnectionUpdateRules = new THashMap(this.connectionUpdateRules);
            for (Connection connection : connections) {
                ConnectionUpdateRule rule2 = (ConnectionUpdateRule)unusedConnectionUpdateRules.remove((Object)connection.relation);
                if (rule2 == null) continue;
                rule2.apply(context, (Map<String, Variant>)propertyMap, connection.connectionPoints);
            }
            for (ConnectionUpdateRule rule3 : unusedConnectionUpdateRules.values()) {
                rule3.apply(context, (Map<String, Variant>)propertyMap, Collections.emptyList());
            }
        }
        context.decPendingCount();
    }
}

