/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.ui.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.InternalException;
import org.simantics.db.procore.ui.internal.DatabaseCorruptedHandler;
import org.simantics.db.procore.ui.internal.DatabaseLastExitHandler;
import org.simantics.db.procore.ui.internal.DatabaseProtocolHandler;
import org.simantics.db.procore.ui.internal.DatabaseStartHandler;
import org.simantics.db.procore.ui.internal.DatabaseVersionHandler;
import org.simantics.db.procore.ui.internal.DefaultHandler;
import org.simantics.db.procore.ui.internal.GuardFileVersionHandler;
import org.simantics.db.procore.ui.internal.Handler;
import org.simantics.db.procore.ui.internal.HandlerUtil;
import org.simantics.db.server.DatabaseCorruptedException;
import org.simantics.db.server.DatabaseLastExitException;
import org.simantics.db.server.DatabaseProtocolException;
import org.simantics.db.server.DatabaseStartException;
import org.simantics.db.server.DatabaseVersionException;
import org.simantics.db.server.GuardFileVersionException;
import org.simantics.db.server.ProCoreException;

public class UI {
    static Map<Long, Handler> startHandlers = new HashMap<Long, Handler>();

    static {
        startHandlers.put(GuardFileVersionException.getHandlerId(), new GuardFileVersionHandler());
        startHandlers.put(DatabaseCorruptedException.getHandlerId(), new DatabaseCorruptedHandler());
        startHandlers.put(DatabaseStartException.getHandlerId(), new DatabaseStartHandler());
        startHandlers.put(DatabaseVersionException.getHandlerId(), new DatabaseVersionHandler());
        startHandlers.put(DatabaseLastExitException.getHandlerId(), new DatabaseLastExitHandler());
        startHandlers.put(DatabaseProtocolException.getHandlerId(), new DatabaseProtocolHandler());
    }

    public static boolean delete(Shell shell, File folder) {
        return HandlerUtil.delete(shell, folder, "Database Delete", null);
    }

    public static boolean purge(Shell shell, File folder) {
        return HandlerUtil.purge(shell, folder, "Database Purge", null);
    }

    public static boolean handleStart(Shell shell, InternalException e) throws ProCoreException {
        if (!(e instanceof ProCoreException)) {
            return false;
        }
        ProCoreException pce = (ProCoreException)e;
        Handler handler = UI.getStart(pce);
        assert (handler != null);
        return handler.start(shell, pce);
    }

    public static Display getDisplay() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        return d;
    }

    private static <E extends ProCoreException> long getId(E pe) {
        long id = 0L;
        try {
            Method m = ((Object)pe).getClass().getMethod("getHandlerId", new Class[0]);
            Object value = m.invoke(null, new Object[0]);
            id = (Long)value;
        }
        catch (RuntimeException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
        return id;
    }

    private static <E extends ProCoreException> Handler getStart(E e) {
        Handler h = startHandlers.get(UI.getId(e));
        if (h == null) {
            return new DefaultHandler();
        }
        return h;
    }
}

