/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;

public class Properties {
    public static boolean synchronizePrimitivePropertyValue(WriteGraph graph, Resource from, Resource to, Resource property) throws DatabaseException {
        Statement templateStm = graph.getPossibleStatement(from, property);
        Statement instanceStm = graph.getPossibleStatement(to, property);
        if (templateStm == null && instanceStm == null) {
            return false;
        }
        if (templateStm == null) {
            graph.deny(instanceStm);
            RemoverUtil.remove((WriteGraph)graph, (Resource)instanceStm.getObject());
            return true;
        }
        if (instanceStm == null) {
            Resource copiedLabel = CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)templateStm.getObject(), null);
            graph.claim(to, property, copiedLabel);
            return true;
        }
        boolean templateAsserted = templateStm.isAsserted(from);
        boolean instanceAsserted = instanceStm.isAsserted(to);
        if (templateAsserted && instanceAsserted) {
            return false;
        }
        if (templateAsserted) {
            graph.denyValue(to, property);
        } else if (instanceAsserted) {
            Resource copiedLabel = CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)templateStm.getObject(), null);
            graph.claim(to, property, copiedLabel);
        } else {
            Set instanceTypes;
            Set templateTypes = graph.getTypes(templateStm.getObject());
            if (Collections.disjoint(templateTypes, instanceTypes = graph.getTypes(instanceStm.getObject()))) {
                graph.denyValue(to, property);
                Resource copiedValue = CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)templateStm.getObject(), null);
                graph.claim(to, property, copiedValue);
            } else {
                Object instanceValue;
                Datatype dt = graph.getDataType(templateStm.getObject());
                Binding binding = Bindings.getBinding((Datatype)dt);
                Object templateValue = graph.getPossibleValue(templateStm.getObject(), binding);
                if (ObjectUtils.objectEquals((Object)templateValue, (Object)(instanceValue = graph.getPossibleValue(instanceStm.getObject(), binding)))) {
                    return false;
                }
                if (templateValue == null) {
                    graph.denyValue(instanceStm.getObject());
                } else {
                    graph.claimValue(instanceStm.getObject(), templateValue, binding);
                }
            }
        }
        return true;
    }

    public static boolean synchronizeDeepPropertyValue(WriteGraph graph, Resource from, Resource to, Resource property) throws DatabaseException {
        Statement templateStm = graph.getPossibleStatement(from, property);
        Statement instanceStm = graph.getPossibleStatement(to, property);
        if (templateStm == null || instanceStm == null) {
            return false;
        }
        boolean templateAsserted = templateStm.isAsserted(from);
        boolean instanceAsserted = instanceStm.isAsserted(to);
        if (templateAsserted && instanceAsserted) {
            return false;
        }
        if (templateAsserted) {
            graph.deny(instanceStm);
            RemoverUtil.remove((WriteGraph)graph, (Resource)instanceStm.getObject());
            return true;
        }
        if (instanceAsserted) {
            Resource copied = CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)templateStm.getObject(), null);
            graph.claim(to, property, copied);
            return true;
        }
        return Layer0Utils.merge((WriteGraph)graph, (Resource)templateStm.getObject(), (Resource)instanceStm.getObject());
    }

    public static boolean synchronizeEnumerationPropertyValue(WriteGraph graph, Resource from, Resource to, Resource property) throws DatabaseException {
        Statement templateStm = graph.getPossibleStatement(from, property);
        Statement instanceStm = graph.getPossibleStatement(to, property);
        if (templateStm == null && instanceStm == null) {
            return false;
        }
        if (templateStm == null) {
            graph.deny(instanceStm);
            return true;
        }
        if (instanceStm == null) {
            graph.claim(to, property, templateStm.getObject());
            return true;
        }
        boolean templateAsserted = templateStm.isAsserted(from);
        boolean instanceAsserted = instanceStm.isAsserted(to);
        if (templateAsserted && instanceAsserted) {
            return false;
        }
        if (templateAsserted) {
            graph.denyValue(to, property);
        } else if (instanceAsserted) {
            graph.claim(to, property, templateStm.getObject());
        } else {
            if (templateStm.getObject().equals(instanceStm.getObject())) {
                return false;
            }
            graph.deny(instanceStm);
            graph.claim(to, property, templateStm.getObject());
        }
        return true;
    }

    public static boolean synchronizeTag(WriteGraph graph, Resource from, Resource to, Resource tag) throws DatabaseException {
        boolean toHas;
        boolean fromHas = graph.hasStatement(from, tag);
        if (fromHas == (toHas = graph.hasStatement(to, tag))) {
            return false;
        }
        if (fromHas) {
            graph.claim(to, tag, to);
        } else {
            graph.deny(to, tag);
        }
        return true;
    }
}

